/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.internal.util;

import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.internal.util.FeatureFlaggingUtils;
import org.mule.runtime.module.artifact.internal.util.test.DeploymentTestingFeatures;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.size.SmallTest;

@SmallTest
@Story(value="Feature Flagging")
@Issue(value="MULE-19402")
public class FeatureFlaggingUtilsTestCase {
    private final ArtifactDescriptor artifactDescriptor = (ArtifactDescriptor)Mockito.mock(ArtifactDescriptor.class);
    @Rule
    public SystemProperty systemProperty = new SystemProperty("overrideable.feature.override", "true");

    @BeforeClass
    public static void registerTestingFeatures() {
        ((Object)((Object)DeploymentTestingFeatures.ALWAYS_ON_FEATURE)).getClass();
    }

    @Before
    public void before() {
        Mockito.when((Object)this.artifactDescriptor.getName()).thenReturn((Object)"test-artifact");
    }

    @Test
    @Issue(value="MULE-19402")
    public void testFeature() {
        MatcherAssert.assertThat((Object)FeatureFlaggingUtils.isFeatureEnabled((Feature)DeploymentTestingFeatures.ALWAYS_ON_FEATURE, (ArtifactDescriptor)this.artifactDescriptor), (Matcher)Matchers.is((Object)true));
    }

    @Test
    @Issue(value="MULE-19402")
    public void testOverriddenFeature() {
        MatcherAssert.assertThat((Object)FeatureFlaggingUtils.isFeatureEnabled((Feature)DeploymentTestingFeatures.OVERRIDEABLE_FEATURE, (ArtifactDescriptor)this.artifactDescriptor), (Matcher)Matchers.is((Object)true));
    }
}

