/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.classloader.test;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderFilter;
import org.mule.runtime.module.artifact.api.classloader.ExportedService;
import org.mule.runtime.module.artifact.api.classloader.FilteringArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.exception.NotExportedClassException;
import org.mule.tck.classlaoder.TestClassLoader;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.util.EnumerationMatcher;

@RunWith(value=Parameterized.class)
public class FilteringArtifactClassLoaderTestCase
extends AbstractMuleTestCase {
    private static final String CLASS_NAME = "java.lang.Object";
    private static final String CLASS_PACKAGE_NAME = "java.lang";
    private static final String ANOTHER_CLASS_NAME = "java.util.Collection";
    private static final String ANOTHER_CLASS_PACKAGE_NAME = "java.util";
    public static final String RESOURCE_NAME = "dummy.txt";
    private static final String SERVICE_INTERFACE_NAME = "org.foo.Service";
    private static final String SERVICE_RESOURCE_NAME = "META-INF/services/org.foo.Service";
    @Rule
    public ExpectedException expected = ExpectedException.none();
    public boolean verboseClassloadingLog;
    @Rule
    public SystemProperty verboseClassloading;
    protected FilteringArtifactClassLoader filteringArtifactClassLoader;
    protected final ClassLoaderFilter filter = (ClassLoaderFilter)Mockito.mock(ClassLoaderFilter.class);
    protected final ArtifactClassLoader artifactClassLoader = (ArtifactClassLoader)Mockito.mock(ArtifactClassLoader.class);

    @Parameterized.Parameters(name="verbose: {0}")
    public static Collection<Object[]> params() {
        return Arrays.asList({true}, {false});
    }

    public FilteringArtifactClassLoaderTestCase(boolean verboseClassloadingLog) {
        this.verboseClassloadingLog = verboseClassloadingLog;
        this.verboseClassloading = new SystemProperty("mule.classloading.verbose", Boolean.toString(verboseClassloadingLog));
    }

    @Before
    public void before() {
        Mockito.when((Object)this.artifactClassLoader.getArtifactId()).thenReturn((Object)"mockArtifact");
    }

    @Test
    public void throwClassNotFoundErrorWhenClassIsNotExported() throws ClassNotFoundException {
        this.expected.expect(NotExportedClassException.class);
        if (this.verboseClassloadingLog) {
            this.expected.expectMessage(Matchers.is((Object)("Class 'java.lang.Object' not found in classloader for artifact 'mockArtifact'." + System.lineSeparator() + this.filter.toString())));
        } else {
            this.expected.expectMessage(Matchers.is((Object)"Class 'java.lang.Object' not found in classloader for artifact 'mockArtifact'."));
        }
        Mockito.when((Object)this.filter.exportsClass(CLASS_NAME)).thenReturn((Object)false);
        this.filteringArtifactClassLoader = this.doCreateClassLoader(Collections.emptyList());
        this.filteringArtifactClassLoader.loadClass(CLASS_NAME);
    }

    protected FilteringArtifactClassLoader doCreateClassLoader(List<ExportedService> exportedServices) {
        return new FilteringArtifactClassLoader(this.artifactClassLoader, this.filter, exportedServices);
    }

    protected Package[] getPackages(FilteringArtifactClassLoader classLoader) {
        try {
            Method getPackagesMethod = FilteringArtifactClassLoader.class.getDeclaredMethod("getPackages", new Class[0]);
            getPackagesMethod.setAccessible(true);
            return (Package[])getPackagesMethod.invoke((Object)classLoader, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    protected Package getPackage(FilteringArtifactClassLoader classLoader, String name) {
        try {
            Method getPackageMethod = FilteringArtifactClassLoader.class.getDeclaredMethod("getPackage", String.class);
            getPackageMethod.setAccessible(true);
            return (Package)getPackageMethod.invoke((Object)classLoader, name);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void loadsExportedClass() throws ClassNotFoundException {
        TestClassLoader classLoader = new TestClassLoader(null);
        Class<?> expectedClass = ((Object)((Object)this)).getClass();
        classLoader.addClass(CLASS_NAME, expectedClass);
        Mockito.when((Object)this.filter.exportsClass(CLASS_NAME)).thenReturn((Object)true);
        Mockito.when((Object)this.artifactClassLoader.getClassLoader()).thenReturn((Object)classLoader);
        this.filteringArtifactClassLoader = this.doCreateClassLoader(Collections.emptyList());
        Class aClass = this.filteringArtifactClassLoader.loadClass(CLASS_NAME);
        Assert.assertThat((Object)aClass, (Matcher)CoreMatchers.equalTo(expectedClass));
    }

    @Test
    public void filtersResourceWhenNotExported() throws ClassNotFoundException {
        Mockito.when((Object)this.filter.exportsClass(RESOURCE_NAME)).thenReturn((Object)false);
        this.filteringArtifactClassLoader = this.doCreateClassLoader(Collections.emptyList());
        URL resource = this.filteringArtifactClassLoader.getResource(RESOURCE_NAME);
        Assert.assertThat((Object)resource, (Matcher)CoreMatchers.equalTo(null));
    }

    @Test
    public void loadsExportedResource() throws ClassNotFoundException, IOException {
        URL expectedResource = new URL("file:///app.txt");
        Mockito.when((Object)this.filter.exportsResource(RESOURCE_NAME)).thenReturn((Object)true);
        Mockito.when((Object)this.artifactClassLoader.findResource(RESOURCE_NAME)).thenReturn((Object)expectedResource);
        this.filteringArtifactClassLoader = this.doCreateClassLoader(Collections.emptyList());
        URL resource = this.filteringArtifactClassLoader.getResource(RESOURCE_NAME);
        Assert.assertThat((Object)resource, (Matcher)CoreMatchers.equalTo((Object)expectedResource));
    }

    @Test
    public void getExportedPackage() throws ClassNotFoundException, IOException {
        TestClassLoader classLoader = new TestClassLoader(null);
        classLoader.addClass(CLASS_NAME, ((Object)((Object)this)).getClass());
        Mockito.when((Object)this.filter.exportsPackage(CLASS_PACKAGE_NAME)).thenReturn((Object)true);
        Mockito.when((Object)this.artifactClassLoader.getClassLoader()).thenReturn((Object)classLoader);
        this.filteringArtifactClassLoader = this.doCreateClassLoader(Collections.emptyList());
        Package aPackage = this.getPackage(this.filteringArtifactClassLoader, CLASS_PACKAGE_NAME);
        Assert.assertThat((Object)aPackage.getName(), (Matcher)CoreMatchers.equalTo((Object)CLASS_PACKAGE_NAME));
    }

    @Test
    public void getExportedPackages() throws ClassNotFoundException, IOException {
        TestClassLoader classLoader = new TestClassLoader(null);
        classLoader.addClass(CLASS_NAME, ((Object)((Object)this)).getClass());
        classLoader.addClass(ANOTHER_CLASS_NAME, ((Object)((Object)this)).getClass());
        Mockito.when((Object)this.filter.exportsPackage(CLASS_PACKAGE_NAME)).thenReturn((Object)true);
        Mockito.when((Object)this.filter.exportsPackage(ANOTHER_CLASS_PACKAGE_NAME)).thenReturn((Object)false);
        Mockito.when((Object)this.artifactClassLoader.getClassLoader()).thenReturn((Object)classLoader);
        this.filteringArtifactClassLoader = this.doCreateClassLoader(Collections.emptyList());
        Package[] packageList = this.getPackages(this.filteringArtifactClassLoader);
        Assert.assertThat((Object)packageList.length, (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)packageList[0].getName(), (Matcher)CoreMatchers.equalTo((Object)CLASS_PACKAGE_NAME));
        Assert.assertThat((Object)this.getPackage(this.filteringArtifactClassLoader, ANOTHER_CLASS_PACKAGE_NAME), (Matcher)Matchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)this.getPackage(this.filteringArtifactClassLoader, ""), (Matcher)Matchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void getNoExportedPackages() throws ClassNotFoundException, IOException {
        TestClassLoader classLoader = new TestClassLoader(null);
        classLoader.addClass(CLASS_NAME, ((Object)((Object)this)).getClass());
        Mockito.when((Object)this.filter.exportsPackage(CLASS_PACKAGE_NAME)).thenReturn((Object)false);
        Mockito.when((Object)this.artifactClassLoader.getClassLoader()).thenReturn((Object)classLoader);
        this.filteringArtifactClassLoader = this.doCreateClassLoader(Collections.emptyList());
        Package[] packageList = this.getPackages(this.filteringArtifactClassLoader);
        Assert.assertThat((Object)packageList.length, (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void loadsExportedService() throws ClassNotFoundException, IOException {
        URL expectedResource = new URL("file:///app.txt");
        this.filteringArtifactClassLoader = this.doCreateClassLoader(Collections.singletonList(new ExportedService(SERVICE_INTERFACE_NAME, expectedResource)));
        URL resource = this.filteringArtifactClassLoader.getResource(SERVICE_RESOURCE_NAME);
        Assert.assertThat((Object)resource, (Matcher)CoreMatchers.equalTo((Object)expectedResource));
        ((ClassLoaderFilter)Mockito.verify((Object)this.filter, (VerificationMode)Mockito.never())).exportsResource(SERVICE_RESOURCE_NAME);
        ((ArtifactClassLoader)Mockito.verify((Object)this.artifactClassLoader, (VerificationMode)Mockito.never())).findResource(SERVICE_RESOURCE_NAME);
    }

    @Test
    public void filtersResources() throws Exception {
        TestClassLoader classLoader = new TestClassLoader(null);
        URL blockedResource = new URL("file:///app.txt");
        classLoader.addResource(RESOURCE_NAME, blockedResource);
        Mockito.when((Object)this.filter.exportsResource(RESOURCE_NAME)).thenReturn((Object)false);
        Mockito.when((Object)this.artifactClassLoader.getClassLoader()).thenReturn((Object)classLoader);
        this.filteringArtifactClassLoader = this.doCreateClassLoader(Collections.emptyList());
        Enumeration resources = this.filteringArtifactClassLoader.getResources(RESOURCE_NAME);
        Assert.assertThat((Object)resources, (Matcher)EnumerationMatcher.equalTo(Collections.emptyList()));
    }

    @Test
    public void getsExportedResources() throws Exception {
        URL resource = new URL("file:/app.txt");
        Mockito.when((Object)this.filter.exportsResource(RESOURCE_NAME)).thenReturn((Object)true);
        Mockito.when((Object)this.artifactClassLoader.findResources(RESOURCE_NAME)).thenReturn(Collections.enumeration(Collections.singleton(resource)));
        this.filteringArtifactClassLoader = this.doCreateClassLoader(Collections.emptyList());
        Enumeration resources = this.filteringArtifactClassLoader.getResources(RESOURCE_NAME);
        Assert.assertThat((Object)resources, (Matcher)EnumerationMatcher.equalTo(Collections.singletonList(resource)));
    }

    @Test
    public void loadsExportedServices() throws ClassNotFoundException, IOException {
        URL expectedResource = new URL("file:///app.txt");
        this.filteringArtifactClassLoader = this.doCreateClassLoader(Collections.singletonList(new ExportedService(SERVICE_INTERFACE_NAME, expectedResource)));
        URL resource = this.filteringArtifactClassLoader.getResource(SERVICE_RESOURCE_NAME);
        Enumeration resources = this.filteringArtifactClassLoader.getResources(SERVICE_RESOURCE_NAME);
        Assert.assertThat((Object)resources, (Matcher)EnumerationMatcher.equalTo(Collections.singletonList(resource)));
        ((ClassLoaderFilter)Mockito.verify((Object)this.filter, (VerificationMode)Mockito.never())).exportsResource(SERVICE_RESOURCE_NAME);
        ((ArtifactClassLoader)Mockito.verify((Object)this.artifactClassLoader, (VerificationMode)Mockito.never())).findResources(SERVICE_RESOURCE_NAME);
    }

    @Test
    public void returnsCorrectClassLoader() throws Exception {
        this.filteringArtifactClassLoader = this.doCreateClassLoader(Collections.emptyList());
        ClassLoader classLoader = this.filteringArtifactClassLoader.getClassLoader();
        Assert.assertThat((Object)classLoader, (Matcher)Matchers.is((Object)this.filteringArtifactClassLoader));
    }

    @Test
    public void doesNotDisposesFilteredClassLoader() throws Exception {
        this.filteringArtifactClassLoader = this.doCreateClassLoader(Collections.emptyList());
        this.filteringArtifactClassLoader.dispose();
        ((ArtifactClassLoader)Mockito.verify((Object)this.artifactClassLoader, (VerificationMode)Mockito.never())).dispose();
    }
}

