/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.internal.util;

import java.io.File;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Test;
import org.mule.runtime.module.artifact.internal.util.FileJarExplorer;
import org.mule.tck.ZipUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class FileJarExplorerTestCase
extends AbstractMuleTestCase {
    private final FileJarExplorer packageExplorer = new FileJarExplorer();

    @Test
    public void readsPackagesFromJar() throws Exception {
        ZipUtils.ZipResource fooClass = new ZipUtils.ZipResource("EchoTest.clazz", "org/foo/Foo.class");
        ZipUtils.ZipResource barClass = new ZipUtils.ZipResource("EchoTest.clazz", "org/bar/Bar.class");
        ZipUtils.ZipResource[] zipResources = new ZipUtils.ZipResource[]{fooClass, barClass};
        File jarFile = File.createTempFile("test", ".jar");
        jarFile.delete();
        ZipUtils.compress((File)jarFile, (ZipUtils.ZipResource[])zipResources);
        Set packages = this.packageExplorer.explore(jarFile.toURI()).getPackages();
        MatcherAssert.assertThat((Object)packages.size(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)packages, (Matcher)IsCollectionContaining.hasItem((Object)"org.foo"));
        MatcherAssert.assertThat((Object)packages, (Matcher)IsCollectionContaining.hasItem((Object)"org.bar"));
    }

    @Test
    public void readsPackagesFromFolder() throws Exception {
        File folder = File.createTempFile("test", "");
        folder.delete();
        folder.mkdirs();
        File orgFolder = new File(folder, "org");
        File orgFooFolder = new File(orgFolder, "foo");
        File orgFooBarFolder = new File(orgFolder, "bar");
        FileUtils.writeStringToFile((File)new File(orgFooFolder, "Foo.class"), (String)"foo");
        FileUtils.writeStringToFile((File)new File(orgFooBarFolder, "Bar.class"), (String)"bar");
        Set packages = this.packageExplorer.explore(folder.toURI()).getPackages();
        MatcherAssert.assertThat((Object)packages.size(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)packages, (Matcher)IsCollectionContaining.hasItem((Object)"org.foo"));
        MatcherAssert.assertThat((Object)packages, (Matcher)IsCollectionContaining.hasItem((Object)"org.bar"));
    }

    @Test
    public void readsResourcesFromFolder() throws Exception {
        File folder = File.createTempFile("test", "");
        folder.delete();
        folder.mkdirs();
        File orgFolder = new File(folder, "org");
        File orgFooFolder = new File(orgFolder, "foo");
        File orgFooBarFolder = new File(orgFolder, "bar");
        FileUtils.writeStringToFile((File)new File(orgFooFolder, "foo.txt"), (String)"foo");
        FileUtils.writeStringToFile((File)new File(orgFooBarFolder, "bar.txt"), (String)"bar");
        Set resources = this.packageExplorer.explore(folder.toURI()).getResources();
        MatcherAssert.assertThat((Object)resources.size(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)resources, (Matcher)IsCollectionContaining.hasItem((Object)"org/foo/foo.txt"));
        MatcherAssert.assertThat((Object)resources, (Matcher)IsCollectionContaining.hasItem((Object)"org/bar/bar.txt"));
    }
}

