/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.builders;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.config.builders.WebappMuleXmlConfigurationBuilder;
import org.mule.runtime.core.api.MuleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class DeployableMuleXmlContextListener
implements ServletContextListener {
    protected final transient Logger logger = LoggerFactory.getLogger(DeployableMuleXmlContextListener.class);
    private WebappMuleXmlConfigurationBuilder configurationBuilder;
    private static MuleContext muleContext;

    public void contextInitialized(ServletContextEvent event) {
        this.initialize(event.getServletContext());
    }

    public void initialize(ServletContext context) {
        String config = context.getInitParameter("org.mule.config");
        if (config == null) {
            config = "mule-config.xml";
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("No Mule config file(s) specified, using default: " + config);
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Mule config file(s): " + config);
        }
        if (muleContext == null) {
            throw new RuntimeException("MuleContext is not available");
        }
        try {
            this.configurationBuilder = new WebappMuleXmlConfigurationBuilder(context, config);
            this.configurationBuilder.setUseDefaultConfigResource(false);
            ApplicationContext parentContext = (ApplicationContext)context.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
            if (parentContext != null) {
                this.configurationBuilder.setParentContext(parentContext);
            }
            this.configurationBuilder.configure(muleContext);
        }
        catch (MuleException ex) {
            context.log(ex.getMessage(), (Throwable)ex);
            ex.printStackTrace();
        }
        catch (Error error) {
            context.log(error.getMessage(), (Throwable)error);
            error.printStackTrace();
            throw error;
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (muleContext != null && this.configurationBuilder != null) {
            this.configurationBuilder.unconfigure(muleContext);
        }
    }

    public static void setMuleContext(MuleContext context) {
        muleContext = context;
    }
}

