/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.builders;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Optional;
import javax.servlet.ServletContext;
import org.mule.runtime.api.app.declaration.ArtifactDeclaration;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.config.spring.MuleArtifactContext;
import org.mule.runtime.config.spring.OptionalObjectsController;
import org.mule.runtime.config.spring.SpringXmlConfigurationBuilder;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigResource;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.deployment.model.internal.application.MuleApplicationClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class WebappMuleXmlConfigurationBuilder
extends SpringXmlConfigurationBuilder {
    protected final transient Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ServletContext context;

    public WebappMuleXmlConfigurationBuilder(ServletContext servletContext, String configResources) throws ConfigurationException {
        super(configResources, Collections.emptyMap(), ArtifactType.APP);
        this.context = servletContext;
    }

    public WebappMuleXmlConfigurationBuilder(ServletContext servletContext, String[] configResources) throws ConfigurationException {
        super(configResources, Collections.emptyMap(), ArtifactType.APP);
        this.context = servletContext;
    }

    protected void doConfigure(MuleContext muleContext) throws Exception {
        if (this.getParentContext() == null) {
            this.setParentContext(this.loadParentContext(this.context));
        }
        super.doConfigure(muleContext);
    }

    protected ConfigResource[] loadConfigResources(String[] configs) throws ConfigurationException {
        try {
            this.artifactConfigResources = new ConfigResource[configs.length];
            for (int i = 0; i < configs.length; ++i) {
                this.artifactConfigResources[i] = new ServletContextOrClassPathConfigResource(configs[i]);
            }
            return this.artifactConfigResources;
        }
        catch (IOException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected MuleArtifactContext doCreateApplicationContext(MuleContext muleContext, ConfigResource[] artifactConfigResources, ArtifactDeclaration artifactDeclaration, OptionalObjectsController optionalObjectsController, Optional<ConfigurationProperties> parentConfigurationPropertiesResolver) {
        Resource[] artifactConfigServletContextResources = this.preProcessResources(artifactConfigResources);
        return new MuleArtifactContext(muleContext, artifactConfigServletContextResources, artifactDeclaration, optionalObjectsController, Optional.empty(), Collections.emptyMap(), ArtifactType.APP, MuleApplicationClassLoader.resolveContextArtifactPluginClassLoaders());
    }

    private Resource[] preProcessResources(ConfigResource[] configResources) {
        Resource[] configServletContextResources = new Resource[configResources.length];
        for (int i = 0; i < configResources.length; ++i) {
            configServletContextResources[i] = new ServletContextOrClassPathResource(this.context, configResources[i].getResourceName());
        }
        return configServletContextResources;
    }

    protected ApplicationContext loadParentContext(ServletContext servletContext) throws BeansException {
        ApplicationContext parentContext = null;
        String locatorFactorySelector = servletContext.getInitParameter("locatorFactorySelector");
        String parentContextKey = servletContext.getInitParameter("parentContextKey");
        if (parentContextKey != null) {
            BeanFactoryLocator locator = ContextSingletonBeanFactoryLocator.getInstance((String)locatorFactorySelector);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Getting parent context definition: using parent context key of '" + parentContextKey + "' with BeanFactoryLocator");
            }
            parentContext = (ApplicationContext)locator.useBeanFactory(parentContextKey).getFactory();
        }
        return parentContext;
    }

    class ServletContextOrClassPathResource
    extends AbstractResource {
        private final ServletContext servletContext;
        private final String path;

        public ServletContextOrClassPathResource(ServletContext servletContext, String path) {
            Assert.notNull((Object)servletContext, (String)"Cannot resolve ServletContextResource without ServletContext");
            this.servletContext = servletContext;
            Assert.notNull((Object)path, (String)"path is required");
            this.path = StringUtils.cleanPath((String)path);
        }

        public String getFilename() {
            return this.path;
        }

        public InputStream getInputStream() throws IOException {
            InputStream is = this.getServletContextInputStream();
            if (is == null) {
                is = this.getClasspathInputStream();
            }
            if (is == null) {
                throw new FileNotFoundException(this.getDescription() + " cannot be opened because it does not exist");
            }
            return is;
        }

        protected InputStream getServletContextInputStream() {
            String servletContextPath = this.path;
            if (!servletContextPath.startsWith("/")) {
                servletContextPath = "/" + servletContextPath;
            }
            return this.servletContext.getResourceAsStream(servletContextPath);
        }

        protected InputStream getClasspathInputStream() {
            String classpathPath = this.path;
            if (classpathPath.startsWith("/")) {
                classpathPath = classpathPath.substring(1);
            }
            return ClassUtils.getDefaultClassLoader().getResourceAsStream(classpathPath);
        }

        public String getDescription() {
            return this.path;
        }
    }

    class ServletContextOrClassPathConfigResource
    extends ConfigResource {
        public ServletContextOrClassPathConfigResource(String resourceName) throws IOException {
            super(resourceName, null);
        }
    }
}

