/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.api;

import java.util.Collections;
import java.util.Set;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.util.StringUtils;

public class MuleModule {
    protected static final String INVALID_PRIVILEGED_API_DEFINITION_ERROR = "Invalid privileged API: both privileged packages and artifacts must be defined";
    private final String name;
    private final Set<String> exportedPackages;
    private final Set<String> exportedPaths;
    private final Set<String> privilegedExportedPackages;
    private final Set<String> privilegedArtifacts;

    public MuleModule(String name, Set<String> exportedPackages, Set<String> exportedPaths, Set<String> privilegedExportedPackages, Set<String> privilegedArtifacts) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)name) ? 1 : 0) != 0, (String)"name cannot be empty");
        Preconditions.checkArgument((exportedPackages != null ? 1 : 0) != 0, (String)"exportedPackages cannot be null");
        Preconditions.checkArgument((exportedPaths != null ? 1 : 0) != 0, (String)"exportedPaths cannot be null");
        Preconditions.checkArgument((privilegedExportedPackages != null ? 1 : 0) != 0, (String)"privilegedExportedPackages cannot be null");
        Preconditions.checkArgument((privilegedArtifacts != null ? 1 : 0) != 0, (String)"privilegedArtifacts cannot be null");
        Preconditions.checkArgument((privilegedArtifacts.isEmpty() && privilegedExportedPackages.isEmpty() || !privilegedArtifacts.isEmpty() && !privilegedExportedPackages.isEmpty() ? 1 : 0) != 0, (String)INVALID_PRIVILEGED_API_DEFINITION_ERROR);
        this.name = name;
        this.exportedPackages = Collections.unmodifiableSet(exportedPackages);
        this.exportedPaths = Collections.unmodifiableSet(exportedPaths);
        this.privilegedExportedPackages = privilegedExportedPackages;
        this.privilegedArtifacts = privilegedArtifacts;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getExportedPackages() {
        return this.exportedPackages;
    }

    public Set<String> getExportedPaths() {
        return this.exportedPaths;
    }

    public Set<String> getPrivilegedExportedPackages() {
        return this.privilegedExportedPackages;
    }

    public Set<String> getPrivilegedArtifacts() {
        return this.privilegedArtifacts;
    }
}

