/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.container.internal.splash;

import static org.mule.runtime.container.internal.splash.SplashScreen.CREDENTIAL_MASK;
import static org.mule.runtime.container.internal.splash.SplashScreen.CUSTOM_NAMES;

import static org.hamcrest.CoreMatchers.containsString;
import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.MatcherAssert.assertThat;

import org.mule.tck.junit4.AbstractMuleTestCase;

import java.util.HashMap;
import java.util.Map;

import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.SetSystemProperty;

@SetSystemProperty(key = CUSTOM_NAMES, value = "prop1,prop2")
class SplashScreenTestCase extends AbstractMuleTestCase {

  @Test
  void splashScreenWithMaskedProperties() throws Exception {
    SplashScreen serverStartupSplashScreen = new ServerStartupSplashScreen();
    Map<String, String> properties = new HashMap<>();
    properties.put("someProp", "someValue");
    properties.put("someKey", "somePasswordSuperSensitive");
    properties.put("key", "someKey");
    properties.put("password", "password... it shouldn't be seen");
    properties.put("anotherPassWoRD", "please, don't");
    properties.put("prop1", "nope");
    properties.put("prop2", "nope2");
    properties.put("prop12", "yes!");
    serverStartupSplashScreen.listItems(properties, "Mule properties");
    String splash = serverStartupSplashScreen.toString();
    assertThat(splash, containsString("someProp = someValue"));
    assertThat(splash, not(containsString("someKey = somePasswordSuperSensitive")));
    assertThat(splash, containsString("someKey = " + CREDENTIAL_MASK));
    assertThat(splash, not(containsString("key = someKey")));
    assertThat(splash, containsString("key = " + CREDENTIAL_MASK));
    assertThat(splash, not(containsString("password = password... it shouldn't be seen")));
    assertThat(splash, containsString("password = " + CREDENTIAL_MASK));
    assertThat(splash, not(containsString("anotherPassWoRD = please, don't")));
    assertThat(splash, containsString("anotherPassWoRD = " + CREDENTIAL_MASK));
    assertThat(splash, not(containsString("prop1 = nope")));
    assertThat(splash, containsString("prop1 = " + CREDENTIAL_MASK));
    assertThat(splash, not(containsString("prop2 = nope2")));
    assertThat(splash, containsString("prop2 = " + CREDENTIAL_MASK));
    assertThat(splash, containsString("prop12 = yes"));
  }

  @Test
  void splashScreenWithNoProperties() throws Exception {
    SplashScreen serverStartupSplashScreen = new ServerStartupSplashScreen();
    Map<String, String> properties = new HashMap<>();
    serverStartupSplashScreen.listItems(properties, "Mule properties");
    String splash = serverStartupSplashScreen.toString();
    assertThat(splash, not(containsString(" = ")));
  }

}
