/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.container.api;

import static org.mule.runtime.container.api.MuleFoldersUtil.getMuleBaseFolder;
import static org.mule.runtime.container.api.MuleFoldersUtil.getMuleHomeFolder;
import static org.mule.runtime.core.api.config.MuleProperties.MULE_BASE_DIRECTORY_PROPERTY;
import static org.mule.runtime.core.api.config.MuleProperties.MULE_HOME_DIRECTORY_PROPERTY;

import static java.nio.file.Files.createFile;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.core.Is.is;

import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

import java.nio.file.Path;

import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.RestoreSystemProperties;

@SmallTest
@RestoreSystemProperties
class MuleFolderUtilTestCase extends AbstractMuleTestCase {

  private static final String EXPECTED_MULE_HOME_VALUE = "expected-mule-home-value";
  private static final String EXPECTED_MULE_BASE_VALUE = "expected-mule-base-value";

  @Test
  void muleHome() throws Exception {
    System.setProperty(MULE_HOME_DIRECTORY_PROPERTY, EXPECTED_MULE_HOME_VALUE);

    assertThat(getMuleHomeFolder().toString(), is(EXPECTED_MULE_HOME_VALUE));
  }

  @Test
  void muleHomeIsNullWhenNotDefined() throws Exception {
    assertThat(getMuleHomeFolder().toString(), is("."));
  }

  @Test
  void muleBase() throws Exception {
    System.setProperty(MULE_HOME_DIRECTORY_PROPERTY, EXPECTED_MULE_HOME_VALUE);
    System.setProperty(MULE_BASE_DIRECTORY_PROPERTY, EXPECTED_MULE_BASE_VALUE);

    final var expectedMuleBase = Path.of(EXPECTED_MULE_BASE_VALUE);
    createFile(expectedMuleBase);

    assertThat(getMuleBaseFolder().toString(), is(expectedMuleBase.toAbsolutePath().toString()));
  }

  @Test
  void muleBaseReturnsMuleHomeWhenNotSet() throws Exception {
    System.setProperty(MULE_HOME_DIRECTORY_PROPERTY, EXPECTED_MULE_HOME_VALUE);

    assertThat(getMuleBaseFolder().toString(), is(EXPECTED_MULE_HOME_VALUE));
  }

  @Test
  void muleBaseReturnsNullIfNetherMuleHomeOrMuleBaseIsSet() throws Exception {
    assertThat(getMuleBaseFolder().toString(), is("."));
  }
}
