/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.internal;

import java.io.InputStream;
import java.lang.module.ModuleDescriptor;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.api.annotation.jpms.PrivilegedApi;
import org.mule.runtime.api.util.MuleSystemProperties;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.container.internal.ClasspathModuleDiscoverer;
import org.mule.runtime.container.internal.ModuleDiscoverer;
import org.mule.runtime.jpms.api.MuleContainerModule;

public class JpmsModuleLayerModuleDiscoverer
implements ModuleDiscoverer {
    private final ClasspathModuleDiscoverer fallbackClasspathModuleDiscoverer;

    public JpmsModuleLayerModuleDiscoverer(ClasspathModuleDiscoverer fallbackClasspathModuleDiscoverer) {
        this.fallbackClasspathModuleDiscoverer = fallbackClasspathModuleDiscoverer;
    }

    @Override
    public List<MuleContainerModule> discover() {
        if (!MuleSystemProperties.classloaderContainerJpmsModuleLayer()) {
            return this.fallbackClasspathModuleDiscoverer.discover();
        }
        List<MuleContainerModule> discoveredModules = this.getClass().getModule().getLayer().modules().stream().map(jpmsModule -> {
            if (jpmsModule.getDescriptor().isAutomatic()) {
                MuleModule muleModule;
                block11: {
                    InputStream stream = jpmsModule.getResourceAsStream("/" + this.fallbackClasspathModuleDiscoverer.getModulePropertiesFileName());
                    try {
                        Properties moduleProperties = new Properties();
                        if (stream != null) {
                            moduleProperties.load(stream);
                        } else {
                            moduleProperties.put("module.name", jpmsModule.getName());
                        }
                        muleModule = this.fallbackClasspathModuleDiscoverer.createModule(moduleProperties);
                        if (stream == null) break block11;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Cannot create fallback muleContainer module for '" + jpmsModule.getName() + "'", e);
                        }
                    }
                    stream.close();
                }
                return muleModule;
            }
            return new JpmsMuleContainerModule((Module)jpmsModule);
        }).collect(Collectors.toList());
        ModuleLayer.boot().modules().stream().filter(jpmsModule -> jpmsModule.getName().startsWith("org.mule.runtime.") || jpmsModule.getName().startsWith("com.mulesoft.mule.")).map(x$0 -> new JpmsMuleContainerModule((Module)x$0)).forEach(discoveredModules::add);
        return discoveredModules;
    }

    public class JpmsMuleContainerModule
    implements MuleContainerModule {
        private final Module jpmsModule;
        private final Set<String> exportedPackages;
        private final Set<String> privilegedExportedPackages;
        private final Set<String> privilegedArtifacts;

        public JpmsMuleContainerModule(Module jpmsModule) {
            this.jpmsModule = jpmsModule;
            this.exportedPackages = Stream.concat(jpmsModule.getDescriptor().exports().stream().filter(export -> export.targets().isEmpty()).map(ModuleDescriptor.Exports::source), jpmsModule.getDescriptor().requires().stream().filter(required -> required.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.TRANSITIVE)).flatMap(required -> {
                Module requiredTransitiveModule = this.getClass().getModule().getLayer().findModule(required.name()).get();
                if (requiredTransitiveModule.getDescriptor().isAutomatic()) {
                    return requiredTransitiveModule.getPackages().stream();
                }
                return requiredTransitiveModule.getDescriptor().exports().stream().filter(export -> export.targets().isEmpty()).map(ModuleDescriptor.Exports::source);
            })).collect(Collectors.toSet());
            if (jpmsModule.isAnnotationPresent(PrivilegedApi.class)) {
                PrivilegedApi privilegedApiAnnotation = jpmsModule.getAnnotation(PrivilegedApi.class);
                this.privilegedExportedPackages = Stream.of(privilegedApiAnnotation.privilegedPackages()).collect(Collectors.toSet());
                this.privilegedArtifacts = Stream.of(privilegedApiAnnotation.privilegedArtifactIds()).collect(Collectors.toSet());
            } else {
                this.privilegedExportedPackages = Collections.emptySet();
                this.privilegedArtifacts = Collections.emptySet();
            }
        }

        public String getName() {
            return this.jpmsModule.getName();
        }

        public Set<String> getExportedPackages() {
            return this.exportedPackages;
        }

        public Set<String> getExportedPaths() {
            return Collections.emptySet();
        }

        public Set<String> getPrivilegedExportedPackages() {
            return this.privilegedExportedPackages;
        }

        public Set<String> getPrivilegedArtifacts() {
            return this.privilegedArtifacts;
        }
    }
}

