/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.application;

import java.net.URL;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactStartedSplashScreen;

public class ApplicationStartedSplashScreen
extends ArtifactStartedSplashScreen<ApplicationDescriptor> {
    @Override
    public void createMessage(ApplicationDescriptor descriptor) {
        this.doBody(String.format("Started app '%s'", descriptor.getName()));
        if (RUNTIME_VERBOSE_PROPERTY.isEnabled()) {
            this.listPlugins(descriptor);
            this.listLibraries(descriptor);
        }
    }

    private void listPlugins(ApplicationDescriptor descriptor) {
        Set plugins = descriptor.getPlugins();
        if (!plugins.isEmpty()) {
            this.doBody("Application plugins:");
            for (ArtifactPluginDescriptor plugin : plugins) {
                this.doBody(String.format(" - %s", plugin.getName()));
            }
        }
    }

    protected void listLibraries(ApplicationDescriptor descriptor) {
        this.listItems(Arrays.stream(descriptor.getClassLoaderModel().getUrls()).map(url -> FileUtils.toFile((URL)url).getName()).collect(Collectors.toList()), "Application libraries:");
    }
}

