/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.policy;

import java.io.File;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPlugin;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplate;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplateDescriptor;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;

public class DefaultPolicyTemplate
implements PolicyTemplate {
    private final String artifactId;
    private final PolicyTemplateDescriptor descriptor;
    private final ArtifactClassLoader policyClassLoader;
    private final List<ArtifactPlugin> artifactPlugins;

    public DefaultPolicyTemplate(String artifactId, PolicyTemplateDescriptor descriptor, ArtifactClassLoader policyClassLoader, List<ArtifactPlugin> artifactPlugins) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)artifactId) ? 1 : 0) != 0, (String)"artifactId cannot be empty");
        Preconditions.checkArgument((descriptor != null ? 1 : 0) != 0, (String)"descriptor cannot be null");
        Preconditions.checkArgument((policyClassLoader != null ? 1 : 0) != 0, (String)"policyClassLoader cannot be null");
        Preconditions.checkArgument((artifactPlugins != null ? 1 : 0) != 0, (String)"artifactPlugins cannot be null");
        this.artifactId = artifactId;
        this.descriptor = descriptor;
        this.policyClassLoader = policyClassLoader;
        this.artifactPlugins = artifactPlugins;
    }

    public String getArtifactName() {
        return this.descriptor.getName();
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public PolicyTemplateDescriptor getDescriptor() {
        return this.descriptor;
    }

    public File[] getResourceFiles() {
        return new File[0];
    }

    public ArtifactClassLoader getArtifactClassLoader() {
        return this.policyClassLoader;
    }

    public void dispose() {
        this.policyClassLoader.dispose();
    }

    public List<ArtifactPlugin> getArtifactPlugins() {
        return this.artifactPlugins;
    }
}

