/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.artifact;

import java.io.File;
import java.io.IOException;
import org.mule.runtime.deployment.model.api.DeployableArtifact;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactFactory;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactFactoryUtils;
import org.mule.runtime.module.license.api.LicenseValidator;

public abstract class AbstractDeployableArtifactFactory<T extends DeployableArtifact>
implements ArtifactFactory<T> {
    private LicenseValidator licenseValidator;

    public AbstractDeployableArtifactFactory(LicenseValidator licenseValidator) {
        this.licenseValidator = licenseValidator;
    }

    @Override
    public final T createArtifact(File artifactDir) throws IOException {
        T artifact = this.doCreateArtifact(artifactDir);
        ArtifactFactoryUtils.validateArtifactLicense(artifact.getArtifactClassLoader().getClassLoader(), artifact.getArtifactPlugins(), this.licenseValidator);
        return artifact;
    }

    protected abstract T doCreateArtifact(File var1) throws IOException;
}

