/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import org.mule.maven.client.api.LocalRepositorySupplierFactory;
import org.mule.maven.client.api.MavenClient;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptorCreateException;
import org.mule.runtime.module.artifact.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.descriptor.ClassLoaderModel;
import org.mule.runtime.module.deployment.impl.internal.maven.AbstractMavenClassLoaderModelLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginMavenClassLoaderModelLoader
extends AbstractMavenClassLoaderModelLoader {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public PluginMavenClassLoaderModelLoader(MavenClient mavenClient, LocalRepositorySupplierFactory localRepositorySupplierFactory) {
        super(mavenClient, localRepositorySupplierFactory);
    }

    @Override
    public String getId() {
        return "maven";
    }

    @Override
    protected void addArtifactSpecificClassloaderConfiguration(File artifactFile, ClassLoaderModel.ClassLoaderModelBuilder classLoaderModelBuilder, Set<BundleDependency> dependencies) {
        classLoaderModelBuilder.containing(this.getUrl(artifactFile, artifactFile));
    }

    private URL getUrl(File pluginFile, File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new ArtifactDescriptorCreateException(String.format("There was an exception obtaining the URL for the plugin [%s], file [%s]", pluginFile.getAbsolutePath(), file.getAbsolutePath()), (Throwable)e);
        }
    }

    public boolean supportsArtifactType(ArtifactType artifactType) {
        return artifactType.equals((Object)ArtifactType.PLUGIN);
    }
}

