/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.domain;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPlugin;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.DefaultRegionPluginClassLoadersFactory;
import org.mule.runtime.deployment.model.internal.domain.DomainClassLoaderBuilder;
import org.mule.runtime.deployment.model.internal.plugin.PluginDependenciesResolver;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ClassLoaderRepository;
import org.mule.runtime.module.artifact.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DefaultMuleDomain;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainClassLoaderBuilderFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainManager;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainWrapper;
import org.mule.runtime.module.deployment.impl.internal.domain.EmptyDomainDescriptor;
import org.mule.runtime.module.deployment.impl.internal.plugin.DefaultArtifactPlugin;
import org.mule.runtime.module.reboot.api.MuleContainerBootstrapUtils;
import org.mule.runtime.module.service.ServiceRepository;

public class DefaultDomainFactory
implements ArtifactFactory<Domain> {
    private final DomainManager domainManager;
    private final DomainDescriptorFactory domainDescriptorFactory;
    private final ClassLoaderRepository classLoaderRepository;
    private final ServiceRepository serviceRepository;
    private final PluginDependenciesResolver pluginDependenciesResolver;
    private final DomainClassLoaderBuilderFactory domainClassLoaderBuilderFactory;

    public DefaultDomainFactory(DomainDescriptorFactory domainDescriptorFactory, DomainManager domainManager, ClassLoaderRepository classLoaderRepository, ServiceRepository serviceRepository, PluginDependenciesResolver pluginDependenciesResolver, DomainClassLoaderBuilderFactory domainClassLoaderBuilderFactory) {
        Preconditions.checkArgument((domainDescriptorFactory != null ? 1 : 0) != 0, (String)"domainDescriptorFactory cannot be null");
        Preconditions.checkArgument((domainManager != null ? 1 : 0) != 0, (String)"Domain manager cannot be null");
        Preconditions.checkArgument((serviceRepository != null ? 1 : 0) != 0, (String)"Service repository cannot be null");
        Preconditions.checkArgument((pluginDependenciesResolver != null ? 1 : 0) != 0, (String)"pluginDependenciesResolver cannot be null");
        Preconditions.checkArgument((domainClassLoaderBuilderFactory != null ? 1 : 0) != 0, (String)"domainClassLoaderBuilderFactory cannot be null");
        this.classLoaderRepository = classLoaderRepository;
        this.domainDescriptorFactory = domainDescriptorFactory;
        this.domainManager = domainManager;
        this.serviceRepository = serviceRepository;
        this.pluginDependenciesResolver = pluginDependenciesResolver;
        this.domainClassLoaderBuilderFactory = domainClassLoaderBuilderFactory;
    }

    @Override
    public Domain createArtifact(File domainLocation) throws IOException {
        String domainName = domainLocation.getName();
        Domain domain = this.domainManager.getDomain(domainName);
        if (domain != null) {
            throw new IllegalArgumentException(String.format("Domain '%s'  already exists", domainName));
        }
        if (domainName.contains(" ")) {
            throw new IllegalArgumentException("Mule domain name may not contain spaces: " + domainName);
        }
        return this.createArtitact(this.findDomain(domainName));
    }

    public Domain createArtitact(DomainDescriptor descriptor) throws IOException {
        List artifactPluginDescriptors = descriptor.getPlugins().stream().collect(Collectors.toList());
        List resolvedArtifactPluginDescriptors = this.pluginDependenciesResolver.resolve(artifactPluginDescriptors);
        DomainClassLoaderBuilder artifactClassLoaderBuilder = this.domainClassLoaderBuilderFactory.createArtifactClassLoaderBuilder();
        MuleDeployableArtifactClassLoader domainClassLoader = ((DomainClassLoaderBuilder)((DomainClassLoaderBuilder)((DomainClassLoaderBuilder)artifactClassLoaderBuilder.addArtifactPluginDescriptors(resolvedArtifactPluginDescriptors.toArray(new ArtifactPluginDescriptor[0]))).setArtifactId(descriptor.getName())).setArtifactDescriptor((ArtifactDescriptor)descriptor)).build();
        List<ArtifactPlugin> artifactPlugins = this.createArtifactPluginList(domainClassLoader, resolvedArtifactPluginDescriptors);
        DefaultMuleDomain defaultMuleDomain = new DefaultMuleDomain(descriptor, (ArtifactClassLoader)domainClassLoader, this.classLoaderRepository, this.serviceRepository, artifactPlugins);
        DomainWrapper domainWrapper = new DomainWrapper(defaultMuleDomain, this);
        this.domainManager.addDomain(domainWrapper);
        return domainWrapper;
    }

    private DomainDescriptor findDomain(String domainName) throws IOException {
        if ("default".equals(domainName)) {
            return new EmptyDomainDescriptor(new File(MuleContainerBootstrapUtils.getMuleDomainsDir(), "default"));
        }
        File domainFolder = MuleFoldersUtil.getDomainFolder((String)domainName);
        DomainDescriptor descriptor = (DomainDescriptor)this.domainDescriptorFactory.create(domainFolder);
        return descriptor;
    }

    private List<ArtifactPlugin> createArtifactPluginList(MuleDeployableArtifactClassLoader domainClassLoader, List<ArtifactPluginDescriptor> plugins) {
        return plugins.stream().map(artifactPluginDescriptor -> new DefaultArtifactPlugin(DefaultRegionPluginClassLoadersFactory.getArtifactPluginId((String)domainClassLoader.getArtifactId(), (String)artifactPluginDescriptor.getName()), (ArtifactPluginDescriptor)artifactPluginDescriptor, domainClassLoader.getArtifactPluginClassLoaders().stream().filter(artifactClassLoader -> {
            String artifactPluginDescriptorName = "/plugin/" + artifactPluginDescriptor.getName();
            return artifactClassLoader.getArtifactId().endsWith(artifactPluginDescriptorName);
        }).findFirst().get())).collect(Collectors.toList());
    }

    @Override
    public File getArtifactDir() {
        return MuleContainerBootstrapUtils.getMuleDomainsDir();
    }

    public void dispose(DomainWrapper domain) {
        this.domainManager.removeDomain(domain.getArtifactName());
    }

    public void start(DomainWrapper domainWrapper) {
        this.domainManager.addDomain(domainWrapper);
    }
}

