/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.application;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.persistence.MuleApplicationModelJsonSerializer;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.util.PropertiesUtils;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.module.deployment.impl.internal.artifact.AbstractDeployableDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.artifact.DescriptorLoaderRepository;
import org.mule.runtime.module.deployment.impl.internal.plugin.ArtifactPluginDescriptorLoader;

public class ApplicationDescriptorFactory
extends AbstractDeployableDescriptorFactory<MuleApplicationModel, ApplicationDescriptor> {
    public static final String SYSTEM_PROPERTY_OVERRIDE = "-O";

    public ApplicationDescriptorFactory(ArtifactPluginDescriptorLoader artifactPluginDescriptorLoader, DescriptorLoaderRepository descriptorLoaderRepository) {
        super(artifactPluginDescriptorLoader, descriptorLoaderRepository);
    }

    @Override
    protected String getDescriptorFileName() {
        return "mule-artifact.json";
    }

    @Override
    protected void doDescriptorConfig(MuleApplicationModel artifactModel, ApplicationDescriptor descriptor) {
        artifactModel.getDomain().ifPresent(domain -> descriptor.setDomain(domain));
        File appClassesFolder = this.getAppClassesFolder(descriptor);
    }

    @Override
    protected ApplicationDescriptor createArtifactDescriptor(String name) {
        return new ApplicationDescriptor(name);
    }

    @Override
    protected String getDefaultConfigurationResourceLocation() {
        return ApplicationDescriptor.DEFAULT_CONFIGURATION_RESOURCE_LOCATION;
    }

    @Override
    protected String getDefaultConfigurationResource() {
        return "mule-config.xml";
    }

    @Override
    protected ArtifactType getArtifactType() {
        return ArtifactType.APP;
    }

    @Override
    protected MuleApplicationModel deserializeArtifactModel(InputStream stream) throws IOException {
        return (MuleApplicationModel)new MuleApplicationModelJsonSerializer().deserialize(IOUtils.toString((InputStream)stream));
    }

    protected File getAppLibFolder(ApplicationDescriptor descriptor) {
        return MuleFoldersUtil.getAppLibFolder((String)descriptor.getName());
    }

    protected File getAppSharedLibsFolder(ApplicationDescriptor descriptor) {
        return MuleFoldersUtil.getAppSharedLibsFolder((String)descriptor.getName());
    }

    protected File getAppClassesFolder(ApplicationDescriptor descriptor) {
        return MuleFoldersUtil.getAppClassesFolder((String)descriptor.getName());
    }

    public void setApplicationProperties(ApplicationDescriptor desc, File appPropsFile) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (appPropsFile.exists() && appPropsFile.canRead()) {
            Properties props;
            try {
                props = PropertiesUtils.loadProperties((URL)appPropsFile.toURI().toURL());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to obtain application properties file URL", e);
            }
            for (Object key : props.keySet()) {
                m.put(key.toString(), props.getProperty(key.toString()));
            }
        }
        Properties sysProps = System.getProperties();
        for (Map.Entry<Object, Object> entry : sysProps.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(SYSTEM_PROPERTY_OVERRIDE)) continue;
            m.put(key.substring(SYSTEM_PROPERTY_OVERRIDE.length()), entry.getValue().toString());
        }
        desc.setAppProperties(m);
    }
}

