/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.maven;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.core.internal.util.JarUtils;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorCreateException;

public class MavenUtils {
    private static final String SHARED_LIBRARIES_ELEMENT = "sharedLibraries";

    public static Model getPomModelFromJar(File artifactFile) {
        String pomFilePath = "META-INF/mule-artifact/pom.xml";
        try {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            return reader.read((InputStream)new ByteArrayInputStream((byte[])JarUtils.loadFileContentFrom((URL)MavenUtils.getPomUrlFromJar(artifactFile)).get()));
        }
        catch (IOException | XmlPullParserException e) {
            throw new ArtifactDescriptorCreateException(String.format("There was an issue reading '%s' for the plugin '%s'", pomFilePath, artifactFile.getAbsolutePath()), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static URL getPomUrlFromJar(File artifactFile) {
        String pomFilePath = "META-INF/mule-artifact/pom.xml";
        try {
            URL possibleUrl = JarUtils.getUrlWithinJar((File)artifactFile, (String)pomFilePath);
            try (InputStream ignored = possibleUrl.openStream();){
                URL throwable3 = possibleUrl;
                return throwable3;
            }
            catch (Exception e) {
                List jarMavenUrls = JarUtils.getUrlsWithinJar((File)artifactFile, (String)"META-INF/maven");
                Optional<URL> pomUrl = jarMavenUrls.stream().filter(url -> url.toString().endsWith("pom.xml")).findAny();
                if (pomUrl.isPresent()) return pomUrl.get();
                throw new ArtifactDescriptorCreateException(String.format("The identifier '%s' requires the file '%s' within the artifact(error found while reading plugin '%s')", artifactFile.getName(), "pom.xml", artifactFile.getAbsolutePath()));
            }
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public static Model getPomModelFolder(File artifactFolder) {
        Model model;
        File mulePluginPom = MavenUtils.lookupPomFromMavenLocation(artifactFolder);
        MavenXpp3Reader reader = new MavenXpp3Reader();
        try (FileReader mulePluginPomFileReader = new FileReader(mulePluginPom);){
            model = reader.read((Reader)mulePluginPomFileReader);
        }
        catch (IOException | XmlPullParserException e) {
            throw new ArtifactDescriptorCreateException(String.format("There was an issue reading '%s' for the plugin '%s'", mulePluginPom.getName(), artifactFolder.getAbsolutePath()), e);
        }
        return model;
    }

    public static void updateArtifactPom(File artifactFolder, Model model) {
        File mulePluginPom = MavenUtils.lookupPomFromMavenLocation(artifactFolder);
        MavenXpp3Writer writer = new MavenXpp3Writer();
        try (FileOutputStream outputStream = new FileOutputStream(mulePluginPom);){
            writer.write((OutputStream)outputStream, model);
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public static void createDeployablePomFile(File artifactFolder, Model model) {
        File pomFileLocation = new File(artifactFolder, Paths.get("META-INF", "maven", model.getGroupId(), model.getArtifactId(), "pom.xml").toString());
        try {
            FileUtils.createFile((String)pomFileLocation.getAbsolutePath());
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        try (FileWriter fileWriter = new FileWriter(pomFileLocation);){
            new MavenXpp3Writer().write((Writer)fileWriter, model);
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private static File lookupPomFromMavenLocation(File artifactFolder) {
        File mulePluginPom = null;
        File lookupFolder = new File(artifactFolder, "META-INF" + File.separator + "maven");
        while (lookupFolder != null && lookupFolder.exists()) {
            File possiblePomLocation = new File(lookupFolder, "pom.xml");
            if (possiblePomLocation.exists()) {
                mulePluginPom = possiblePomLocation;
                break;
            }
            File[] directories = lookupFolder.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY);
            Preconditions.checkState((directories != null || directories.length == 0 ? 1 : 0) != 0, (String)String.format("No directories under %s so pom.xml file for artifact in folder %s could not be found", lookupFolder.getAbsolutePath(), artifactFolder.getAbsolutePath()));
            Preconditions.checkState((directories.length == 1 ? 1 : 0) != 0, (String)String.format("More than one directory under %s so pom.xml file for artifact in folder %s could not be found", lookupFolder.getAbsolutePath(), artifactFolder.getAbsolutePath()));
            lookupFolder = directories[0];
        }
        if (mulePluginPom == null || !mulePluginPom.exists()) {
            throw new ArtifactDescriptorCreateException(String.format("The maven bundle loader requires the file pom.xml (error found while reading plugin '%s')", artifactFolder.getName()));
        }
        return mulePluginPom;
    }

    public static void addSharedLibraryDependency(Model model, Dependency dependency) {
        Xpp3Dom sharedLibrariesDom;
        ArrayList finalPlugins;
        Optional<Plugin> pluginOptional;
        Plugin plugin2;
        Xpp3Dom configuration;
        ArrayList plugins;
        Build build = model.getBuild();
        if (build == null) {
            build = new Build();
            model.setBuild(build);
        }
        if ((plugins = build.getPlugins()) == null) {
            plugins = new ArrayList();
            build.setPlugins(plugins);
        }
        if ((configuration = (Xpp3Dom)(plugin2 = (pluginOptional = plugins.stream().filter(plugin -> plugin.getGroupId().equals("org.mule.tools.maven") && plugin.getArtifactId().equals("mule-maven-plugin")).findFirst()).orElseGet(() -> MavenUtils.lambda$addSharedLibraryDependency$2(finalPlugins = plugins))).getConfiguration()) == null) {
            configuration = new Xpp3Dom("configuration");
            plugin2.setConfiguration((Object)configuration);
        }
        if ((sharedLibrariesDom = configuration.getChild(SHARED_LIBRARIES_ELEMENT)) == null) {
            sharedLibrariesDom = new Xpp3Dom(SHARED_LIBRARIES_ELEMENT);
            configuration.addChild(sharedLibrariesDom);
        }
        Xpp3Dom sharedLibraryDom = new Xpp3Dom("sharedLibrary");
        sharedLibrariesDom.addChild(sharedLibraryDom);
        Xpp3Dom groupIdDom = new Xpp3Dom("groupId");
        groupIdDom.setValue(dependency.getGroupId());
        sharedLibraryDom.addChild(groupIdDom);
        Xpp3Dom artifactIdDom = new Xpp3Dom("artifactId");
        artifactIdDom.setValue(dependency.getArtifactId());
        sharedLibraryDom.addChild(artifactIdDom);
    }

    private static /* synthetic */ Plugin lambda$addSharedLibraryDependency$2(List finalPlugins) {
        Plugin muleMavenPlugin = new Plugin();
        muleMavenPlugin.setGroupId("org.mule.tools.maven");
        muleMavenPlugin.setArtifactId("mule-maven-plugin");
        finalPlugins.add(muleMavenPlugin);
        return muleMavenPlugin;
    }
}

