/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.policy;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.deployment.meta.MulePolicyModel;
import org.mule.runtime.api.deployment.persistence.AbstractMuleArtifactModelJsonSerializer;
import org.mule.runtime.api.deployment.persistence.MulePolicyModelJsonSerializer;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplateDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.AbstractArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.api.descriptor.DescriptorLoaderRepository;
import org.mule.runtime.module.deployment.impl.internal.artifact.ServiceRegistryDescriptorLoaderRepository;
import org.mule.runtime.module.deployment.impl.internal.plugin.ArtifactPluginDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.plugin.ArtifactPluginDescriptorLoader;

public class PolicyTemplateDescriptorFactory
extends AbstractArtifactDescriptorFactory<MulePolicyModel, PolicyTemplateDescriptor> {
    protected static final String MISSING_POLICY_DESCRIPTOR_ERROR = "Policy must contain a mule-artifact.json file";
    private final ArtifactPluginDescriptorLoader artifactPluginDescriptorLoader;

    public PolicyTemplateDescriptorFactory() {
        this(new ArtifactPluginDescriptorLoader(new ArtifactPluginDescriptorFactory()), new ServiceRegistryDescriptorLoaderRepository((ServiceRegistry)new SpiServiceRegistry()));
    }

    public PolicyTemplateDescriptorFactory(ArtifactPluginDescriptorLoader artifactPluginDescriptorLoader, DescriptorLoaderRepository descriptorLoaderRepository) {
        super(descriptorLoaderRepository);
        Preconditions.checkArgument((artifactPluginDescriptorLoader != null ? 1 : 0) != 0, (String)"artifactPluginDescriptorLoader cannot be null");
        this.artifactPluginDescriptorLoader = artifactPluginDescriptorLoader;
    }

    protected void doDescriptorConfig(MulePolicyModel artifactModel, PolicyTemplateDescriptor descriptor, File artifactLocation) {
        descriptor.setRootFolder(artifactLocation);
        descriptor.setPlugins(this.parseArtifactPluginDescriptors(descriptor));
    }

    private Set<ArtifactPluginDescriptor> parseArtifactPluginDescriptors(PolicyTemplateDescriptor descriptor) {
        Set pluginDependencies = descriptor.getClassLoaderModel().getDependencies().stream().filter(dependency -> dependency.getDescriptor().isPlugin()).collect(Collectors.toSet());
        return pluginDependencies.stream().map(dependency -> {
            try {
                return this.artifactPluginDescriptorLoader.load(new File(dependency.getBundleUri()));
            }
            catch (IOException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }).collect(Collectors.toSet());
    }

    protected AbstractMuleArtifactModelJsonSerializer<MulePolicyModel> getMuleArtifactModelJsonSerializer() {
        return new MulePolicyModelJsonSerializer();
    }

    protected ArtifactType getArtifactType() {
        return ArtifactType.POLICY;
    }

    protected PolicyTemplateDescriptor createArtifactDescriptor(File artifactLocation, String name, Optional<Properties> deploymentProperties) {
        return new PolicyTemplateDescriptor(name, deploymentProperties);
    }
}

