/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.artifact;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.deployment.meta.MuleDeployableModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.deployment.model.api.DeployableArtifactDescriptor;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.AbstractArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidatorBuilder;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel;
import org.mule.runtime.module.artifact.api.descriptor.DescriptorLoaderRepository;
import org.mule.runtime.module.deployment.impl.internal.plugin.ArtifactPluginDescriptorLoader;

public abstract class AbstractDeployableDescriptorFactory<M extends MuleDeployableModel, T extends DeployableArtifactDescriptor>
extends AbstractArtifactDescriptorFactory<M, T> {
    protected final ArtifactPluginDescriptorLoader artifactPluginDescriptorLoader;

    public AbstractDeployableDescriptorFactory(ArtifactPluginDescriptorLoader artifactPluginDescriptorLoader, DescriptorLoaderRepository descriptorLoaderRepository, ArtifactDescriptorValidatorBuilder artifactDescriptorValidatorBuilder) {
        super(descriptorLoaderRepository, artifactDescriptorValidatorBuilder);
        Preconditions.checkArgument((artifactPluginDescriptorLoader != null ? 1 : 0) != 0, (String)"ApplicationPluginDescriptorFactory cannot be null");
        this.artifactPluginDescriptorLoader = artifactPluginDescriptorLoader;
    }

    protected void doDescriptorConfig(M artifactModel, T descriptor, File artifactLocation) {
        descriptor.setArtifactLocation(artifactLocation);
        descriptor.setRedeploymentEnabled(artifactModel.isRedeploymentEnabled());
        Set configs = artifactModel.getConfigs();
        if (configs != null && !configs.isEmpty()) {
            descriptor.setConfigResources(configs.stream().collect(Collectors.toSet()));
        } else {
            descriptor.setConfigResources((Set)ImmutableSet.builder().add((Object)this.getDefaultConfigurationResource()).build());
        }
        try {
            descriptor.setPlugins(this.createArtifactPluginDescriptors(descriptor.getClassLoaderModel()));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected abstract String getDefaultConfigurationResource();

    private Set<ArtifactPluginDescriptor> createArtifactPluginDescriptors(ClassLoaderModel classLoaderModel) throws IOException {
        HashSet<ArtifactPluginDescriptor> pluginDescriptors = new HashSet<ArtifactPluginDescriptor>();
        for (BundleDependency bundleDependency : classLoaderModel.getDependencies()) {
            if (!bundleDependency.getDescriptor().isPlugin()) continue;
            File pluginFile = new File(bundleDependency.getBundleUri());
            pluginDescriptors.add(this.artifactPluginDescriptorLoader.load(pluginFile));
        }
        return pluginDescriptors;
    }
}

