/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.policy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPlugin;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplate;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplateDescriptor;
import org.mule.runtime.deployment.model.internal.DefaultRegionPluginClassLoadersFactory;
import org.mule.runtime.deployment.model.internal.plugin.PluginDependenciesResolver;
import org.mule.runtime.deployment.model.internal.policy.PolicyTemplateClassLoaderBuilder;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.DefaultArtifactClassLoaderFilter;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptorUtils;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactFactoryUtils;
import org.mule.runtime.module.deployment.impl.internal.plugin.DefaultArtifactPlugin;
import org.mule.runtime.module.deployment.impl.internal.policy.DefaultPolicyTemplate;
import org.mule.runtime.module.deployment.impl.internal.policy.PolicyTemplateClassLoaderBuilderFactory;
import org.mule.runtime.module.deployment.impl.internal.policy.PolicyTemplateCreationException;
import org.mule.runtime.module.deployment.impl.internal.policy.PolicyTemplateFactory;
import org.mule.runtime.module.license.api.LicenseValidator;

public class DefaultPolicyTemplateFactory
implements PolicyTemplateFactory {
    private final PolicyTemplateClassLoaderBuilderFactory policyTemplateClassLoaderBuilderFactory;
    private final PluginDependenciesResolver pluginDependenciesResolver;
    private final LicenseValidator licenseValidator;

    public DefaultPolicyTemplateFactory(PolicyTemplateClassLoaderBuilderFactory policyTemplateClassLoaderBuilderFactory, PluginDependenciesResolver pluginDependenciesResolver, LicenseValidator licenseValidator) {
        Preconditions.checkArgument((policyTemplateClassLoaderBuilderFactory != null ? 1 : 0) != 0, (String)"policyTemplateClassLoaderBuilderFactory cannot be null");
        this.policyTemplateClassLoaderBuilderFactory = policyTemplateClassLoaderBuilderFactory;
        this.pluginDependenciesResolver = pluginDependenciesResolver;
        this.licenseValidator = licenseValidator;
    }

    @Override
    public PolicyTemplate createArtifact(Application application, PolicyTemplateDescriptor descriptor) {
        MuleDeployableArtifactClassLoader policyClassLoader;
        HashSet<ArtifactPlugin> plugins = new HashSet<ArtifactPlugin>(application.getArtifactPlugins());
        plugins.addAll(application.getDomain().getArtifactPlugins());
        List resolvedPolicyPluginsDescriptors = this.pluginDependenciesResolver.resolve(new ArrayList(descriptor.getPlugins()));
        List<ArtifactPluginDescriptor> policyClassLoaderPluginDescriptors = this.filterPolicyPluginsBasedOnApplicationPlugins(plugins, resolvedPolicyPluginsDescriptors);
        try {
            policyClassLoader = ((PolicyTemplateClassLoaderBuilder)((PolicyTemplateClassLoaderBuilder)this.policyTemplateClassLoaderBuilderFactory.createArtifactClassLoaderBuilder().addArtifactPluginDescriptors(policyClassLoaderPluginDescriptors.toArray(new ArtifactPluginDescriptor[policyClassLoaderPluginDescriptors.size()]))).setParentClassLoader((ArtifactClassLoader)application.getRegionClassLoader()).setArtifactDescriptor((ArtifactDescriptor)descriptor)).build();
        }
        catch (IOException e) {
            throw new PolicyTemplateCreationException(DefaultPolicyTemplateFactory.createPolicyTemplateCreationErrorMessage(descriptor.getName()), e);
        }
        application.getRegionClassLoader().addClassLoader((ArtifactClassLoader)policyClassLoader, DefaultArtifactClassLoaderFilter.NULL_CLASSLOADER_FILTER);
        List<ArtifactPlugin> artifactPlugins = this.createArtifactPluginList(policyClassLoader, policyClassLoaderPluginDescriptors);
        ArtifactFactoryUtils.validateArtifactLicense(policyClassLoader.getClassLoader(), artifactPlugins, this.licenseValidator);
        DefaultPolicyTemplate policy = new DefaultPolicyTemplate(policyClassLoader.getArtifactId(), descriptor, (ArtifactClassLoader)policyClassLoader, artifactPlugins);
        return policy;
    }

    private List<ArtifactPluginDescriptor> filterPolicyPluginsBasedOnApplicationPlugins(Set<ArtifactPlugin> appPlugins, List<ArtifactPluginDescriptor> policyPlugins) {
        ArrayList<ArtifactPluginDescriptor> artifactPluginDescriptors = new ArrayList<ArtifactPluginDescriptor>();
        for (ArtifactPluginDescriptor policyPluginDescriptor : policyPlugins) {
            Optional<ArtifactPlugin> appPluginDescriptor = this.findPlugin(appPlugins, policyPluginDescriptor.getBundleDescriptor());
            if (!appPluginDescriptor.isPresent()) {
                artifactPluginDescriptors.add(policyPluginDescriptor);
                continue;
            }
            if (BundleDescriptorUtils.isCompatibleVersion((String)((ArtifactPluginDescriptor)appPluginDescriptor.get().getDescriptor()).getBundleDescriptor().getVersion(), (String)policyPluginDescriptor.getBundleDescriptor().getVersion())) continue;
            throw new IllegalStateException(String.format("Incompatible version of plugin '%s' found. Policy requires version'%s' but application provides version'%s'", policyPluginDescriptor.getName(), policyPluginDescriptor.getBundleDescriptor().getVersion(), ((ArtifactPluginDescriptor)appPluginDescriptor.get().getDescriptor()).getBundleDescriptor().getVersion()));
        }
        return artifactPluginDescriptors;
    }

    private Optional<ArtifactPlugin> findPlugin(Set<ArtifactPlugin> appPlugins, BundleDescriptor bundleDescriptor) {
        for (ArtifactPlugin appPlugin : appPlugins) {
            if (!((ArtifactPluginDescriptor)appPlugin.getDescriptor()).getBundleDescriptor().getArtifactId().equals(bundleDescriptor.getArtifactId()) || !((ArtifactPluginDescriptor)appPlugin.getDescriptor()).getBundleDescriptor().getGroupId().equals(bundleDescriptor.getGroupId())) continue;
            return Optional.of(appPlugin);
        }
        return Optional.empty();
    }

    private List<ArtifactPlugin> createArtifactPluginList(MuleDeployableArtifactClassLoader policyClassLoader, List<ArtifactPluginDescriptor> plugins) {
        return plugins.stream().map(artifactPluginDescriptor -> new DefaultArtifactPlugin(DefaultRegionPluginClassLoadersFactory.getArtifactPluginId((String)policyClassLoader.getArtifactId(), (String)artifactPluginDescriptor.getName()), (ArtifactPluginDescriptor)artifactPluginDescriptor, policyClassLoader.getArtifactPluginClassLoaders().stream().filter(artifactClassLoader -> artifactClassLoader.getArtifactId().endsWith(artifactPluginDescriptor.getName())).findFirst().get())).collect(Collectors.toList());
    }

    static String createPolicyTemplateCreationErrorMessage(String policyName) {
        return String.format("Cannot create policy template '%s'", policyName);
    }
}

