/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.application;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.service.ServiceRepository;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.deployment.model.api.DeployableArtifactDescriptor;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPlugin;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.DefaultRegionPluginClassLoadersFactory;
import org.mule.runtime.deployment.model.internal.application.ApplicationClassLoaderBuilder;
import org.mule.runtime.deployment.model.internal.plugin.PluginDependenciesResolver;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinitionProvider;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.deployment.impl.internal.application.ApplicationClassLoaderBuilderFactory;
import org.mule.runtime.module.deployment.impl.internal.application.ApplicationDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.application.ApplicationWrapper;
import org.mule.runtime.module.deployment.impl.internal.application.DefaultMuleApplication;
import org.mule.runtime.module.deployment.impl.internal.application.MuleApplicationPolicyProvider;
import org.mule.runtime.module.deployment.impl.internal.artifact.AbstractDeployableArtifactFactory;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainRepository;
import org.mule.runtime.module.deployment.impl.internal.plugin.ArtifactPluginDescriptorLoader;
import org.mule.runtime.module.deployment.impl.internal.plugin.DefaultArtifactPlugin;
import org.mule.runtime.module.deployment.impl.internal.policy.DefaultPolicyInstanceProviderFactory;
import org.mule.runtime.module.deployment.impl.internal.policy.DefaultPolicyTemplateFactory;
import org.mule.runtime.module.deployment.impl.internal.policy.PolicyTemplateClassLoaderBuilderFactory;
import org.mule.runtime.module.extension.internal.loader.ExtensionModelLoaderRepository;
import org.mule.runtime.module.license.api.LicenseValidator;
import org.mule.runtime.module.reboot.api.MuleContainerBootstrapUtils;

public class DefaultApplicationFactory
extends AbstractDeployableArtifactFactory<Application>
implements ArtifactFactory<Application> {
    private final ApplicationDescriptorFactory applicationDescriptorFactory;
    private final DomainRepository domainRepository;
    private final ApplicationClassLoaderBuilderFactory applicationClassLoaderBuilderFactory;
    private final ServiceRepository serviceRepository;
    private final ExtensionModelLoaderRepository extensionModelLoaderRepository;
    private final ClassLoaderRepository classLoaderRepository;
    private final PolicyTemplateClassLoaderBuilderFactory policyTemplateClassLoaderBuilderFactory;
    private final PluginDependenciesResolver pluginDependenciesResolver;
    private final ArtifactPluginDescriptorLoader artifactPluginDescriptorLoader;
    private final LicenseValidator licenseValidator;

    public DefaultApplicationFactory(ApplicationClassLoaderBuilderFactory applicationClassLoaderBuilderFactory, ApplicationDescriptorFactory applicationDescriptorFactory, DomainRepository domainRepository, ServiceRepository serviceRepository, ExtensionModelLoaderRepository extensionModelLoaderRepository, ClassLoaderRepository classLoaderRepository, PolicyTemplateClassLoaderBuilderFactory policyTemplateClassLoaderBuilderFactory, PluginDependenciesResolver pluginDependenciesResolver, ArtifactPluginDescriptorLoader artifactPluginDescriptorLoader, LicenseValidator licenseValidator, ComponentBuildingDefinitionProvider runtimeComponentBuildingDefinitionProvider) {
        super(licenseValidator, runtimeComponentBuildingDefinitionProvider);
        Preconditions.checkArgument((applicationClassLoaderBuilderFactory != null ? 1 : 0) != 0, (String)"Application classloader builder factory cannot be null");
        Preconditions.checkArgument((applicationDescriptorFactory != null ? 1 : 0) != 0, (String)"Application descriptor factory cannot be null");
        Preconditions.checkArgument((domainRepository != null ? 1 : 0) != 0, (String)"Domain repository cannot be null");
        Preconditions.checkArgument((serviceRepository != null ? 1 : 0) != 0, (String)"Service repository cannot be null");
        Preconditions.checkArgument((extensionModelLoaderRepository != null ? 1 : 0) != 0, (String)"extensionModelLoaderRepository cannot be null");
        Preconditions.checkArgument((classLoaderRepository != null ? 1 : 0) != 0, (String)"classLoaderRepository cannot be null");
        Preconditions.checkArgument((policyTemplateClassLoaderBuilderFactory != null ? 1 : 0) != 0, (String)"policyClassLoaderBuilderFactory cannot be null");
        Preconditions.checkArgument((pluginDependenciesResolver != null ? 1 : 0) != 0, (String)"pluginDependenciesResolver cannot be null");
        Preconditions.checkArgument((artifactPluginDescriptorLoader != null ? 1 : 0) != 0, (String)"artifactPluginDescriptorLoader cannot be null");
        this.classLoaderRepository = classLoaderRepository;
        this.applicationClassLoaderBuilderFactory = applicationClassLoaderBuilderFactory;
        this.applicationDescriptorFactory = applicationDescriptorFactory;
        this.domainRepository = domainRepository;
        this.serviceRepository = serviceRepository;
        this.extensionModelLoaderRepository = extensionModelLoaderRepository;
        this.policyTemplateClassLoaderBuilderFactory = policyTemplateClassLoaderBuilderFactory;
        this.pluginDependenciesResolver = pluginDependenciesResolver;
        this.artifactPluginDescriptorLoader = artifactPluginDescriptorLoader;
        this.licenseValidator = licenseValidator;
    }

    @Override
    protected Application doCreateArtifact(File artifactDir, Optional<Properties> properties) throws IOException {
        String appName = artifactDir.getName();
        if (appName.contains(" ")) {
            throw new IllegalArgumentException("Mule application name may not contain spaces: " + appName);
        }
        ApplicationDescriptor descriptor = (ApplicationDescriptor)this.applicationDescriptorFactory.create(artifactDir, properties);
        return this.createArtifact(descriptor);
    }

    @Override
    public File getArtifactDir() {
        return MuleContainerBootstrapUtils.getMuleAppsDir();
    }

    @Override
    public DeployableArtifactDescriptor createArtifactDescriptor(File artifactLocation, Optional<Properties> deploymentProperties) {
        return (DeployableArtifactDescriptor)this.applicationDescriptorFactory.create(artifactLocation, deploymentProperties);
    }

    public Application createArtifact(ApplicationDescriptor descriptor) throws IOException {
        Domain domain = this.getApplicationDomain(descriptor);
        List resolvedArtifactPluginDescriptors = this.pluginDependenciesResolver.resolve(((DomainDescriptor)domain.getDescriptor()).getPlugins(), new ArrayList<ArtifactPluginDescriptor>(this.getArtifactPluginDescriptors(descriptor)));
        LinkedHashSet resolvedArtifactPlugins = new LinkedHashSet();
        resolvedArtifactPlugins.addAll(resolvedArtifactPluginDescriptors);
        descriptor.setPlugins(resolvedArtifactPlugins);
        ApplicationClassLoaderBuilder artifactClassLoaderBuilder = this.applicationClassLoaderBuilderFactory.createArtifactClassLoaderBuilder();
        MuleDeployableArtifactClassLoader applicationClassLoader = ((ApplicationClassLoaderBuilder)((ApplicationClassLoaderBuilder)((ApplicationClassLoaderBuilder)artifactClassLoaderBuilder.setDomain(domain).addArtifactPluginDescriptors(resolvedArtifactPluginDescriptors.toArray(new ArtifactPluginDescriptor[0]))).setArtifactId(descriptor.getName())).setArtifactDescriptor((ArtifactDescriptor)descriptor)).build();
        List<ArtifactPlugin> artifactPlugins = this.createArtifactPluginList(applicationClassLoader, resolvedArtifactPluginDescriptors);
        MuleApplicationPolicyProvider applicationPolicyProvider = new MuleApplicationPolicyProvider(new DefaultPolicyTemplateFactory(this.policyTemplateClassLoaderBuilderFactory, this.pluginDependenciesResolver, this.licenseValidator), new DefaultPolicyInstanceProviderFactory(this.serviceRepository, this.classLoaderRepository, this.extensionModelLoaderRepository, this.getRuntimeComponentBuildingDefinitionProvider()));
        DefaultMuleApplication delegate = new DefaultMuleApplication(descriptor, applicationClassLoader, artifactPlugins, this.domainRepository, this.serviceRepository, this.extensionModelLoaderRepository, descriptor.getArtifactLocation(), this.classLoaderRepository, applicationPolicyProvider, this.getRuntimeComponentBuildingDefinitionProvider());
        applicationPolicyProvider.setApplication(delegate);
        return new ApplicationWrapper(delegate);
    }

    private Domain getApplicationDomain(ApplicationDescriptor descriptor) {
        Domain domain = this.domainRepository.getDomain(descriptor.getDomainName());
        if (domain == null) {
            throw new DeploymentException(I18nMessageFactory.createStaticMessage((String)String.format("Domain '%s' has to be deployed in order to deploy Application '%s'", descriptor.getDomainName(), descriptor.getName())));
        }
        return domain;
    }

    private Set<ArtifactPluginDescriptor> getArtifactPluginDescriptors(ApplicationDescriptor descriptor) {
        if (descriptor.getPlugins().isEmpty()) {
            HashSet<ArtifactPluginDescriptor> pluginDescriptors = new HashSet<ArtifactPluginDescriptor>();
            for (BundleDependency bundleDependency : descriptor.getClassLoaderModel().getDependencies()) {
                if (!bundleDependency.getDescriptor().isPlugin()) continue;
                File pluginZip = new File(bundleDependency.getBundleUri());
                try {
                    pluginDescriptors.add(this.artifactPluginDescriptorLoader.load(pluginZip));
                }
                catch (IOException e) {
                    throw new IllegalStateException("Cannot create plugin descriptor: " + pluginZip.getAbsolutePath(), e);
                }
            }
            return pluginDescriptors;
        }
        return descriptor.getPlugins();
    }

    private List<ArtifactPlugin> createArtifactPluginList(MuleDeployableArtifactClassLoader applicationClassLoader, List<ArtifactPluginDescriptor> plugins) {
        return plugins.stream().map(artifactPluginDescriptor -> new DefaultArtifactPlugin(DefaultRegionPluginClassLoadersFactory.getArtifactPluginId((String)applicationClassLoader.getArtifactId(), (String)artifactPluginDescriptor.getName()), (ArtifactPluginDescriptor)artifactPluginDescriptor, applicationClassLoader.getArtifactPluginClassLoaders().stream().filter(artifactClassLoader -> {
            String artifactPluginDescriptorName = "/plugin/" + artifactPluginDescriptor.getName();
            return artifactClassLoader.getArtifactId().endsWith(artifactPluginDescriptorName);
        }).findFirst().get())).collect(Collectors.toList());
    }
}

