/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.domain;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.mule.runtime.api.service.ServiceRepository;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.deployment.model.api.DeployableArtifactDescriptor;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPlugin;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.DefaultRegionPluginClassLoadersFactory;
import org.mule.runtime.deployment.model.internal.domain.DomainClassLoaderBuilder;
import org.mule.runtime.deployment.model.internal.plugin.PluginDependenciesResolver;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinitionProvider;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.deployment.impl.internal.artifact.AbstractDeployableArtifactFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DefaultMuleDomain;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainClassLoaderBuilderFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainManager;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainWrapper;
import org.mule.runtime.module.deployment.impl.internal.domain.EmptyDomainDescriptor;
import org.mule.runtime.module.deployment.impl.internal.plugin.DefaultArtifactPlugin;
import org.mule.runtime.module.extension.internal.loader.ExtensionModelLoaderManager;
import org.mule.runtime.module.license.api.LicenseValidator;
import org.mule.runtime.module.reboot.api.MuleContainerBootstrapUtils;

public class DefaultDomainFactory
extends AbstractDeployableArtifactFactory<Domain> {
    private final DomainManager domainManager;
    private final DomainDescriptorFactory domainDescriptorFactory;
    private final ClassLoaderRepository classLoaderRepository;
    private final ServiceRepository serviceRepository;
    private final PluginDependenciesResolver pluginDependenciesResolver;
    private final DomainClassLoaderBuilderFactory domainClassLoaderBuilderFactory;
    private ExtensionModelLoaderManager extensionModelLoaderManager;

    public DefaultDomainFactory(DomainDescriptorFactory domainDescriptorFactory, DomainManager domainManager, ClassLoaderRepository classLoaderRepository, ServiceRepository serviceRepository, PluginDependenciesResolver pluginDependenciesResolver, DomainClassLoaderBuilderFactory domainClassLoaderBuilderFactory, ExtensionModelLoaderManager extensionModelLoaderManager, LicenseValidator licenseValidator, ComponentBuildingDefinitionProvider runtimeComponentBuildingDefinitionProvider) {
        super(licenseValidator, runtimeComponentBuildingDefinitionProvider);
        Preconditions.checkArgument((domainDescriptorFactory != null ? 1 : 0) != 0, (String)"domainDescriptorFactory cannot be null");
        Preconditions.checkArgument((domainManager != null ? 1 : 0) != 0, (String)"Domain manager cannot be null");
        Preconditions.checkArgument((serviceRepository != null ? 1 : 0) != 0, (String)"Service repository cannot be null");
        Preconditions.checkArgument((pluginDependenciesResolver != null ? 1 : 0) != 0, (String)"pluginDependenciesResolver cannot be null");
        Preconditions.checkArgument((domainClassLoaderBuilderFactory != null ? 1 : 0) != 0, (String)"domainClassLoaderBuilderFactory cannot be null");
        Preconditions.checkArgument((extensionModelLoaderManager != null ? 1 : 0) != 0, (String)"extensionModelLoaderManager cannot be null");
        this.classLoaderRepository = classLoaderRepository;
        this.domainDescriptorFactory = domainDescriptorFactory;
        this.domainManager = domainManager;
        this.serviceRepository = serviceRepository;
        this.pluginDependenciesResolver = pluginDependenciesResolver;
        this.domainClassLoaderBuilderFactory = domainClassLoaderBuilderFactory;
        this.extensionModelLoaderManager = extensionModelLoaderManager;
    }

    private DomainDescriptor findDomain(String domainName, File domainLocation, Optional<Properties> deploymentProperties) throws IOException {
        if ("default".equals(domainName)) {
            return new EmptyDomainDescriptor(new File(MuleContainerBootstrapUtils.getMuleDomainsDir(), "default"));
        }
        DomainDescriptor descriptor = (DomainDescriptor)this.domainDescriptorFactory.create(domainLocation, deploymentProperties);
        return descriptor;
    }

    private List<ArtifactPlugin> createArtifactPluginList(MuleDeployableArtifactClassLoader domainClassLoader, List<ArtifactPluginDescriptor> plugins) {
        return plugins.stream().map(artifactPluginDescriptor -> new DefaultArtifactPlugin(DefaultRegionPluginClassLoadersFactory.getArtifactPluginId((String)domainClassLoader.getArtifactId(), (String)artifactPluginDescriptor.getName()), (ArtifactPluginDescriptor)artifactPluginDescriptor, domainClassLoader.getArtifactPluginClassLoaders().stream().filter(artifactClassLoader -> {
            String artifactPluginDescriptorName = "/plugin/" + artifactPluginDescriptor.getName();
            return artifactClassLoader.getArtifactId().endsWith(artifactPluginDescriptorName);
        }).findFirst().get())).collect(Collectors.toList());
    }

    @Override
    public File getArtifactDir() {
        return MuleContainerBootstrapUtils.getMuleDomainsDir();
    }

    public void dispose(DomainWrapper domain) {
        this.domainManager.removeDomain(domain.getArtifactName());
    }

    public void start(DomainWrapper domainWrapper) {
        this.domainManager.addDomain(domainWrapper);
    }

    @Override
    protected Domain doCreateArtifact(File domainLocation, Optional<Properties> deploymentProperties) throws IOException {
        String domainName = domainLocation.getName();
        Domain domain = this.domainManager.getDomain(domainName);
        if (domain != null) {
            throw new IllegalArgumentException(String.format("Domain '%s'  already exists", domainName));
        }
        if (domainName.contains(" ")) {
            throw new IllegalArgumentException("Mule domain name may not contain spaces: " + domainName);
        }
        DomainDescriptor domainDescriptor = this.findDomain(domainName, domainLocation, deploymentProperties);
        List resolvedArtifactPluginDescriptors = this.pluginDependenciesResolver.resolve(Collections.emptySet(), domainDescriptor.getPlugins().stream().collect(Collectors.toList()));
        DomainClassLoaderBuilder artifactClassLoaderBuilder = this.domainClassLoaderBuilderFactory.createArtifactClassLoaderBuilder();
        MuleDeployableArtifactClassLoader domainClassLoader = ((DomainClassLoaderBuilder)((DomainClassLoaderBuilder)((DomainClassLoaderBuilder)artifactClassLoaderBuilder.addArtifactPluginDescriptors(resolvedArtifactPluginDescriptors.toArray(new ArtifactPluginDescriptor[resolvedArtifactPluginDescriptors.size()]))).setArtifactId(domainDescriptor.getName())).setArtifactDescriptor((ArtifactDescriptor)domainDescriptor)).build();
        List<ArtifactPlugin> artifactPlugins = this.createArtifactPluginList(domainClassLoader, resolvedArtifactPluginDescriptors);
        DefaultMuleDomain defaultMuleDomain = new DefaultMuleDomain(domainDescriptor, (ArtifactClassLoader)domainClassLoader, this.classLoaderRepository, this.serviceRepository, artifactPlugins, this.extensionModelLoaderManager, this.getRuntimeComponentBuildingDefinitionProvider());
        DomainWrapper domainWrapper = new DomainWrapper(defaultMuleDomain, this);
        this.domainManager.addDomain(domainWrapper);
        return domainWrapper;
    }

    @Override
    public DeployableArtifactDescriptor createArtifactDescriptor(File artifactLocation, Optional<Properties> deploymentProperties) {
        return (DeployableArtifactDescriptor)this.domainDescriptorFactory.create(artifactLocation, deploymentProperties);
    }
}

