/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.artifact;

import org.mule.runtime.api.config.custom.ServiceConfigurator;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.util.func.CheckedConsumer;
import org.mule.runtime.core.internal.connection.CompositeConnectionManager;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.core.internal.connection.DelegateConnectionManagerAdapter;
import org.mule.runtime.core.privileged.registry.LegacyRegistryUtils;
import org.mule.runtime.deployment.model.api.DeployableArtifact;

public class ConnectionManagerConfigurationBuilder
implements ConfigurationBuilder {
    private final CheckedConsumer<MuleContext> muleContextConfigurer;

    ConnectionManagerConfigurationBuilder(DeployableArtifact parentArtifact) {
        Preconditions.checkNotNull((Object)parentArtifact, (String)"'parentArtifact' can't be null");
        this.muleContextConfigurer = muleContext -> {
            ConnectionManagerAdapter parentConnectionManager = (ConnectionManagerAdapter)LegacyRegistryUtils.lookupObject((MuleContext)((MuleContext)parentArtifact.getRegistry().lookupByType(MuleContext.class).get()), (String)"_muleConnectionManager");
            if (parentConnectionManager != null) {
                CompositeConnectionManager connectionManager = new CompositeConnectionManager((ConnectionManagerAdapter)new DelegateConnectionManagerAdapter(muleContext), parentConnectionManager);
                this.registerConnectionManager((MuleContext)muleContext, (ConnectionManager)connectionManager);
            } else {
                this.registerDefaultConnectionManager((MuleContext)muleContext);
            }
        };
    }

    ConnectionManagerConfigurationBuilder() {
        this.muleContextConfigurer = muleContext -> this.registerDefaultConnectionManager((MuleContext)muleContext);
    }

    public void configure(MuleContext muleContext) throws ConfigurationException {
        try {
            this.muleContextConfigurer.acceptChecked((Object)muleContext);
        }
        catch (Throwable e) {
            throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)"An error occurred trying to register the Mule Connection Manager"), e);
        }
    }

    private void registerDefaultConnectionManager(MuleContext muleContext) {
        this.registerConnectionManager(muleContext, (ConnectionManager)new DelegateConnectionManagerAdapter(muleContext));
    }

    private void registerConnectionManager(MuleContext muleContext, ConnectionManager connectionManager) {
        muleContext.getCustomizationService().overrideDefaultServiceImpl("_muleConnectionManager", (Object)connectionManager);
    }

    public void addServiceConfigurator(ServiceConfigurator serviceConfigurator) {
    }
}

