/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal;

import org.mule.runtime.api.service.ServiceRepository;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.internal.ContainerClassLoaderFactory;
import org.mule.runtime.container.internal.ContainerModuleDiscoverer;
import org.mule.runtime.container.internal.DefaultModuleRepository;
import org.mule.runtime.container.internal.ModuleDiscoverer;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.core.internal.config.RuntimeComponentBuildingDefinitionsUtil;
import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginClassLoaderFactory;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.DefaultRegionPluginClassLoadersFactory;
import org.mule.runtime.deployment.model.internal.RegionPluginClassLoadersFactory;
import org.mule.runtime.deployment.model.internal.application.MuleApplicationClassLoaderFactory;
import org.mule.runtime.deployment.model.internal.domain.DomainClassLoaderFactory;
import org.mule.runtime.deployment.model.internal.nativelib.DefaultNativeLibraryFinderFactory;
import org.mule.runtime.deployment.model.internal.nativelib.NativeLibraryFinderFactory;
import org.mule.runtime.deployment.model.internal.plugin.BundlePluginDependenciesResolver;
import org.mule.runtime.deployment.model.internal.plugin.PluginDependenciesResolver;
import org.mule.runtime.deployment.model.internal.policy.PolicyTemplateClassLoaderFactory;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinitionProvider;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderManager;
import org.mule.runtime.module.artifact.api.classloader.DeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.classloader.TrackingArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.classloader.TrackingDeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidatorBuilder;
import org.mule.runtime.module.artifact.api.descriptor.DescriptorLoaderRepository;
import org.mule.runtime.module.deployment.impl.internal.application.ApplicationClassLoaderBuilderFactory;
import org.mule.runtime.module.deployment.impl.internal.application.ApplicationDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.application.DefaultApplicationFactory;
import org.mule.runtime.module.deployment.impl.internal.application.ToolingApplicationDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.artifact.DefaultClassLoaderManager;
import org.mule.runtime.module.deployment.impl.internal.artifact.ServiceRegistryDescriptorLoaderRepository;
import org.mule.runtime.module.deployment.impl.internal.domain.DefaultDomainFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DefaultDomainManager;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainClassLoaderBuilderFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainRepository;
import org.mule.runtime.module.deployment.impl.internal.plugin.ArtifactPluginDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.plugin.ArtifactPluginDescriptorLoader;
import org.mule.runtime.module.deployment.impl.internal.plugin.MuleExtensionModelLoaderManager;
import org.mule.runtime.module.deployment.impl.internal.policy.ApplicationPolicyTemplateClassLoaderBuilderFactory;
import org.mule.runtime.module.extension.internal.loader.ExtensionModelLoaderManager;
import org.mule.runtime.module.extension.internal.loader.ExtensionModelLoaderRepository;
import org.mule.runtime.module.license.api.LicenseValidator;
import org.mule.runtime.module.license.api.LicenseValidatorProvider;
import org.mule.runtime.module.service.api.discoverer.ServiceDiscoverer;
import org.mule.runtime.module.service.api.discoverer.ServiceProviderDiscoverer;
import org.mule.runtime.module.service.api.manager.ServiceManager;
import org.mule.runtime.module.service.internal.artifact.ServiceClassLoaderFactory;
import org.mule.runtime.module.service.internal.discoverer.DefaultServiceDiscoverer;
import org.mule.runtime.module.service.internal.discoverer.FileSystemServiceProviderDiscoverer;
import org.mule.runtime.module.service.internal.discoverer.ReflectionServiceProviderResolutionHelper;
import org.mule.runtime.module.service.internal.discoverer.ReflectionServiceResolver;
import org.mule.runtime.module.service.internal.discoverer.ServiceProviderResolutionHelper;
import org.mule.runtime.module.service.internal.discoverer.ServiceResolver;

public class MuleArtifactResourcesRegistry {
    private final ArtifactPluginDescriptorLoader artifactPluginDescriptorLoader;
    private final DefaultDomainManager domainManager;
    private final DefaultDomainFactory domainFactory;
    private final DefaultApplicationFactory applicationFactory;
    private final DeployableArtifactClassLoaderFactory<DomainDescriptor> domainClassLoaderFactory;
    private final ArtifactClassLoader containerClassLoader;
    private final ServiceManager serviceManager;
    private final ExtensionModelLoaderManager extensionModelLoaderManager;
    private final ArtifactClassLoaderFactory<ArtifactPluginDescriptor> artifactPluginClassLoaderFactory;
    private final DefaultClassLoaderManager artifactClassLoaderManager;
    private final ApplicationClassLoaderBuilderFactory applicationClassLoaderBuilderFactory;
    private final DomainClassLoaderBuilderFactory domainClassLoaderBuilderFactory;
    private final DomainDescriptorFactory domainDescriptorFactory;
    private final ApplicationDescriptorFactory applicationDescriptorFactory;
    private final PluginDependenciesResolver pluginDependenciesResolver;
    private final ServiceRegistryDescriptorLoaderRepository descriptorLoaderRepository;
    private final RegionPluginClassLoadersFactory pluginClassLoadersFactory;
    private final ToolingApplicationDescriptorFactory toolingApplicationDescriptorFactory;

    private MuleArtifactResourcesRegistry(ModuleRepository moduleRepository) {
        this.containerClassLoader = new ContainerClassLoaderFactory(moduleRepository).createContainerClassLoader(this.getClass().getClassLoader());
        this.artifactClassLoaderManager = new DefaultClassLoaderManager();
        LicenseValidator licenseValidator = LicenseValidatorProvider.discoverLicenseValidator((ClassLoader)Thread.currentThread().getContextClassLoader());
        this.domainManager = new DefaultDomainManager();
        this.domainClassLoaderFactory = this.trackDeployableArtifactClassLoaderFactory((DeployableArtifactClassLoaderFactory)new DomainClassLoaderFactory(this.containerClassLoader.getClassLoader()));
        this.artifactPluginClassLoaderFactory = this.trackArtifactClassLoaderFactory((ArtifactClassLoaderFactory)new ArtifactPluginClassLoaderFactory());
        ArtifactPluginDescriptorFactory artifactPluginDescriptorFactory = new ArtifactPluginDescriptorFactory();
        this.artifactPluginDescriptorLoader = new ArtifactPluginDescriptorLoader(artifactPluginDescriptorFactory);
        this.descriptorLoaderRepository = new ServiceRegistryDescriptorLoaderRepository((ServiceRegistry)new SpiServiceRegistry());
        ArtifactDescriptorValidatorBuilder artifactDescriptorValidatorBuilder = ArtifactDescriptorValidatorBuilder.builder();
        this.domainDescriptorFactory = new DomainDescriptorFactory(this.artifactPluginDescriptorLoader, this.descriptorLoaderRepository, artifactDescriptorValidatorBuilder);
        this.applicationDescriptorFactory = new ApplicationDescriptorFactory(this.artifactPluginDescriptorLoader, this.descriptorLoaderRepository, artifactDescriptorValidatorBuilder);
        DeployableArtifactClassLoaderFactory applicationClassLoaderFactory = this.trackDeployableArtifactClassLoaderFactory((DeployableArtifactClassLoaderFactory)new MuleApplicationClassLoaderFactory((NativeLibraryFinderFactory)new DefaultNativeLibraryFinderFactory()));
        this.pluginDependenciesResolver = new BundlePluginDependenciesResolver((ArtifactDescriptorFactory)artifactPluginDescriptorFactory);
        this.pluginClassLoadersFactory = new DefaultRegionPluginClassLoadersFactory(this.artifactPluginClassLoaderFactory, moduleRepository);
        this.applicationClassLoaderBuilderFactory = new ApplicationClassLoaderBuilderFactory(applicationClassLoaderFactory, this.artifactPluginClassLoaderFactory, this.pluginClassLoadersFactory);
        this.domainClassLoaderBuilderFactory = new DomainClassLoaderBuilderFactory(this.containerClassLoader, this.domainClassLoaderFactory, this.pluginClassLoadersFactory);
        ServiceClassLoaderFactory serviceClassLoaderFactory = new ServiceClassLoaderFactory();
        this.serviceManager = ServiceManager.create((ServiceDiscoverer)new DefaultServiceDiscoverer((ServiceProviderDiscoverer)new FileSystemServiceProviderDiscoverer(this.containerClassLoader, this.trackArtifactClassLoaderFactory((ArtifactClassLoaderFactory)serviceClassLoaderFactory), (DescriptorLoaderRepository)this.descriptorLoaderRepository, artifactDescriptorValidatorBuilder), (ServiceResolver)new ReflectionServiceResolver((ServiceProviderResolutionHelper)new ReflectionServiceProviderResolutionHelper())));
        this.extensionModelLoaderManager = new MuleExtensionModelLoaderManager(this.containerClassLoader);
        ComponentBuildingDefinitionProvider runtimeComponentBuildingDefinitionProvider = RuntimeComponentBuildingDefinitionsUtil.getRuntimeComponentBuildingDefinitionProvider();
        this.domainFactory = new DefaultDomainFactory(this.domainDescriptorFactory, this.domainManager, this.artifactClassLoaderManager, (ServiceRepository)this.serviceManager, this.pluginDependenciesResolver, this.domainClassLoaderBuilderFactory, this.extensionModelLoaderManager, licenseValidator, runtimeComponentBuildingDefinitionProvider);
        DeployableArtifactClassLoaderFactory policyClassLoaderFactory = this.trackDeployableArtifactClassLoaderFactory((DeployableArtifactClassLoaderFactory)new PolicyTemplateClassLoaderFactory());
        ApplicationPolicyTemplateClassLoaderBuilderFactory policyTemplateClassLoaderBuilderFactory = new ApplicationPolicyTemplateClassLoaderBuilderFactory(policyClassLoaderFactory, this.pluginClassLoadersFactory);
        this.applicationFactory = new DefaultApplicationFactory(this.applicationClassLoaderBuilderFactory, this.applicationDescriptorFactory, this.domainManager, (ServiceRepository)this.serviceManager, (ExtensionModelLoaderRepository)this.extensionModelLoaderManager, this.artifactClassLoaderManager, policyTemplateClassLoaderBuilderFactory, this.pluginDependenciesResolver, this.artifactPluginDescriptorLoader, licenseValidator, runtimeComponentBuildingDefinitionProvider);
        this.toolingApplicationDescriptorFactory = new ToolingApplicationDescriptorFactory(this.artifactPluginDescriptorLoader, this.descriptorLoaderRepository, artifactDescriptorValidatorBuilder);
    }

    private <T extends ArtifactDescriptor> ArtifactClassLoaderFactory<T> trackArtifactClassLoaderFactory(ArtifactClassLoaderFactory<T> artifactClassLoaderFactory) {
        return new TrackingArtifactClassLoaderFactory((ArtifactClassLoaderManager)this.artifactClassLoaderManager, artifactClassLoaderFactory);
    }

    private <T extends ArtifactDescriptor> DeployableArtifactClassLoaderFactory<T> trackDeployableArtifactClassLoaderFactory(DeployableArtifactClassLoaderFactory<T> deployableArtifactClassLoaderFactory) {
        return new TrackingDeployableArtifactClassLoaderFactory((ArtifactClassLoaderManager)this.artifactClassLoaderManager, deployableArtifactClassLoaderFactory);
    }

    public ArtifactPluginDescriptorLoader getArtifactPluginDescriptorLoader() {
        return this.artifactPluginDescriptorLoader;
    }

    public DefaultDomainFactory getDomainFactory() {
        return this.domainFactory;
    }

    public DomainRepository getDomainRepository() {
        return this.domainManager;
    }

    public DomainDescriptorFactory getDomainDescriptorFactory() {
        return this.domainDescriptorFactory;
    }

    public DefaultApplicationFactory getApplicationFactory() {
        return this.applicationFactory;
    }

    public DeployableArtifactClassLoaderFactory<DomainDescriptor> getDomainClassLoaderFactory() {
        return this.domainClassLoaderFactory;
    }

    public ArtifactClassLoaderFactory<ArtifactPluginDescriptor> getArtifactPluginClassLoaderFactory() {
        return this.artifactPluginClassLoaderFactory;
    }

    public ArtifactClassLoader getContainerClassLoader() {
        return this.containerClassLoader;
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public ExtensionModelLoaderManager getExtensionModelLoaderManager() {
        return this.extensionModelLoaderManager;
    }

    public DefaultClassLoaderManager getArtifactClassLoaderManager() {
        return this.artifactClassLoaderManager;
    }

    public ToolingApplicationDescriptorFactory getToolingApplicationDescriptorFactory() {
        return this.toolingApplicationDescriptorFactory;
    }

    public PluginDependenciesResolver getPluginDependenciesResolver() {
        return this.pluginDependenciesResolver;
    }

    public static class Builder {
        private ModuleRepository moduleRepository;

        public Builder moduleRepository(ModuleRepository moduleRepository) {
            Preconditions.checkArgument((moduleRepository != null ? 1 : 0) != 0, (String)"moduleRepository cannot be null");
            this.moduleRepository = moduleRepository;
            return this;
        }

        public MuleArtifactResourcesRegistry build() {
            if (this.moduleRepository == null) {
                this.moduleRepository = new DefaultModuleRepository((ModuleDiscoverer)new ContainerModuleDiscoverer(this.getClass().getClassLoader()));
            }
            return new MuleArtifactResourcesRegistry(this.moduleRepository);
        }
    }
}

