/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.deployment.impl.internal.artifact;

import static org.junit.Assert.assertEquals;

import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.internal.context.DefaultMuleContext;
import org.mule.tck.junit4.AbstractMuleTestCase;

import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.event.Level;

class ArtifactSplashScreenTestCase extends AbstractMuleTestCase {

  @ParameterizedTest
  @ValueSource(booleans = {true, false})
  void muleContextSplashScreenRendering(boolean containerMode) throws Exception {
    final var splashScreenConfigurationBuilder = new SplashScreenConfigurationBuilder(Level.INFO);

    final var muleConfiguration = mock(MuleConfiguration.class);
    when(muleConfiguration.isContainerMode()).thenReturn(containerMode);

    final var muleContext = new DefaultMuleContext();
    muleContext.setMuleConfiguration(muleConfiguration);
    muleContext.setArtifactType(ArtifactType.APP);
    splashScreenConfigurationBuilder.configure(muleContext);

    String initialStartBoilerPlate = splashScreenConfigurationBuilder.buildStartupSplash(muleContext).toString();
    String subsequentStartBoilerPlate = splashScreenConfigurationBuilder.buildStartupSplash(muleContext).toString();

    // Only lightly validate on size because content changes, e.g. server start time-stamp
    assertEquals("Splash-screen sizes differ, ", initialStartBoilerPlate.length(), subsequentStartBoilerPlate.length());
  }

}
