/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.builder;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptorBuilder;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.deployment.persistence.MulePluginModelJsonSerializer;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.builder.AbstractArtifactFileBuilder;
import org.mule.tck.ZipUtils;

public class ArtifactPluginFileBuilder
extends AbstractArtifactFileBuilder<ArtifactPluginFileBuilder> {
    private final Properties properties = new Properties();
    private MulePluginModel mulePluginModel;

    public ArtifactPluginFileBuilder(String artifactId) {
        super(artifactId);
        this.withClassifier("mule-plugin");
    }

    protected ArtifactPluginFileBuilder getThis() {
        return this;
    }

    public ArtifactPluginFileBuilder configuredWith(String propertyName, String propertyValue) {
        this.checkImmutable();
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)propertyName) ? 1 : 0) != 0, (Object)"Property name cannot be empty");
        Objects.requireNonNull(propertyValue, "Property value cannot be null");
        this.properties.put(propertyName, propertyValue);
        return this;
    }

    public ArtifactPluginFileBuilder describedBy(MulePluginModel mulePluginModel) {
        this.checkImmutable();
        Objects.requireNonNull(mulePluginModel, "JSON describer cannot be null");
        this.mulePluginModel = mulePluginModel;
        return this;
    }

    public ArtifactPluginFileBuilder containingClass(File classFile, String alias) {
        this.checkImmutable();
        Objects.requireNonNull(classFile, "Class file cannot be null");
        this.resources.add(new ZipUtils.ZipResource(classFile.getAbsolutePath(), alias));
        return this.getThis();
    }

    protected List<ZipUtils.ZipResource> getCustomResources() {
        LinkedList<ZipUtils.ZipResource> customResources = new LinkedList<ZipUtils.ZipResource>();
        if (!this.properties.isEmpty()) {
            MulePluginModel.MulePluginModelBuilder builder = new MulePluginModel.MulePluginModelBuilder();
            ((MulePluginModel.MulePluginModelBuilder)((MulePluginModel.MulePluginModelBuilder)builder.setName(this.getArtifactId())).setMinMuleVersion("4.0.0")).setRequiredProduct(Product.MULE);
            MuleArtifactLoaderDescriptorBuilder classLoaderModelDescriptorBuilder = new MuleArtifactLoaderDescriptorBuilder().setId("mule");
            if (this.properties.containsKey("artifact.export.classPackages")) {
                classLoaderModelDescriptorBuilder.addProperty("exportedPackages", (Object)((String)this.properties.get("artifact.export.classPackages")).split(","));
            }
            if (this.properties.containsKey("artifact.privileged.classPackages")) {
                classLoaderModelDescriptorBuilder.addProperty("privilegedExportedPackages", (Object)((String)this.properties.get("artifact.privileged.classPackages")).split(","));
            }
            if (this.properties.containsKey("artifact.privileged.artifactIds")) {
                classLoaderModelDescriptorBuilder.addProperty("privilegedArtifactIds", (Object)((String)this.properties.get("artifact.privileged.artifactIds")).split(","));
            }
            if (this.properties.containsKey("artifact.export.resources")) {
                classLoaderModelDescriptorBuilder.addProperty("exportedResources", (Object)((String)this.properties.get("artifact.export.resources")).split(","));
            }
            builder.withClassLoaderModelDescriptorLoader(classLoaderModelDescriptorBuilder.build());
            builder.withBundleDescriptorLoader(new MuleArtifactLoaderDescriptor("mule", Collections.emptyMap()));
            this.mulePluginModel = builder.build();
        }
        if (this.mulePluginModel != null) {
            File jsonDescriptorFile = new File(this.getTempFolder(), ArtifactDescriptor.MULE_ARTIFACT_FOLDER + File.separator + "mule-artifact.json");
            jsonDescriptorFile.deleteOnExit();
            String jsonDescriber = new MulePluginModelJsonSerializer().serialize((AbstractMuleArtifactModel)this.mulePluginModel);
            try {
                FileUtils.writeStringToFile((File)jsonDescriptorFile, (String)jsonDescriber);
            }
            catch (IOException e) {
                throw new IllegalStateException("There was an issue generating the JSON file for " + this.getId(), e);
            }
            customResources.add(new ZipUtils.ZipResource(jsonDescriptorFile.getAbsolutePath(), "META-INF/mule-artifact/mule-artifact.json"));
        }
        return customResources;
    }

    public String getConfigFile() {
        return null;
    }

    protected Optional<MuleArtifactLoaderDescriptor> getBundleDescriptorLoader() {
        return Optional.ofNullable(this.mulePluginModel != null ? this.mulePluginModel.getBundleDescriptorLoader() : null);
    }
}

