/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.builder;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.mule.maven.pom.parser.api.model.BundleScope;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptorBuilder;
import org.mule.runtime.api.deployment.meta.MuleDomainModel;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.deployment.persistence.MuleDomainModelJsonSerializer;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.deployment.impl.internal.builder.DeployableFileBuilder;
import org.mule.tck.ZipUtils;

public class DomainFileBuilder
extends DeployableFileBuilder<DomainFileBuilder> {
    private Properties properties = new Properties();

    public DomainFileBuilder(String artifactId) {
        super(artifactId);
    }

    public DomainFileBuilder(DomainFileBuilder source) {
        super(source);
    }

    public DomainFileBuilder(String artifactId, DomainFileBuilder source) {
        super(artifactId, source);
    }

    public String getClassifier() {
        return "mule-domain";
    }

    public String getScope() {
        return BundleScope.PROVIDED.name();
    }

    public DomainFileBuilder configuredWith(String propertyName, String propertyValue) {
        this.checkImmutable();
        Objects.requireNonNull(Boolean.valueOf(!StringUtils.isEmpty((CharSequence)propertyName)), "propertyName cannot be empty");
        Objects.requireNonNull(Boolean.valueOf(propertyValue != null), "propertyValue cannot be null");
        this.properties.put(propertyName, propertyValue);
        return this;
    }

    protected DomainFileBuilder getThis() {
        return this;
    }

    public DomainFileBuilder definedBy(String configFile) {
        this.checkImmutable();
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)configFile) ? 1 : 0) != 0, (String)"Config file cannot be empty");
        this.resources.add(new ZipUtils.ZipResource(configFile, "mule-domain-config.xml"));
        return this;
    }

    @Override
    protected List<ZipUtils.ZipResource> doGetCustomResources() {
        LinkedList<ZipUtils.ZipResource> customResources = new LinkedList<ZipUtils.ZipResource>();
        ZipUtils.ZipResource domainProperties = this.createPropertiesFile(this.deployProperties, "mule-deploy.properties", "mule-deploy.properties");
        if (domainProperties != null) {
            customResources.add(domainProperties);
        }
        Object redeploymentEnabled = this.deployProperties.get("redeployment.enabled");
        Optional<String> configResources = Optional.ofNullable((String)this.deployProperties.get("config.resources"));
        Optional<String> exportedResources = Optional.ofNullable((String)this.properties.get("artifact.export.resources"));
        Optional<String> exportedClassPackages = Optional.ofNullable((String)this.properties.get("artifact.export.classPackages"));
        File domainDescriptor = this.createDomainJsonDescriptorFile(redeploymentEnabled == null ? Optional.empty() : Optional.ofNullable(Boolean.valueOf((String)redeploymentEnabled)), configResources, exportedResources, exportedClassPackages);
        customResources.add(new ZipUtils.ZipResource(domainDescriptor.getAbsolutePath(), ArtifactDescriptor.MULE_ARTIFACT_JSON_DESCRIPTOR_LOCATION));
        return customResources;
    }

    public String getConfigFile() {
        return "mule-domain-config.xml";
    }

    private File createDomainJsonDescriptorFile(Optional<Boolean> redeploymentEnabled, Optional<String> configResources, Optional<String> exportedResources, Optional<String> exportedClassPackages) {
        File domainDescriptor = new File(this.getTempFolder(), this.getArtifactId() + "domain.json");
        domainDescriptor.deleteOnExit();
        MuleDomainModel.MuleDomainModelBuilder muleDomainModelBuilder = new MuleDomainModel.MuleDomainModelBuilder();
        ((MuleDomainModel.MuleDomainModelBuilder)((MuleDomainModel.MuleDomainModelBuilder)muleDomainModelBuilder.setName(this.getArtifactId())).setMinMuleVersion("4.0.0")).setRequiredProduct(Product.MULE);
        redeploymentEnabled.ifPresent(x$0 -> muleDomainModelBuilder.setRedeploymentEnabled(x$0));
        configResources.ifPresent(configs -> {
            String[] configFiles = configs.split(",");
            muleDomainModelBuilder.setConfigs(new HashSet<String>(Arrays.asList(configFiles)));
        });
        MuleArtifactLoaderDescriptorBuilder muleArtifactClassLoaderDescriptorBuilder = new MuleArtifactLoaderDescriptorBuilder().setId("mule");
        exportedResources.ifPresent(resources -> muleArtifactClassLoaderDescriptorBuilder.addProperty("exportedResources", (Object)resources.split(",")));
        exportedClassPackages.ifPresent(packages -> muleArtifactClassLoaderDescriptorBuilder.addProperty("exportedPackages", (Object)packages.split(",")));
        muleDomainModelBuilder.withClassLoaderModelDescriptorLoader(muleArtifactClassLoaderDescriptorBuilder.build());
        muleDomainModelBuilder.withBundleDescriptorLoader(new MuleArtifactLoaderDescriptor("mule", Collections.emptyMap()));
        String applicationDescriptorContent = new MuleDomainModelJsonSerializer().serialize((AbstractMuleArtifactModel)((MuleDomainModel)muleDomainModelBuilder.build()));
        try (FileWriter fileWriter = new FileWriter(domainDescriptor);){
            fileWriter.write(applicationDescriptorContent);
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        return domainDescriptor;
    }
}

