/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.application;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.memory.management.MemoryManagementService;
import org.mule.runtime.api.service.ServiceRepository;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.internal.util.MuleContainerUtils;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.artifact.ArtifactConfigurationProcessor;
import org.mule.runtime.deployment.model.api.builder.ApplicationClassLoaderBuilder;
import org.mule.runtime.deployment.model.api.builder.ApplicationClassLoaderBuilderFactory;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPlugin;
import org.mule.runtime.deployment.model.api.plugin.resolver.PluginDependenciesResolver;
import org.mule.runtime.deployment.model.internal.DefaultRegionPluginClassLoadersFactory;
import org.mule.runtime.internal.memory.management.ArtifactMemoryManagementService;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.artifact.activation.api.descriptor.DeployableArtifactDescriptorCreator;
import org.mule.runtime.module.artifact.activation.api.descriptor.DeployableArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.activation.api.descriptor.DomainDescriptorResolutionException;
import org.mule.runtime.module.artifact.activation.api.descriptor.DomainDescriptorResolver;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionModelLoaderRepository;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;
import org.mule.runtime.module.deployment.impl.internal.application.ApplicationWrapper;
import org.mule.runtime.module.deployment.impl.internal.application.DefaultMuleApplication;
import org.mule.runtime.module.deployment.impl.internal.application.MuleApplicationPolicyProvider;
import org.mule.runtime.module.deployment.impl.internal.artifact.AbstractDeployableArtifactFactory;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.AmbiguousDomainReferenceException;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainNotFoundException;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainRepository;
import org.mule.runtime.module.deployment.impl.internal.plugin.DefaultArtifactPlugin;
import org.mule.runtime.module.deployment.impl.internal.policy.DefaultPolicyInstanceProviderFactory;
import org.mule.runtime.module.deployment.impl.internal.policy.DefaultPolicyTemplateFactory;
import org.mule.runtime.module.deployment.impl.internal.policy.PolicyTemplateClassLoaderBuilderFactory;
import org.mule.runtime.module.deployment.impl.internal.util.DeploymentPropertiesUtils;
import org.mule.runtime.module.license.api.LicenseValidator;

public class DefaultApplicationFactory
extends AbstractDeployableArtifactFactory<ApplicationDescriptor, Application>
implements ArtifactFactory<ApplicationDescriptor, Application> {
    private final DeployableArtifactDescriptorFactory deployableArtifactDescriptorFactory;
    private final DomainRepository domainRepository;
    private final ApplicationClassLoaderBuilderFactory applicationClassLoaderBuilderFactory;
    private final ServiceRepository serviceRepository;
    private final ExtensionModelLoaderRepository extensionModelLoaderRepository;
    private final ClassLoaderRepository classLoaderRepository;
    private final PolicyTemplateClassLoaderBuilderFactory policyTemplateClassLoaderBuilderFactory;
    private final PluginDependenciesResolver pluginDependenciesResolver;
    private final LicenseValidator licenseValidator;
    private final Consumer<ClassLoader> actionOnMuleArtifactDeployment;

    public DefaultApplicationFactory(ApplicationClassLoaderBuilderFactory applicationClassLoaderBuilderFactory, DeployableArtifactDescriptorFactory deployableArtifactDescriptorFactory, DomainRepository domainRepository, ServiceRepository serviceRepository, ExtensionModelLoaderRepository extensionModelLoaderRepository, ClassLoaderRepository classLoaderRepository, PolicyTemplateClassLoaderBuilderFactory policyTemplateClassLoaderBuilderFactory, PluginDependenciesResolver pluginDependenciesResolver, LicenseValidator licenseValidator, MemoryManagementService memoryManagementService, ArtifactConfigurationProcessor artifactConfigurationProcessor) {
        this(applicationClassLoaderBuilderFactory, deployableArtifactDescriptorFactory, domainRepository, serviceRepository, extensionModelLoaderRepository, classLoaderRepository, policyTemplateClassLoaderBuilderFactory, pluginDependenciesResolver, licenseValidator, memoryManagementService, artifactConfigurationProcessor, cl -> {});
    }

    public DefaultApplicationFactory(ApplicationClassLoaderBuilderFactory applicationClassLoaderBuilderFactory, DeployableArtifactDescriptorFactory deployableArtifactDescriptorFactory, DomainRepository domainRepository, ServiceRepository serviceRepository, ExtensionModelLoaderRepository extensionModelLoaderRepository, ClassLoaderRepository classLoaderRepository, PolicyTemplateClassLoaderBuilderFactory policyTemplateClassLoaderBuilderFactory, PluginDependenciesResolver pluginDependenciesResolver, LicenseValidator licenseValidator, MemoryManagementService memoryManagementService, ArtifactConfigurationProcessor artifactConfigurationProcessor, Consumer<ClassLoader> actionOnMuleArtifactDeployment) {
        super(licenseValidator, memoryManagementService, artifactConfigurationProcessor);
        Preconditions.checkArgument((applicationClassLoaderBuilderFactory != null ? 1 : 0) != 0, (String)"Application classloader builder factory cannot be null");
        Preconditions.checkArgument((deployableArtifactDescriptorFactory != null ? 1 : 0) != 0, (String)"Deployable artifact descriptor factory cannot be null");
        Preconditions.checkArgument((domainRepository != null ? 1 : 0) != 0, (String)"Domain repository cannot be null");
        Preconditions.checkArgument((serviceRepository != null ? 1 : 0) != 0, (String)"Service repository cannot be null");
        Preconditions.checkArgument((extensionModelLoaderRepository != null ? 1 : 0) != 0, (String)"extensionModelLoaderRepository cannot be null");
        Preconditions.checkArgument((classLoaderRepository != null ? 1 : 0) != 0, (String)"classLoaderRepository cannot be null");
        Preconditions.checkArgument((policyTemplateClassLoaderBuilderFactory != null ? 1 : 0) != 0, (String)"policyClassLoaderBuilderFactory cannot be null");
        Preconditions.checkArgument((pluginDependenciesResolver != null ? 1 : 0) != 0, (String)"pluginDependenciesResolver cannot be null");
        Preconditions.checkArgument((memoryManagementService != null ? 1 : 0) != 0, (String)"memoryManagementService cannot be null");
        Preconditions.checkArgument((artifactConfigurationProcessor != null ? 1 : 0) != 0, (String)"artifactConfigurationProcessor cannot be null");
        Preconditions.checkArgument((actionOnMuleArtifactDeployment != null ? 1 : 0) != 0, (String)"actionOnMuleArtifactDeployment cannot be null");
        this.classLoaderRepository = classLoaderRepository;
        this.applicationClassLoaderBuilderFactory = applicationClassLoaderBuilderFactory;
        this.deployableArtifactDescriptorFactory = deployableArtifactDescriptorFactory;
        this.domainRepository = domainRepository;
        this.serviceRepository = serviceRepository;
        this.extensionModelLoaderRepository = extensionModelLoaderRepository;
        this.policyTemplateClassLoaderBuilderFactory = policyTemplateClassLoaderBuilderFactory;
        this.pluginDependenciesResolver = pluginDependenciesResolver;
        this.licenseValidator = licenseValidator;
        this.actionOnMuleArtifactDeployment = actionOnMuleArtifactDeployment;
    }

    @Override
    protected Application doCreateArtifact(File artifactDir, Optional<Properties> properties) throws IOException {
        String appName = artifactDir.getName();
        if (appName.contains(" ")) {
            throw new IllegalArgumentException("Mule application name may not contain spaces: " + appName);
        }
        ApplicationDescriptor descriptor = this.createArtifactDescriptor(artifactDir, properties);
        return this.createArtifact(descriptor);
    }

    @Override
    public File getArtifactDir() {
        return MuleContainerUtils.getMuleAppsDir();
    }

    public ApplicationDescriptor createArtifactDescriptor(File artifactLocation, Optional<Properties> deploymentProperties) {
        return this.createArtifactDescriptor(artifactLocation, this.createDeployableProjectModel(artifactLocation, false), deploymentProperties);
    }

    public ApplicationDescriptor createArtifactDescriptor(File artifactLocation, DeployableProjectModel model, Optional<Properties> deploymentProperties) {
        String appName = artifactLocation.getName();
        Map properties = deploymentProperties.or(() -> DeploymentPropertiesUtils.getPersistedDeploymentProperties(appName)).map(dp -> Maps.fromProperties((Properties)dp)).orElse(Collections.emptyMap());
        DomainDescriptorResolver domainDescriptorResolver = (domainName, bundleDescriptor) -> (DomainDescriptor)this.getDomainForDescriptor(domainName, bundleDescriptor, artifactLocation).getDescriptor();
        return this.deployableArtifactDescriptorFactory.createApplicationDescriptor(model, properties, domainDescriptorResolver, this.getDescriptorCreator());
    }

    private DeployableArtifactDescriptorCreator<ApplicationDescriptor> getDescriptorCreator() {
        return new DeployableArtifactDescriptorCreator<ApplicationDescriptor>(){

            public ApplicationDescriptor create(String name) {
                return new org.mule.runtime.deployment.model.api.application.ApplicationDescriptor(name);
            }

            public ApplicationDescriptor create(String name, Optional<Properties> deploymentProperties) {
                return new org.mule.runtime.deployment.model.api.application.ApplicationDescriptor(name, deploymentProperties);
            }
        };
    }

    public Application createArtifact(ApplicationDescriptor descriptor) throws IOException {
        Domain domain = this.getDomainForDescriptor(descriptor);
        ArtifactClassLoader domainParentClassLoader = "default".equals(domain.getArtifactName()) ? domain.getArtifactClassLoader() : (ArtifactClassLoader)domain.getArtifactClassLoader().getClassLoader().getParent();
        ApplicationClassLoaderBuilder artifactClassLoaderBuilder = this.applicationClassLoaderBuilderFactory.createArtifactClassLoaderBuilder();
        MuleDeployableArtifactClassLoader applicationClassLoader = artifactClassLoaderBuilder.setDomainParentClassLoader(domainParentClassLoader).setArtifactDescriptor((ArtifactDescriptor)descriptor).build();
        List<ArtifactPlugin> artifactPlugins = this.createArtifactPluginList(applicationClassLoader, new ArrayList<ArtifactPluginDescriptor>(descriptor.getPlugins()));
        MuleApplicationPolicyProvider applicationPolicyProvider = new MuleApplicationPolicyProvider(new DefaultPolicyTemplateFactory(this.policyTemplateClassLoaderBuilderFactory, this.pluginDependenciesResolver, this.licenseValidator), new DefaultPolicyInstanceProviderFactory(this.serviceRepository, this.classLoaderRepository, this.extensionModelLoaderRepository, this.getArtifactConfigurationProcessor()));
        DefaultMuleApplication delegate = new DefaultMuleApplication(descriptor, applicationClassLoader, artifactPlugins, this.domainRepository, this.serviceRepository, this.extensionModelLoaderRepository, descriptor.getArtifactLocation(), this.classLoaderRepository, applicationPolicyProvider, (MemoryManagementService)new ArtifactMemoryManagementService(this.getMemoryManagementService()), this.getArtifactConfigurationProcessor(), this.actionOnMuleArtifactDeployment);
        applicationPolicyProvider.setApplication(delegate);
        return new ApplicationWrapper(delegate);
    }

    private Domain getDomainForDescriptor(ApplicationDescriptor descriptor) {
        return this.getDomainForDescriptor(descriptor.getDomainName(), descriptor.getDomainDescriptor().orElse(null), descriptor.getArtifactLocation());
    }

    private Domain getDomainForDescriptor(String domainName, BundleDescriptor domainBundleDescriptor, File artifactLocation) {
        try {
            return domainName != null ? this.domainRepository.getDomain(domainName) : this.domainRepository.getCompatibleDomain(domainBundleDescriptor);
        }
        catch (DomainNotFoundException e) {
            throw new DeploymentException(I18nMessageFactory.createStaticMessage((String)String.format("Domain '%s' has to be deployed in order to deploy Application in '%s'", e.getDomainName(), artifactLocation.toString())), (Throwable)((Object)e));
        }
        catch (DomainDescriptorResolutionException e) {
            throw new DeploymentException(I18nMessageFactory.createStaticMessage((String)String.format("Problems found while retrieving domain '%s'", domainName)), (Throwable)e);
        }
        catch (AmbiguousDomainReferenceException e) {
            throw new DeploymentException(I18nMessageFactory.createStaticMessage((String)"Multiple domains were found"), (Throwable)((Object)e));
        }
    }

    private List<ArtifactPlugin> createArtifactPluginList(MuleDeployableArtifactClassLoader applicationClassLoader, List<ArtifactPluginDescriptor> plugins) {
        return plugins.stream().map(artifactPluginDescriptor -> new DefaultArtifactPlugin(DefaultRegionPluginClassLoadersFactory.getArtifactPluginId((String)applicationClassLoader.getArtifactId(), (String)artifactPluginDescriptor.getName()), (ArtifactPluginDescriptor)artifactPluginDescriptor, applicationClassLoader.getArtifactPluginClassLoaders().stream().filter(artifactClassLoader -> {
            String artifactPluginDescriptorName = "/plugin/" + artifactPluginDescriptor.getName();
            return artifactClassLoader.getArtifactId().endsWith(artifactPluginDescriptorName);
        }).findFirst().get())).collect(Collectors.toList());
    }
}

