/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.builder;

import java.io.File;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import org.mule.runtime.module.artifact.builder.AbstractArtifactFileBuilder;
import org.mule.runtime.module.deployment.impl.internal.builder.ApplicationFileBuilder;
import org.mule.runtime.module.deployment.impl.internal.builder.DomainFileBuilder;
import org.mule.tck.ZipUtils;

public class DomainBundleFileBuilder
extends AbstractArtifactFileBuilder<DomainBundleFileBuilder> {
    private static final String MULE_DOMAIN_BUNDLE_CLASSIFIER = "domain-bundle";
    private final File domainFile;
    private final List<File> applications = new LinkedList<File>();

    public DomainBundleFileBuilder(DomainFileBuilder domainFileBuilder) {
        this(domainFileBuilder.getArtifactId(), domainFileBuilder.getArtifactFile());
    }

    public DomainBundleFileBuilder(String artifactId, File domain) {
        super(artifactId);
        this.domainFile = domain;
    }

    public DomainBundleFileBuilder containing(ApplicationFileBuilder applicationFileBuilder) {
        return this.containing(applicationFileBuilder.getArtifactFile());
    }

    public DomainBundleFileBuilder containing(File applicationFile) {
        this.applications.add(applicationFile);
        return this;
    }

    protected List<ZipUtils.ZipResource> getCustomResources() {
        LinkedList<ZipUtils.ZipResource> customResources = new LinkedList<ZipUtils.ZipResource>();
        customResources.add(new ZipUtils.ZipResource(this.domainFile.getAbsolutePath(), Paths.get("domain", this.domainFile.getName()).toString()));
        for (File application : this.applications) {
            customResources.add(new ZipUtils.ZipResource(application.getAbsolutePath(), Paths.get("applications", application.getName()).toString()));
        }
        return customResources;
    }

    protected DomainBundleFileBuilder getThis() {
        return this;
    }

    public String getConfigFile() {
        return null;
    }

    protected String getFileExtension() {
        return ".zip";
    }

    public String getClassifier() {
        return MULE_DOMAIN_BUNDLE_CLASSIFIER;
    }
}

