/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.builder;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptorBuilder;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.deployment.persistence.MuleApplicationModelJsonSerializer;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.deployment.impl.internal.builder.DeployableFileBuilder;
import org.mule.tck.ZipUtils;

public class ApplicationFileBuilder
extends DeployableFileBuilder<ApplicationFileBuilder> {
    private final Properties properties = new Properties();
    private String minMuleVersion = "4.0.0";

    public ApplicationFileBuilder(String artifactId) {
        super(artifactId);
    }

    public ApplicationFileBuilder(String artifactId, boolean upperCaseInExtension) {
        super(artifactId, upperCaseInExtension);
    }

    public ApplicationFileBuilder(ApplicationFileBuilder source) {
        super(source);
    }

    public ApplicationFileBuilder(String id, ApplicationFileBuilder source) {
        super(id, source);
        this.properties.putAll((Map<?, ?>)source.properties);
        this.deployProperties.putAll((Map<?, ?>)source.deployProperties);
    }

    protected ApplicationFileBuilder getThis() {
        return this;
    }

    public ApplicationFileBuilder definedBy(String configFile) {
        this.checkImmutable();
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)configFile) ? 1 : 0) != 0, (Object)"Config file cannot be empty");
        this.resources.add(new ZipUtils.ZipResource(configFile, "mule-config.xml"));
        return this;
    }

    public ApplicationFileBuilder configuredWith(String propertyName, String propertyValue) {
        this.checkImmutable();
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)propertyName) ? 1 : 0) != 0, (Object)"Property name cannot be empty");
        Objects.requireNonNull(propertyValue, "Property value cannot be null");
        this.properties.put(propertyName, propertyValue);
        return this;
    }

    public ApplicationFileBuilder withMinMuleVersion(String minMuleVersion) {
        this.minMuleVersion = minMuleVersion;
        return this;
    }

    public String getConfigFile() {
        return "mule-config.xml";
    }

    @Override
    protected List<ZipUtils.ZipResource> doGetCustomResources() {
        LinkedList<ZipUtils.ZipResource> customResources = new LinkedList<ZipUtils.ZipResource>();
        Object redeploymentEnabled = this.deployProperties.get("redeployment.enabled");
        Object configResources = this.deployProperties.get("config.resources");
        File applicationDescriptor = this.createApplicationJsonDescriptorFile(Optional.ofNullable((String)this.deployProperties.get("domain")), this.minMuleVersion, redeploymentEnabled == null ? Optional.empty() : Optional.ofNullable(Boolean.valueOf((String)redeploymentEnabled)), Optional.ofNullable((String)configResources), Optional.ofNullable((String)this.properties.get("exportedPackages")), Optional.ofNullable((String)this.properties.get("exportedResources")));
        customResources.add(new ZipUtils.ZipResource(applicationDescriptor.getAbsolutePath(), ArtifactDescriptor.MULE_ARTIFACT_JSON_DESCRIPTOR_LOCATION));
        return customResources;
    }

    private File createApplicationJsonDescriptorFile(Optional<String> domain, String minMuleVersion, Optional<Boolean> redeploymentEnabled, Optional<String> configResources, Optional<String> exportedPackages, Optional<String> exportedResources) {
        File applicationDescriptor = new File(this.getTempFolder(), this.getArtifactId() + "application.json");
        applicationDescriptor.deleteOnExit();
        MuleApplicationModel.MuleApplicationModelBuilder muleApplicationModelBuilder = new MuleApplicationModel.MuleApplicationModelBuilder();
        ((MuleApplicationModel.MuleApplicationModelBuilder)((MuleApplicationModel.MuleApplicationModelBuilder)muleApplicationModelBuilder.setName(this.getArtifactId())).setMinMuleVersion(minMuleVersion)).setRequiredProduct(Product.MULE);
        domain.ifPresent(arg_0 -> ((MuleApplicationModel.MuleApplicationModelBuilder)muleApplicationModelBuilder).setDomain(arg_0));
        redeploymentEnabled.ifPresent(x$0 -> muleApplicationModelBuilder.setRedeploymentEnabled(x$0));
        configResources.ifPresent(configs -> {
            String[] configFiles = configs.split(",");
            muleApplicationModelBuilder.setConfigs(new HashSet<String>(Arrays.asList(configFiles)));
        });
        MuleArtifactLoaderDescriptorBuilder muleArtifactLoaderDescriptorBuilder = new MuleArtifactLoaderDescriptorBuilder().setId("mule");
        exportedPackages.ifPresent(packages -> muleArtifactLoaderDescriptorBuilder.addProperty("exportedPackages", (Object)packages.split(",")));
        exportedResources.ifPresent(resources -> muleArtifactLoaderDescriptorBuilder.addProperty("exportedResources", (Object)resources.split(",")));
        muleApplicationModelBuilder.withClassLoaderModelDescriptorLoader(muleArtifactLoaderDescriptorBuilder.build());
        muleApplicationModelBuilder.withBundleDescriptorLoader(muleArtifactLoaderDescriptorBuilder.build());
        String applicationDescriptorContent = new MuleApplicationModelJsonSerializer().serialize((AbstractMuleArtifactModel)((MuleApplicationModel)muleApplicationModelBuilder.build()));
        try (FileWriter fileWriter = new FileWriter(applicationDescriptor);){
            fileWriter.write(applicationDescriptorContent);
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        return applicationDescriptor;
    }

    public String getClassifier() {
        return ArtifactType.APP.getMavenArtifactClassifier();
    }
}

