/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.builder;

import com.google.common.base.Preconditions;
import com.vdurmont.semver4j.Semver;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.module.artifact.builder.AbstractArtifactFileBuilder;
import org.mule.runtime.module.artifact.builder.AbstractDependencyFileBuilder;
import org.mule.runtime.module.artifact.internal.util.FileJarExplorer;
import org.mule.runtime.module.artifact.internal.util.JarExplorer;
import org.mule.runtime.module.artifact.internal.util.JarInfo;
import org.mule.runtime.module.deployment.impl.internal.builder.ArtifactPluginFileBuilder;
import org.mule.runtime.module.deployment.impl.internal.builder.JarFileBuilder;
import org.mule.tck.ZipUtils;
import org.mule.tools.api.classloader.ClassLoaderModelJsonSerializer;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.classloader.model.ClassLoaderModel;

public abstract class DeployableFileBuilder<T extends DeployableFileBuilder<T>>
extends AbstractArtifactFileBuilder<T> {
    protected Properties deployProperties = new Properties();
    private final Map<PluginAdditionalDependenciesKey, List<JarFileBuilder>> additionalPluginDependencies = new HashMap<PluginAdditionalDependenciesKey, List<JarFileBuilder>>();
    private boolean useHeavyPackage = true;
    private String classloaderModelVersion = "1.0";
    private final JarExplorer jarFileExplorer = new FileJarExplorer();

    public DeployableFileBuilder(String artifactId, boolean upperCaseInExtension) {
        super(artifactId, upperCaseInExtension);
    }

    public DeployableFileBuilder(String artifactId) {
        super(artifactId);
    }

    public DeployableFileBuilder(T source) {
        super(source);
    }

    public DeployableFileBuilder(String artifactId, T source) {
        super(artifactId, source);
    }

    public T additionalPluginDependencies(ArtifactPluginFileBuilder pluginFileBuilder, JarFileBuilder dependencyFileBuilder) {
        PluginAdditionalDependenciesKey pluginAdditionalDependenciesKey = new PluginAdditionalDependenciesKey(pluginFileBuilder.getGroupId(), pluginFileBuilder.getArtifactId());
        if (!this.additionalPluginDependencies.containsKey(pluginAdditionalDependenciesKey)) {
            this.additionalPluginDependencies.put(pluginAdditionalDependenciesKey, new ArrayList());
        }
        this.additionalPluginDependencies.get(pluginAdditionalDependenciesKey).add(dependencyFileBuilder);
        return (T)((Object)((DeployableFileBuilder)this.getThis()));
    }

    public T deployedWith(String propertyName, String propertyValue) {
        this.checkImmutable();
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)propertyName) ? 1 : 0) != 0, (Object)"Property name cannot be empty");
        Preconditions.checkArgument((propertyValue != null ? 1 : 0) != 0, (Object)"Property value cannot be null");
        this.deployProperties.put(propertyName, propertyValue);
        return (T)((Object)((DeployableFileBuilder)this.getThis()));
    }

    public T usingLightWeightPackage() {
        this.useHeavyPackage = false;
        return (T)((Object)((DeployableFileBuilder)this.getThis()));
    }

    public T withClassloaderModelVersion(String classloaderModelVersion) {
        this.classloaderModelVersion = classloaderModelVersion;
        return (T)((Object)((DeployableFileBuilder)this.getThis()));
    }

    protected final List<ZipUtils.ZipResource> getCustomResources() {
        LinkedList<ZipUtils.ZipResource> customResources = new LinkedList<ZipUtils.ZipResource>();
        if (this.useHeavyPackage) {
            for (AbstractDependencyFileBuilder dependencyFileBuilder : this.getAllCompileDependencies()) {
                if (ArtifactType.DOMAIN.getMavenArtifactClassifier().equals(dependencyFileBuilder.getClassifier())) continue;
                customResources.add(new ZipUtils.ZipResource(dependencyFileBuilder.getArtifactFile().getAbsolutePath(), Paths.get("repository", dependencyFileBuilder.getArtifactFileRepositoryPath()).toString()));
                if (ArtifactType.PLUGIN.getMavenArtifactClassifier().equals(dependencyFileBuilder.getClassifier())) {
                    File pluginClassLoaderModel = this.createClassLoaderModelJsonFile(dependencyFileBuilder);
                    customResources.add(new ZipUtils.ZipResource(pluginClassLoaderModel.getAbsolutePath(), Paths.get("repository", dependencyFileBuilder.getArtifactFileRepositoryFolderPath(), "classloader-model.json").toString()));
                    continue;
                }
                customResources.add(new ZipUtils.ZipResource(dependencyFileBuilder.getArtifactPomFile().getAbsolutePath(), Paths.get("repository", dependencyFileBuilder.getArtifactFilePomRepositoryPath()).toString()));
            }
            customResources.add(new ZipUtils.ZipResource(this.getClassLoaderModelFile().getAbsolutePath(), CLASSLOADER_MODEL_JSON_DESCRIPTOR_LOCATION));
        }
        customResources.addAll(this.doGetCustomResources());
        return customResources;
    }

    private File createClassLoaderModelJsonFile(AbstractDependencyFileBuilder dependencyFileBuilder) {
        Path repository;
        ArtifactCoordinates artifactCoordinates = new ArtifactCoordinates(dependencyFileBuilder.getGroupId(), dependencyFileBuilder.getArtifactId(), dependencyFileBuilder.getVersion(), dependencyFileBuilder.getType(), dependencyFileBuilder.getClassifier());
        ClassLoaderModel classLoaderModel = new ClassLoaderModel(this.classloaderModelVersion, artifactCoordinates);
        LinkedList<Artifact> artifactDependencies = new LinkedList<Artifact>();
        List dependencies = dependencyFileBuilder.getAllClassLoaderModelDependencies();
        for (AbstractDependencyFileBuilder fileBuilderDependency : dependencies) {
            artifactDependencies.add(this.getArtifact(fileBuilderDependency, this.isShared(fileBuilderDependency)));
        }
        classLoaderModel.setDependencies(artifactDependencies);
        if (this.isSupportingPackagesResourcesInformation()) {
            JarInfo jarInfo = this.jarFileExplorer.explore(dependencyFileBuilder.getArtifactFile().toURI());
            classLoaderModel.setPackages(jarInfo.getPackages().toArray(new String[jarInfo.getPackages().size()]));
            classLoaderModel.setResources(jarInfo.getResources().toArray(new String[jarInfo.getResources().size()]));
        }
        if ((repository = Paths.get(this.getTempFolder(), "repository", dependencyFileBuilder.getArtifactFileRepositoryFolderPath())).toFile().exists()) {
            repository.toFile().delete();
        } else if (!repository.toFile().mkdirs()) {
            throw new IllegalStateException("Cannot create artifact folder inside repository");
        }
        return ClassLoaderModelJsonSerializer.serializeToFile((ClassLoaderModel)classLoaderModel, (File)repository.toFile());
    }

    protected boolean isSharedSupportedByClassLoaderVersion() {
        return !new Semver(this.classloaderModelVersion, Semver.SemverType.LOOSE).isLowerThan(CLASS_LOADER_MODEL_VERSION_110);
    }

    private File getClassLoaderModelFile() {
        File destinationFolder;
        ArtifactCoordinates artifactCoordinates = new ArtifactCoordinates(this.getGroupId(), this.getArtifactId(), this.getVersion(), this.getType(), this.getClassifier());
        ClassLoaderModel classLoaderModel = new ClassLoaderModel(this.classloaderModelVersion, artifactCoordinates);
        LinkedList<Artifact> artifactDependencies = new LinkedList<Artifact>();
        for (AbstractDependencyFileBuilder fileBuilderDependency : this.getAllClassLoaderModelDependencies()) {
            artifactDependencies.add(this.getArtifact(fileBuilderDependency, this.isShared(fileBuilderDependency)));
        }
        classLoaderModel.setDependencies(artifactDependencies);
        if (this.isSupportingPackagesResourcesInformation()) {
            File tempFile = new File(this.getTempFolder(), this.getArtifactId() + "_" + UUID.randomUUID().toString() + ".jar");
            tempFile.deleteOnExit();
            ZipUtils.compress((File)tempFile, (ZipUtils.ZipResource[])this.resources.toArray(new ZipUtils.ZipResource[0]));
            JarInfo jarInfo = this.jarFileExplorer.explore(tempFile.toURI());
            classLoaderModel.setPackages(jarInfo.getPackages().toArray(new String[jarInfo.getPackages().size()]));
            classLoaderModel.setResources(jarInfo.getResources().toArray(new String[jarInfo.getResources().size()]));
        }
        if (!(destinationFolder = Paths.get(this.getTempFolder(), new String[0]).resolve("META-INF").resolve("mule-artifact").toFile()).exists()) {
            MatcherAssert.assertThat((Object)destinationFolder.mkdirs(), (Matcher)Matchers.is((Object)true));
        }
        return ClassLoaderModelJsonSerializer.serializeToFile((ClassLoaderModel)classLoaderModel, (File)destinationFolder);
    }

    private Artifact getArtifact(AbstractDependencyFileBuilder builder, boolean shared) {
        boolean shouldAddPackagesAndResources;
        URI uri;
        ArtifactCoordinates artifactCoordinates = new ArtifactCoordinates(builder.getGroupId(), builder.getArtifactId(), builder.getVersion(), builder.getType(), builder.getClassifier(), builder.getScope());
        if (ArtifactType.DOMAIN.getMavenArtifactClassifier().equals(builder.getClassifier())) {
            try {
                uri = new URI("");
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        } else {
            uri = builder.getArtifactFile().toURI();
        }
        Artifact artifact = new Artifact(artifactCoordinates, uri);
        boolean bl = shouldAddPackagesAndResources = !ArtifactType.PLUGIN.getMavenArtifactClassifier().equals(artifact.getArtifactCoordinates().getClassifier()) && artifact.getUri() != null && StringUtils.isNotBlank((CharSequence)artifact.getUri().getPath());
        if (this.isSupportingPackagesResourcesInformation() && shouldAddPackagesAndResources) {
            JarInfo jarInfo = this.jarFileExplorer.explore(artifact.getUri());
            artifact.setPackages(jarInfo.getPackages().toArray(new String[jarInfo.getPackages().size()]));
            artifact.setResources(jarInfo.getResources().toArray(new String[jarInfo.getResources().size()]));
        }
        if (this.isSharedSupportedByClassLoaderVersion()) {
            artifact.setShared(shared);
        }
        return artifact;
    }

    private boolean isSupportingPackagesResourcesInformation() {
        return !new Semver(this.classloaderModelVersion, Semver.SemverType.LOOSE).isLowerThan("1.2.0");
    }

    protected abstract List<ZipUtils.ZipResource> doGetCustomResources();

    private class PluginAdditionalDependenciesKey {
        private final String groupId;
        private final String artifactId;

        public PluginAdditionalDependenciesKey(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PluginAdditionalDependenciesKey that = (PluginAdditionalDependenciesKey)o;
            if (!this.groupId.equals(that.groupId)) {
                return false;
            }
            return this.artifactId.equals(that.artifactId);
        }

        public int hashCode() {
            int result = this.groupId.hashCode();
            result = 31 * result + this.artifactId.hashCode();
            return result;
        }
    }
}

