/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.domain;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.api.memory.management.MemoryManagementService;
import org.mule.runtime.api.service.ServiceRepository;
import org.mule.runtime.core.internal.util.MuleContainerUtils;
import org.mule.runtime.deployment.model.api.artifact.ArtifactConfigurationProcessor;
import org.mule.runtime.deployment.model.api.builder.DomainClassLoaderBuilder;
import org.mule.runtime.deployment.model.api.builder.DomainClassLoaderBuilderFactory;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPlugin;
import org.mule.runtime.deployment.model.internal.DefaultRegionPluginClassLoadersFactory;
import org.mule.runtime.internal.memory.management.ArtifactMemoryManagementService;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.artifact.activation.api.descriptor.DeployableArtifactDescriptorCreator;
import org.mule.runtime.module.artifact.activation.api.descriptor.DeployableArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionModelLoaderRepository;
import org.mule.runtime.module.artifact.activation.internal.deployable.MuleDeployableProjectModelBuilder;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.deployment.impl.internal.artifact.AbstractDeployableArtifactFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DefaultMuleDomain;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainManager;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainWrapper;
import org.mule.runtime.module.deployment.impl.internal.domain.EmptyDomainDescriptor;
import org.mule.runtime.module.deployment.impl.internal.plugin.DefaultArtifactPlugin;
import org.mule.runtime.module.license.api.LicenseValidator;

public class DefaultDomainFactory
extends AbstractDeployableArtifactFactory<org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor, Domain> {
    private final DomainManager domainManager;
    private final DeployableArtifactDescriptorFactory deployableArtifactDescriptorFactory;
    private final ClassLoaderRepository classLoaderRepository;
    private final ServiceRepository serviceRepository;
    private final DomainClassLoaderBuilderFactory domainClassLoaderBuilderFactory;
    private final ExtensionModelLoaderRepository extensionModelLoaderRepository;

    public DefaultDomainFactory(DeployableArtifactDescriptorFactory deployableArtifactDescriptorFactory, DomainManager domainManager, ClassLoaderRepository classLoaderRepository, ServiceRepository serviceRepository, DomainClassLoaderBuilderFactory domainClassLoaderBuilderFactory, ExtensionModelLoaderRepository extensionModelLoaderRepository, LicenseValidator licenseValidator, MemoryManagementService memoryManagementService, ArtifactConfigurationProcessor artifactConfigurationProcessor) {
        super(licenseValidator, Objects.requireNonNull(memoryManagementService, "memoryManagementService cannot be null"), Objects.requireNonNull(artifactConfigurationProcessor, "artifactConfigurationProcessor cannot be null"));
        this.classLoaderRepository = classLoaderRepository;
        this.deployableArtifactDescriptorFactory = Objects.requireNonNull(deployableArtifactDescriptorFactory, "Deployable artifact descriptor factory cannot be null");
        this.domainManager = Objects.requireNonNull(domainManager, "Domain manager cannot be null");
        this.serviceRepository = Objects.requireNonNull(serviceRepository, "Service repository cannot be null");
        this.domainClassLoaderBuilderFactory = Objects.requireNonNull(domainClassLoaderBuilderFactory, "domainClassLoaderBuilderFactory cannot be null");
        this.extensionModelLoaderRepository = Objects.requireNonNull(extensionModelLoaderRepository, "extensionModelLoaderRepository cannot be null");
    }

    private DeployableArtifactDescriptorCreator<org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor> getDescriptorCreator() {
        return new DeployableArtifactDescriptorCreator<org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor>(){

            public DomainDescriptor create(String name) {
                return new DomainDescriptor(name);
            }

            public DomainDescriptor create(String name, Optional deploymentProperties) {
                return new DomainDescriptor(name, deploymentProperties);
            }
        };
    }

    private List<ArtifactPlugin> createArtifactPluginList(MuleDeployableArtifactClassLoader domainClassLoader, List<ArtifactPluginDescriptor> plugins) {
        return plugins.stream().map(artifactPluginDescriptor -> new DefaultArtifactPlugin(DefaultRegionPluginClassLoadersFactory.getArtifactPluginId((String)domainClassLoader.getArtifactId(), (String)artifactPluginDescriptor.getName()), (ArtifactPluginDescriptor)artifactPluginDescriptor, domainClassLoader.getArtifactPluginClassLoaders().stream().filter(artifactClassLoader -> {
            String artifactPluginDescriptorName = "/plugin/" + artifactPluginDescriptor.getName();
            return artifactClassLoader.getArtifactId().endsWith(artifactPluginDescriptorName);
        }).findFirst().get())).collect(Collectors.toList());
    }

    @Override
    public File getArtifactDir() {
        return MuleContainerUtils.getMuleDomainsDir();
    }

    public void dispose(DomainWrapper domain) {
        this.domainManager.removeDomain(domain);
    }

    public void start(DomainWrapper domainWrapper) {
        this.domainManager.addDomain(domainWrapper);
    }

    public void deployDefaultDomain() {
        this.domainManager.addDomain(new DefaultMuleDomain(EmptyDomainDescriptor.DEFAULT_DOMAIN, this.domainClassLoaderBuilderFactory.getContainerClassLoader(), this.classLoaderRepository, this.serviceRepository, Collections.emptyList(), this.extensionModelLoaderRepository, null, this.getArtifactConfigurationProcessor()));
    }

    @Override
    protected Domain doCreateArtifact(File domainLocation, Optional<DeployableProjectModel> model, Optional<Properties> deploymentProperties) {
        this.checkDomainName(domainLocation);
        org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor domainDescriptor = this.createArtifactDescriptor(domainLocation, model, deploymentProperties);
        ArrayList<ArtifactPluginDescriptor> resolvedArtifactPluginDescriptors = new ArrayList<ArtifactPluginDescriptor>(domainDescriptor.getPlugins());
        DomainClassLoaderBuilder artifactClassLoaderBuilder = this.domainClassLoaderBuilderFactory.createArtifactClassLoaderBuilder();
        MuleDeployableArtifactClassLoader domainClassLoader = artifactClassLoaderBuilder.setArtifactDescriptor((ArtifactDescriptor)domainDescriptor).build();
        List<ArtifactPlugin> artifactPlugins = this.createArtifactPluginList(domainClassLoader, resolvedArtifactPluginDescriptors);
        DefaultMuleDomain defaultMuleDomain = new DefaultMuleDomain(domainDescriptor, (ArtifactClassLoader)domainClassLoader, this.classLoaderRepository, this.serviceRepository, artifactPlugins, this.extensionModelLoaderRepository, (MemoryManagementService)new ArtifactMemoryManagementService(this.getMemoryManagementService()), this.getArtifactConfigurationProcessor());
        DomainWrapper domainWrapper = new DomainWrapper(defaultMuleDomain, this);
        this.domainManager.addDomain(domainWrapper);
        return domainWrapper;
    }

    private void checkDomainName(File domainLocation) {
        String domainName = domainLocation.getName();
        if (this.domainManager.contains(domainName)) {
            throw new IllegalArgumentException(String.format("Domain '%s'  already exists", domainName));
        }
        if (domainName.contains(" ")) {
            throw new IllegalArgumentException("Mule domain name may not contain spaces: " + domainName);
        }
    }

    public org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor createArtifactDescriptor(File domainLocation, Optional<DeployableProjectModel> model, Optional<Properties> deploymentProperties) {
        return this.deployableArtifactDescriptorFactory.createDomainDescriptor(model.orElseGet(() -> new MuleDeployableProjectModelBuilder(domainLocation, Optional.empty()).build()), deploymentProperties.map(dp -> Maps.fromProperties((Properties)dp)).orElse(Collections.emptyMap()), this.getDescriptorCreator());
    }

    @Override
    public ArtifactType getTargetArtifactType() {
        return ArtifactType.DOMAIN;
    }
}

