/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.builder;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MulePolicyModel;
import org.mule.runtime.api.deployment.persistence.MulePolicyModelJsonSerializer;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.deployment.impl.internal.builder.DeployableFileBuilder;
import org.mule.tck.ZipUtils;

public class PolicyFileBuilder
extends DeployableFileBuilder<PolicyFileBuilder> {
    private static final String MULE_POLICY_CLASSIFIER = "mule-policy";
    private MulePolicyModel mulePolicyModel;

    public PolicyFileBuilder(String artifactId) {
        super(artifactId);
    }

    public String getConfigFile() {
        return "policy.xml";
    }

    protected PolicyFileBuilder getThis() {
        return this;
    }

    public PolicyFileBuilder describedBy(MulePolicyModel mulePolicyModel) {
        this.checkImmutable();
        Preconditions.checkArgument((mulePolicyModel != null ? 1 : 0) != 0, (String)"JSON describer cannot be null");
        this.mulePolicyModel = mulePolicyModel;
        return this;
    }

    @Override
    protected List<ZipUtils.ZipResource> doGetCustomResources() {
        LinkedList<ZipUtils.ZipResource> customResources = new LinkedList<ZipUtils.ZipResource>();
        if (this.mulePolicyModel != null) {
            File jsonDescriptorFile = new File(this.getTempFolder(), "META-INF" + File.separator + "mule-artifact" + File.separator + "mule-artifact.json");
            jsonDescriptorFile.deleteOnExit();
            String jsonDescriber = new MulePolicyModelJsonSerializer().serialize((AbstractMuleArtifactModel)this.mulePolicyModel);
            try {
                FileUtils.writeStringToFile((File)jsonDescriptorFile, (String)jsonDescriber);
            }
            catch (IOException e) {
                throw new IllegalStateException("There was an issue generating the JSON file for " + this.getId(), e);
            }
            customResources.add(new ZipUtils.ZipResource(jsonDescriptorFile.getAbsolutePath(), "META-INF/mule-artifact/mule-artifact.json"));
        }
        return customResources;
    }

    public String getClassifier() {
        return MULE_POLICY_CLASSIFIER;
    }
}

