/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.builder;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptorBuilder;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.deployment.persistence.MulePluginModelJsonSerializer;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.builder.AbstractArtifactFileBuilder;
import org.mule.tck.ZipUtils;

public class ArtifactPluginFileBuilder
extends AbstractArtifactFileBuilder<ArtifactPluginFileBuilder> {
    private final Properties properties = new Properties();
    private MulePluginModel mulePluginModel;

    public ArtifactPluginFileBuilder(String artifactId) {
        super(artifactId);
        this.withClassifier(ArtifactType.PLUGIN.getMavenArtifactClassifier());
    }

    protected ArtifactPluginFileBuilder getThis() {
        return this;
    }

    public ArtifactPluginFileBuilder configuredWith(String propertyName, String propertyValue) {
        this.checkImmutable();
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)propertyName) ? 1 : 0) != 0, (String)"Property name cannot be empty");
        Objects.requireNonNull(propertyValue, "Property value cannot be null");
        this.properties.put(propertyName, propertyValue);
        return this;
    }

    public ArtifactPluginFileBuilder describedBy(MulePluginModel mulePluginModel) {
        this.checkImmutable();
        Objects.requireNonNull(mulePluginModel, "JSON describer cannot be null");
        this.mulePluginModel = mulePluginModel;
        return this;
    }

    public ArtifactPluginFileBuilder containingClass(Path classFile, String alias) {
        this.checkImmutable();
        Objects.requireNonNull(classFile, "Class file cannot be null");
        this.resources.add(new ZipUtils.ZipResource(classFile.toAbsolutePath().toString(), alias));
        return this.getThis();
    }

    protected List<ZipUtils.ZipResource> getCustomResources() throws IOException {
        LinkedList<ZipUtils.ZipResource> customResources = new LinkedList<ZipUtils.ZipResource>();
        if (!this.properties.isEmpty()) {
            MulePluginModel.MulePluginModelBuilder builder = new MulePluginModel.MulePluginModelBuilder();
            ((MulePluginModel.MulePluginModelBuilder)((MulePluginModel.MulePluginModelBuilder)builder.setName(this.getArtifactId())).setMinMuleVersion("4.0.0")).setRequiredProduct(Product.MULE);
            MuleArtifactLoaderDescriptorBuilder classLoaderModelDescriptorBuilder = new MuleArtifactLoaderDescriptorBuilder().setId("mule");
            if (this.properties.containsKey("artifact.export.classPackages")) {
                classLoaderModelDescriptorBuilder.addProperty("exportedPackages", (Object)((String)this.properties.get("artifact.export.classPackages")).split(","));
            }
            if (this.properties.containsKey("artifact.privileged.classPackages")) {
                classLoaderModelDescriptorBuilder.addProperty("privilegedExportedPackages", (Object)((String)this.properties.get("artifact.privileged.classPackages")).split(","));
            }
            if (this.properties.containsKey("artifact.privileged.artifactIds")) {
                classLoaderModelDescriptorBuilder.addProperty("privilegedArtifactIds", (Object)((String)this.properties.get("artifact.privileged.artifactIds")).split(","));
            }
            if (this.properties.containsKey("artifact.export.resources")) {
                classLoaderModelDescriptorBuilder.addProperty("exportedResources", (Object)((String)this.properties.get("artifact.export.resources")).split(","));
            }
            builder.withClassLoaderModelDescriptorLoader(classLoaderModelDescriptorBuilder.build());
            builder.withBundleDescriptorLoader(new MuleArtifactLoaderDescriptor("mule", Collections.emptyMap()));
            this.mulePluginModel = builder.build();
        }
        if (this.mulePluginModel != null) {
            Path jsonDescriptorFile = this.getTempFolder().resolve(ArtifactDescriptor.MULE_ARTIFACT_FOLDER).resolve("mule-artifact.json");
            String jsonDescriber = new MulePluginModelJsonSerializer().serialize((AbstractMuleArtifactModel)this.mulePluginModel);
            try {
                Files.createDirectories(jsonDescriptorFile.getParent(), new FileAttribute[0]);
                Files.writeString(jsonDescriptorFile, (CharSequence)jsonDescriber, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("There was an issue generating the JSON file for " + this.getId(), e);
            }
            customResources.add(new ZipUtils.ZipResource(jsonDescriptorFile.toAbsolutePath().toString(), "META-INF/mule-artifact/mule-artifact.json"));
        }
        return customResources;
    }

    public String getConfigFile() {
        return null;
    }

    protected Optional<MuleArtifactLoaderDescriptor> getBundleDescriptorLoader() {
        return Optional.ofNullable(this.mulePluginModel != null ? this.mulePluginModel.getBundleDescriptorLoader() : null);
    }
}

