/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.deployment.impl.internal.domain;

import static java.util.Collections.emptySet;

import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;

/**
 * Represents the description of a domain when none is given
 */
public class EmptyDomainDescriptor extends DomainDescriptor {

  public static final EmptyDomainDescriptor DEFAULT_DOMAIN = new EmptyDomainDescriptor();

  private EmptyDomainDescriptor() {
    super(DEFAULT_DOMAIN_NAME);
    setConfigResources(emptySet());
  }
}
