/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.builder;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MulePolicyModel;
import org.mule.runtime.api.deployment.persistence.MulePolicyModelJsonSerializer;
import org.mule.runtime.module.deployment.impl.internal.builder.DeployableFileBuilder;
import org.mule.tck.ZipUtils;

public class PolicyFileBuilder
extends DeployableFileBuilder<PolicyFileBuilder> {
    private static final String MULE_POLICY_CLASSIFIER = "mule-policy";
    private MulePolicyModel mulePolicyModel;

    public PolicyFileBuilder(String artifactId) {
        super(artifactId);
    }

    public String getConfigFile() {
        return "policy.xml";
    }

    protected PolicyFileBuilder getThis() {
        return this;
    }

    public PolicyFileBuilder describedBy(MulePolicyModel mulePolicyModel) {
        this.checkImmutable();
        Objects.requireNonNull(mulePolicyModel, "JSON describer cannot be null");
        this.mulePolicyModel = mulePolicyModel;
        return this;
    }

    @Override
    protected List<ZipUtils.ZipResource> doGetCustomResources() throws IOException {
        LinkedList<ZipUtils.ZipResource> customResources = new LinkedList<ZipUtils.ZipResource>();
        if (this.mulePolicyModel != null) {
            Path jsonDescriptorFile = this.getTempFolder().resolve("META-INF").resolve("mule-artifact").resolve("mule-artifact.json");
            String jsonDescriber = new MulePolicyModelJsonSerializer().serialize((AbstractMuleArtifactModel)this.mulePolicyModel);
            try {
                Files.writeString(jsonDescriptorFile, (CharSequence)jsonDescriber, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("There was an issue generating the JSON file for " + this.getId(), e);
            }
            customResources.add(new ZipUtils.ZipResource(jsonDescriptorFile.toAbsolutePath().toString(), "META-INF/mule-artifact/mule-artifact.json"));
        }
        return customResources;
    }

    public String getClassifier() {
        return MULE_POLICY_CLASSIFIER;
    }
}

