/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.deployment.impl.internal.plugin;

import static org.mule.tck.ZipUtils.compress;

import static java.util.Optional.empty;

import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;

import org.mule.tck.ZipUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;

import java.nio.file.Path;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class ArtifactPluginDescriptorLoaderTestCase extends AbstractMuleTestCase {

  @TempDir
  public Path pluginsFolder;

  private final ArtifactPluginDescriptorFactory artifactPluginDescriptorFactory = mock(ArtifactPluginDescriptorFactory.class);

  private ArtifactPluginDescriptorLoader pluginDescriptorLoader;

  @BeforeEach
  public void createClasUnderTest() {
    pluginDescriptorLoader = new ArtifactPluginDescriptorLoader(artifactPluginDescriptorFactory);
  }

  @Test
  void load() throws Exception {
    String pluginName = "plugin";
    Path plugin = pluginsFolder.resolve(pluginName + ".jar");
    compress(plugin, new ZipUtils.ZipResource[] {});
    var pluginFile = plugin.toFile();
    pluginDescriptorLoader.load(pluginFile);
    verify(artifactPluginDescriptorFactory).create(pluginFile, empty());
  }

}
