/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.maven;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.core.api.util.PropertiesUtils;
import org.mule.runtime.core.internal.util.JarUtils;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorCreateException;
import sun.net.www.protocol.jar.Handler;
import sun.net.www.protocol.jar.JarURLConnection;

public class MavenUtils {
    private static final String SHARED_LIBRARIES_ELEMENT = "sharedLibraries";

    public static Model getPomModelFromJar(File artifactFile) {
        String pomFilePath = "META-INF/mule-artifact/pom.xml";
        try {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            return reader.read((InputStream)new ByteArrayInputStream((byte[])JarUtils.loadFileContentFrom((URL)MavenUtils.getPomUrlFromJar(artifactFile)).get()));
        }
        catch (IOException | XmlPullParserException e) {
            throw new ArtifactDescriptorCreateException(String.format("There was an issue reading '%s' for the artifact '%s'", pomFilePath, artifactFile.getAbsolutePath()), e);
        }
    }

    public static URL getPomUrlFromJar(File artifactFile) {
        return MavenUtils.lookMavenMetadataFileUrlFromJar(artifactFile, "pom.xml");
    }

    public static URL getPomPropertiesUrlFromJar(File artifactFile) {
        return MavenUtils.lookMavenMetadataFileUrlFromJar(artifactFile, "pom.properties");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static URL lookMavenMetadataFileUrlFromJar(File artifactFile, String mavenMetadataFileName) {
        String mavenMetadataFilePath = "META-INF/mule-artifact/" + mavenMetadataFileName;
        try {
            URL possibleUrl = JarUtils.getUrlWithinJar((File)artifactFile, (String)mavenMetadataFilePath);
            JarURLConnection jarConnection = new JarURLConnection(possibleUrl, new Handler());
            ((URLConnection)jarConnection).setUseCaches(false);
            try (InputStream ignored = ((URLConnection)jarConnection).getInputStream();){
                URL throwable3 = possibleUrl;
                return throwable3;
            }
            catch (Exception e) {
                List jarMavenUrls = JarUtils.getUrlsWithinJar((File)artifactFile, (String)"META-INF/maven");
                Optional<URL> mavenMetadataUrl = jarMavenUrls.stream().filter(url -> url.toString().endsWith(mavenMetadataFileName)).findAny();
                if (mavenMetadataUrl.isPresent()) return mavenMetadataUrl.get();
                throw new ArtifactDescriptorCreateException(String.format("The identifier '%s' requires the file '%s' within the artifact(error found while reading artifact '%s')", artifactFile.getName(), mavenMetadataFileName, artifactFile.getAbsolutePath()));
            }
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public static Model getPomModelFolder(File artifactFolder) {
        Model model;
        File artifactPom = MavenUtils.lookupPomFromMavenLocation(artifactFolder);
        MavenXpp3Reader reader = new MavenXpp3Reader();
        try (FileReader artifactPomFileReader = new FileReader(artifactPom);){
            model = reader.read((Reader)artifactPomFileReader);
        }
        catch (IOException | XmlPullParserException e) {
            throw new ArtifactDescriptorCreateException(String.format("There was an issue reading '%s' for the artifact '%s'", artifactPom.getName(), artifactFolder.getAbsolutePath()), e);
        }
        return model;
    }

    public static Properties getPomPropertiesFolder(File artifactFolder) {
        Properties properties;
        File artifactPomProperties = MavenUtils.lookupPomPropertiesMavenLocation(artifactFolder);
        try (FileInputStream artifactPomPropertiesInputStream = new FileInputStream(artifactPomProperties);){
            properties = PropertiesUtils.loadProperties((InputStream)artifactPomPropertiesInputStream);
        }
        catch (IOException e) {
            throw new ArtifactDescriptorCreateException(String.format("There was an issue reading '%s' for the artifact '%s'", artifactPomProperties.getName(), artifactFolder.getAbsolutePath()), (Throwable)e);
        }
        return properties;
    }

    public static Properties getPomPropertiesFromJar(File artifactFile) {
        String pomPropertiesFilePath = "META-INF/mule-artifact/pom.properties";
        try {
            return PropertiesUtils.loadProperties((InputStream)new ByteArrayInputStream((byte[])JarUtils.loadFileContentFrom((URL)MavenUtils.getPomPropertiesUrlFromJar(artifactFile)).get()));
        }
        catch (IOException e) {
            throw new ArtifactDescriptorCreateException(String.format("There was an issue reading '%s' for the artifact '%s'", pomPropertiesFilePath, artifactFile.getAbsolutePath()), (Throwable)e);
        }
    }

    public static Model getPomModel(File artifact) {
        if (artifact.isDirectory()) {
            return MavenUtils.getPomModelFolder(artifact);
        }
        return MavenUtils.getPomModelFromJar(artifact);
    }

    public static void updateArtifactPom(File artifactFolder, Model model) {
        File mulePluginPom = MavenUtils.lookupPomFromMavenLocation(artifactFolder);
        MavenXpp3Writer writer = new MavenXpp3Writer();
        try (FileOutputStream outputStream = new FileOutputStream(mulePluginPom);){
            writer.write((OutputStream)outputStream, model);
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public static void createDeployablePomFile(File artifactFolder, Model model) {
        File pomFileLocation = new File(artifactFolder, Paths.get("META-INF", "maven", model.getGroupId(), model.getArtifactId(), "pom.xml").toString());
        try {
            FileUtils.createFile((String)pomFileLocation.getAbsolutePath());
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        try (FileWriter fileWriter = new FileWriter(pomFileLocation);){
            new MavenXpp3Writer().write((Writer)fileWriter, model);
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public static File lookupPomFromMavenLocation(File artifactFolder) {
        File artifactPomFile = null;
        File lookupFolder = new File(artifactFolder, "META-INF" + File.separator + "maven");
        while (lookupFolder != null && lookupFolder.exists()) {
            File possiblePomLocation = new File(lookupFolder, "pom.xml");
            if (possiblePomLocation.exists()) {
                artifactPomFile = possiblePomLocation;
                break;
            }
            File[] directories = lookupFolder.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY);
            Preconditions.checkState((directories != null || directories.length == 0 ? 1 : 0) != 0, (String)String.format("No directories under %s so pom.xml file for artifact in folder %s could not be found", lookupFolder.getAbsolutePath(), artifactFolder.getAbsolutePath()));
            Preconditions.checkState((directories.length == 1 ? 1 : 0) != 0, (String)String.format("More than one directory under %s so pom.xml file for artifact in folder %s could not be found", lookupFolder.getAbsolutePath(), artifactFolder.getAbsolutePath()));
            lookupFolder = directories[0];
        }
        if (artifactPomFile == null || !artifactPomFile.exists()) {
            throw new ArtifactDescriptorCreateException(String.format("The maven bundle loader requires the file pom.xml (error found while reading artifact '%s')", artifactFolder.getName()));
        }
        return artifactPomFile;
    }

    public static File lookupPomPropertiesMavenLocation(File artifactFolder) {
        File mulePropertiesPom = null;
        File lookupFolder = new File(artifactFolder, "META-INF" + File.separator + "maven");
        while (lookupFolder != null && lookupFolder.exists()) {
            File possiblePomPropertiesLocation = new File(lookupFolder, "pom.properties");
            if (possiblePomPropertiesLocation.exists()) {
                mulePropertiesPom = possiblePomPropertiesLocation;
                break;
            }
            File[] directories = lookupFolder.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY);
            Preconditions.checkState((directories != null || directories.length == 0 ? 1 : 0) != 0, (String)String.format("No directories under %s so pom.properties file for artifact in folder %s could not be found", lookupFolder.getAbsolutePath(), artifactFolder.getAbsolutePath()));
            Preconditions.checkState((directories.length == 1 ? 1 : 0) != 0, (String)String.format("More than one directory under %s so pom.properties file for artifact in folder %s could not be found", lookupFolder.getAbsolutePath(), artifactFolder.getAbsolutePath()));
            lookupFolder = directories[0];
        }
        if (mulePropertiesPom == null || !mulePropertiesPom.exists()) {
            throw new ArtifactDescriptorCreateException(String.format("The maven bundle loader requires the file pom.properties (error found while reading artifact '%s')", artifactFolder.getName()));
        }
        return mulePropertiesPom;
    }

    public static void addSharedLibraryDependency(Model model, Dependency dependency) {
        Xpp3Dom sharedLibrariesDom;
        ArrayList finalPlugins;
        Optional<Plugin> pluginOptional;
        Plugin plugin2;
        Xpp3Dom configuration;
        ArrayList plugins;
        Build build = model.getBuild();
        if (build == null) {
            build = new Build();
            model.setBuild(build);
        }
        if ((plugins = build.getPlugins()) == null) {
            plugins = new ArrayList();
            build.setPlugins(plugins);
        }
        if ((configuration = (Xpp3Dom)(plugin2 = (pluginOptional = plugins.stream().filter(plugin -> plugin.getGroupId().equals("org.mule.tools.maven") && plugin.getArtifactId().equals("mule-maven-plugin")).findFirst()).orElseGet(() -> MavenUtils.lambda$addSharedLibraryDependency$2(finalPlugins = plugins))).getConfiguration()) == null) {
            configuration = new Xpp3Dom("configuration");
            plugin2.setConfiguration((Object)configuration);
        }
        if ((sharedLibrariesDom = configuration.getChild(SHARED_LIBRARIES_ELEMENT)) == null) {
            sharedLibrariesDom = new Xpp3Dom(SHARED_LIBRARIES_ELEMENT);
            configuration.addChild(sharedLibrariesDom);
        }
        Xpp3Dom sharedLibraryDom = new Xpp3Dom("sharedLibrary");
        sharedLibrariesDom.addChild(sharedLibraryDom);
        Xpp3Dom groupIdDom = new Xpp3Dom("groupId");
        groupIdDom.setValue(dependency.getGroupId());
        sharedLibraryDom.addChild(groupIdDom);
        Xpp3Dom artifactIdDom = new Xpp3Dom("artifactId");
        artifactIdDom.setValue(dependency.getArtifactId());
        sharedLibraryDom.addChild(artifactIdDom);
    }

    private static /* synthetic */ Plugin lambda$addSharedLibraryDependency$2(List finalPlugins) {
        Plugin muleMavenPlugin = new Plugin();
        muleMavenPlugin.setGroupId("org.mule.tools.maven");
        muleMavenPlugin.setArtifactId("mule-maven-plugin");
        finalPlugins.add(muleMavenPlugin);
        return muleMavenPlugin;
    }
}

