/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.plugin;

import com.vdurmont.semver4j.Semver;
import java.util.Collections;
import java.util.List;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginLocalDependenciesBlacklist {
    private static final Logger logger = LoggerFactory.getLogger(PluginLocalDependenciesBlacklist.class);
    private static List<BundleDescriptor> pluginsBlacklist = Collections.singletonList(new BundleDescriptor.Builder().setGroupId("com.mulesoft.connectors").setArtifactId("mule-ibm-ctg-connector").setVersion("2.3.1").build());

    public static boolean isBlacklisted(BundleDescriptor pluginDescriptor) {
        for (BundleDescriptor blacklistedPluginDescriptor : pluginsBlacklist) {
            if (!PluginLocalDependenciesBlacklist.doDescriptorsMatch(blacklistedPluginDescriptor, pluginDescriptor)) continue;
            logger.warn("Plugin '{}' local dependencies won't have precedence over the dependencies of the artifact being deployed. Please update to the latest plugin version", (Object)pluginDescriptor);
            return true;
        }
        return false;
    }

    private static boolean doDescriptorsMatch(BundleDescriptor blacklistedDescriptor, BundleDescriptor pluginBundleDescriptor) {
        if (!PluginLocalDependenciesBlacklist.doGroupsMatch(blacklistedDescriptor, pluginBundleDescriptor)) {
            return false;
        }
        if (!PluginLocalDependenciesBlacklist.doArtifactIdsMatch(blacklistedDescriptor, pluginBundleDescriptor)) {
            return false;
        }
        return PluginLocalDependenciesBlacklist.isBlacklistedVersionGreaterOrEqual(blacklistedDescriptor.getVersion(), pluginBundleDescriptor.getVersion());
    }

    private static boolean isBlacklistedVersionGreaterOrEqual(String blacklistedVersion, String pluginVersion) {
        Semver blacklistedSemver = new Semver(blacklistedVersion);
        Semver pluginSemver = new Semver(pluginVersion);
        return !blacklistedSemver.isLowerThan(pluginSemver);
    }

    private static boolean doGroupsMatch(BundleDescriptor first, BundleDescriptor second) {
        return first.getGroupId().equals(second.getGroupId());
    }

    private static boolean doArtifactIdsMatch(BundleDescriptor first, BundleDescriptor second) {
        return first.getArtifactId().equals(second.getArtifactId());
    }
}

