/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.application;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.internal.context.DefaultMuleContextBuilder;

abstract class SupportsPropertiesMuleContextBuilder
extends DefaultMuleContextBuilder {
    private static final String SYS_PROPERTY_PREFIX = "sys.";
    private static final String MULE_PROPERTY_PREFIX = "mule.config.";
    private final Map<String, String> artifactProperties;

    protected SupportsPropertiesMuleContextBuilder(ArtifactType artifactType, Map<String, String> artifactProperties) {
        super(artifactType);
        this.artifactProperties = artifactProperties;
    }

    protected void initializeFromProperties(MuleConfiguration configuration) {
        for (Map.Entry<String, String> entry : this.artifactProperties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.startsWith(SYS_PROPERTY_PREFIX)) {
                String systemProperty = key.substring(SYS_PROPERTY_PREFIX.length());
                System.setProperty(systemProperty, value);
                continue;
            }
            if (!key.startsWith(MULE_PROPERTY_PREFIX)) continue;
            String configProperty = key.substring(MULE_PROPERTY_PREFIX.length());
            try {
                BeanUtils.setProperty((Object)configuration, (String)configProperty, (Object)value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                logger.error("Cannot set configuration property", (Throwable)e);
            }
        }
    }
}

