/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.policy;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPlugin;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionDiscoveryRequest;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionModelDiscoverer;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionModelLoaderRepository;
import org.mule.runtime.module.artifact.activation.api.plugin.PluginClassLoaderSupplier;
import org.mule.runtime.module.artifact.api.Artifact;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.extension.api.manager.ExtensionManagerFactory;

public class ArtifactExtensionManagerFactory
implements ExtensionManagerFactory {
    private static final BiFunction<PluginClassLoaderSupplier, ExtensionModelLoaderRepository, ExtensionModelDiscoverer> EXT_MODEL_DISCOVERER = ExtensionModelDiscoverer::defaultExtensionModelDiscoverer;
    private final Set<ArtifactPluginDescriptor> artifactPluginsDescriptors;
    private final ExtensionManagerFactory extensionManagerFactory;
    private final ExtensionModelDiscoverer extensionModelDiscoverer;

    public ArtifactExtensionManagerFactory(List<ArtifactPlugin> artifactPlugins, ExtensionModelLoaderRepository extensionModelLoaderRepository, ExtensionManagerFactory extensionManagerFactory) {
        this(artifactPlugins, extensionModelLoaderRepository, extensionManagerFactory, Optional.empty());
    }

    public ArtifactExtensionManagerFactory(List<ArtifactPlugin> artifactPlugins, ExtensionModelLoaderRepository extensionModelLoaderRepository, ExtensionManagerFactory extensionManagerFactory, Optional<BiFunction<PluginClassLoaderSupplier, ExtensionModelLoaderRepository, ExtensionModelDiscoverer>> extModelDiscovererOverride) {
        this.extensionManagerFactory = extensionManagerFactory;
        Map artifactPluginsClassLoaders = artifactPlugins.stream().collect(Collectors.toMap(Artifact::getDescriptor, Artifact::getArtifactClassLoader, (x, y) -> y, LinkedHashMap::new));
        this.artifactPluginsDescriptors = artifactPluginsClassLoaders.keySet();
        this.extensionModelDiscoverer = extModelDiscovererOverride.orElse(EXT_MODEL_DISCOVERER).apply(artifactPluginsClassLoaders::get, extensionModelLoaderRepository);
    }

    public ExtensionManager create(MuleContext muleContext) {
        return this.create(muleContext, Collections.emptySet());
    }

    protected ExtensionManager create(MuleContext muleContext, Set<ExtensionModel> parentArtifactExtensions) {
        ExtensionManager extensionManager = this.extensionManagerFactory.create(muleContext);
        HashSet extensions = new HashSet();
        ExtensionModelDiscoverer.discoverRuntimeExtensionModels().forEach(arg_0 -> ((ExtensionManager)extensionManager).registerExtension(arg_0));
        extensions.addAll(this.extensionModelDiscoverer.discoverPluginsExtensionModels(ExtensionDiscoveryRequest.builder().setArtifactPlugins(this.artifactPluginsDescriptors).setParentArtifactExtensions(parentArtifactExtensions).build()));
        extensions.forEach(arg_0 -> ((ExtensionManager)extensionManager).registerExtension(arg_0));
        return extensionManager;
    }
}

