/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.domain;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.memory.management.MemoryManagementService;
import org.mule.runtime.api.service.ServiceRepository;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.deployment.model.api.artifact.ArtifactConfigurationProcessor;
import org.mule.runtime.deployment.model.api.builder.DomainClassLoaderBuilder;
import org.mule.runtime.deployment.model.api.builder.DomainClassLoaderBuilderFactory;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPlugin;
import org.mule.runtime.deployment.model.internal.DefaultRegionPluginClassLoadersFactory;
import org.mule.runtime.deployment.model.internal.artifact.extension.ExtensionModelLoaderManager;
import org.mule.runtime.internal.memory.management.ArtifactMemoryManagementService;
import org.mule.runtime.module.artifact.activation.api.descriptor.DeployableArtifactDescriptorCreator;
import org.mule.runtime.module.artifact.activation.api.descriptor.DeployableArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.runtime.module.deployment.impl.internal.artifact.AbstractDeployableArtifactFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DefaultMuleDomain;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainManager;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainWrapper;
import org.mule.runtime.module.deployment.impl.internal.domain.EmptyDomainDescriptor;
import org.mule.runtime.module.deployment.impl.internal.plugin.DefaultArtifactPlugin;
import org.mule.runtime.module.license.api.LicenseValidator;
import org.mule.runtime.module.reboot.api.MuleContainerBootstrapUtils;

public class DefaultDomainFactory
extends AbstractDeployableArtifactFactory<org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor, Domain> {
    private final DomainManager domainManager;
    private final DeployableArtifactDescriptorFactory deployableArtifactDescriptorFactory;
    private final ClassLoaderRepository classLoaderRepository;
    private final ServiceRepository serviceRepository;
    private final DomainClassLoaderBuilderFactory domainClassLoaderBuilderFactory;
    private final ExtensionModelLoaderManager extensionModelLoaderManager;

    public DefaultDomainFactory(DomainDescriptorFactory domainDescriptorFactory, DeployableArtifactDescriptorFactory deployableArtifactDescriptorFactory, DomainManager domainManager, ClassLoaderRepository classLoaderRepository, ServiceRepository serviceRepository, DomainClassLoaderBuilderFactory domainClassLoaderBuilderFactory, ExtensionModelLoaderManager extensionModelLoaderManager, LicenseValidator licenseValidator, LockFactory runtimeLockFactory, MemoryManagementService memoryManagementService, ArtifactConfigurationProcessor artifactConfigurationProcessor) {
        super(licenseValidator, runtimeLockFactory, memoryManagementService, artifactConfigurationProcessor);
        Preconditions.checkArgument((domainDescriptorFactory != null ? 1 : 0) != 0, (String)"domainDescriptorFactory cannot be null");
        Preconditions.checkArgument((deployableArtifactDescriptorFactory != null ? 1 : 0) != 0, (String)"Deployable artifact descriptor factory cannot be null");
        Preconditions.checkArgument((domainManager != null ? 1 : 0) != 0, (String)"Domain manager cannot be null");
        Preconditions.checkArgument((serviceRepository != null ? 1 : 0) != 0, (String)"Service repository cannot be null");
        Preconditions.checkArgument((domainClassLoaderBuilderFactory != null ? 1 : 0) != 0, (String)"domainClassLoaderBuilderFactory cannot be null");
        Preconditions.checkArgument((extensionModelLoaderManager != null ? 1 : 0) != 0, (String)"extensionModelLoaderManager cannot be null");
        Preconditions.checkArgument((artifactConfigurationProcessor != null ? 1 : 0) != 0, (String)"artifactConfigurationProcessor cannot be null");
        this.classLoaderRepository = classLoaderRepository;
        this.deployableArtifactDescriptorFactory = deployableArtifactDescriptorFactory;
        this.domainManager = domainManager;
        this.serviceRepository = serviceRepository;
        this.domainClassLoaderBuilderFactory = domainClassLoaderBuilderFactory;
        this.extensionModelLoaderManager = extensionModelLoaderManager;
    }

    private org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor findDomain(String domainName, File domainLocation, Optional<Properties> deploymentProperties) {
        if ("default".equals(domainName)) {
            return new EmptyDomainDescriptor(new File(MuleContainerBootstrapUtils.getMuleDomainsDir(), "default"));
        }
        return this.deployableArtifactDescriptorFactory.createDomainDescriptor(this.createDeployableProjectModel(domainLocation, true), deploymentProperties.map(dp -> Maps.fromProperties((Properties)dp)).orElse(Collections.emptyMap()), this.getDescriptorCreator());
    }

    private DeployableArtifactDescriptorCreator<org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor> getDescriptorCreator() {
        return new DeployableArtifactDescriptorCreator<org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor>(){

            public DomainDescriptor create(String name) {
                return new DomainDescriptor(name);
            }

            public DomainDescriptor create(String name, Optional deploymentProperties) {
                return new DomainDescriptor(name, deploymentProperties);
            }
        };
    }

    private List<ArtifactPlugin> createArtifactPluginList(MuleDeployableArtifactClassLoader domainClassLoader, List<ArtifactPluginDescriptor> plugins) {
        return plugins.stream().map(artifactPluginDescriptor -> new DefaultArtifactPlugin(DefaultRegionPluginClassLoadersFactory.getArtifactPluginId((String)domainClassLoader.getArtifactId(), (String)artifactPluginDescriptor.getName()), (ArtifactPluginDescriptor)artifactPluginDescriptor, domainClassLoader.getArtifactPluginClassLoaders().stream().filter(artifactClassLoader -> {
            String artifactPluginDescriptorName = "/plugin/" + artifactPluginDescriptor.getName();
            return artifactClassLoader.getArtifactId().endsWith(artifactPluginDescriptorName);
        }).findFirst().get())).collect(Collectors.toList());
    }

    @Override
    public File getArtifactDir() {
        return MuleContainerBootstrapUtils.getMuleDomainsDir();
    }

    public void dispose(DomainWrapper domain) {
        this.domainManager.removeDomain(domain);
    }

    public void start(DomainWrapper domainWrapper) {
        this.domainManager.addDomain(domainWrapper);
    }

    @Override
    protected Domain doCreateArtifact(File domainLocation, Optional<Properties> deploymentProperties) throws IOException {
        String domainName = domainLocation.getName();
        if (this.domainManager.contains(domainName)) {
            throw new IllegalArgumentException(String.format("Domain '%s'  already exists", domainName));
        }
        if (domainName.contains(" ")) {
            throw new IllegalArgumentException("Mule domain name may not contain spaces: " + domainName);
        }
        org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor domainDescriptor = this.findDomain(domainName, domainLocation, deploymentProperties);
        ArrayList<ArtifactPluginDescriptor> resolvedArtifactPluginDescriptors = new ArrayList<ArtifactPluginDescriptor>(domainDescriptor.getPlugins());
        DomainClassLoaderBuilder artifactClassLoaderBuilder = this.domainClassLoaderBuilderFactory.createArtifactClassLoaderBuilder();
        MuleDeployableArtifactClassLoader domainClassLoader = artifactClassLoaderBuilder.setArtifactDescriptor((ArtifactDescriptor)domainDescriptor).build();
        List<ArtifactPlugin> artifactPlugins = this.createArtifactPluginList(domainClassLoader, resolvedArtifactPluginDescriptors);
        DefaultMuleDomain defaultMuleDomain = new DefaultMuleDomain(domainDescriptor, (ArtifactClassLoader)domainClassLoader, this.classLoaderRepository, this.serviceRepository, artifactPlugins, this.extensionModelLoaderManager, this.getRuntimeLockFactory(), (MemoryManagementService)new ArtifactMemoryManagementService(this.getMemoryManagementService()), this.getArtifactConfigurationProcessor());
        DomainWrapper domainWrapper = new DomainWrapper(defaultMuleDomain, this);
        this.domainManager.addDomain(domainWrapper);
        return domainWrapper;
    }

    @Override
    public DeployableArtifactDescriptor createArtifactDescriptor(File artifactLocation, Optional<Properties> deploymentProperties) {
        return this.deployableArtifactDescriptorFactory.createDomainDescriptor(this.createDeployableProjectModel(artifactLocation, true), deploymentProperties.map(dp -> Maps.fromProperties((Properties)dp)).orElse(Collections.emptyMap()));
    }
}

