/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal;

import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.memory.management.MemoryManagementService;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.profiling.ProfilingService;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.service.ServiceRepository;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.artifact.activation.internal.TrackingArtifactClassLoaderResolverDecorator;
import org.mule.runtime.container.api.ContainerClassLoaderProvider;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.config.FeatureContext;
import org.mule.runtime.core.api.config.FeatureFlaggingRegistry;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.core.internal.config.FeatureFlaggingServiceBuilder;
import org.mule.runtime.core.internal.lock.ServerLockFactory;
import org.mule.runtime.core.internal.profiling.AbstractProfilingService;
import org.mule.runtime.core.internal.profiling.DefaultProfilingService;
import org.mule.runtime.core.internal.registry.SimpleRegistry;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.runtime.deployment.model.api.artifact.ArtifactConfigurationProcessor;
import org.mule.runtime.deployment.model.api.artifact.ArtifactDescriptorFactoryProvider;
import org.mule.runtime.deployment.model.api.artifact.DescriptorLoaderRepositoryFactory;
import org.mule.runtime.deployment.model.api.builder.ApplicationClassLoaderBuilderFactory;
import org.mule.runtime.deployment.model.api.builder.DeployableArtifactClassLoaderFactoryProvider;
import org.mule.runtime.deployment.model.api.builder.DomainClassLoaderBuilderFactory;
import org.mule.runtime.deployment.model.api.builder.RegionPluginClassLoadersFactory;
import org.mule.runtime.deployment.model.api.plugin.resolver.PluginDependenciesResolver;
import org.mule.runtime.deployment.model.internal.DefaultRegionPluginClassLoadersFactory;
import org.mule.runtime.deployment.model.internal.artifact.ServiceRegistryDescriptorLoaderRepository;
import org.mule.runtime.deployment.model.internal.policy.PolicyTemplateClassLoaderFactory;
import org.mule.runtime.internal.memory.management.ArtifactMemoryManagementService;
import org.mule.runtime.internal.memory.management.DefaultMemoryManagementService;
import org.mule.runtime.internal.memory.management.ProfiledMemoryManagementService;
import org.mule.runtime.module.artifact.activation.api.classloader.ArtifactClassLoaderResolver;
import org.mule.runtime.module.artifact.activation.api.descriptor.DeployableArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionModelLoaderRepository;
import org.mule.runtime.module.artifact.activation.internal.classloader.ArtifactClassLoaderResolverConstants;
import org.mule.runtime.module.artifact.activation.internal.classloader.DefaultArtifactClassLoaderResolver;
import org.mule.runtime.module.artifact.activation.internal.nativelib.DefaultNativeLibraryFinderFactory;
import org.mule.runtime.module.artifact.activation.internal.nativelib.NativeLibraryFinderFactory;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderManager;
import org.mule.runtime.module.artifact.api.classloader.DeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.classloader.TrackingArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.classloader.TrackingDeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.descriptor.AbstractArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidatorBuilder;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DescriptorLoaderRepository;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;
import org.mule.runtime.module.deployment.impl.internal.application.ApplicationDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.application.DefaultApplicationFactory;
import org.mule.runtime.module.deployment.impl.internal.artifact.AbstractDeployableDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.artifact.DefaultArtifactDescriptorFactoryProvider;
import org.mule.runtime.module.deployment.impl.internal.artifact.DefaultClassLoaderManager;
import org.mule.runtime.module.deployment.impl.internal.domain.DefaultDomainFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DefaultDomainManager;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainRepository;
import org.mule.runtime.module.deployment.impl.internal.plugin.ArtifactPluginDescriptorLoader;
import org.mule.runtime.module.deployment.impl.internal.policy.ApplicationPolicyTemplateClassLoaderBuilderFactory;
import org.mule.runtime.module.license.api.LicenseValidator;
import org.mule.runtime.module.license.api.LicenseValidatorProvider;
import org.mule.runtime.module.service.api.artifact.ServiceClassLoaderFactory;
import org.mule.runtime.module.service.api.discoverer.ServiceDiscoverer;
import org.mule.runtime.module.service.api.discoverer.ServiceProviderDiscoverer;
import org.mule.runtime.module.service.api.manager.ServiceManager;
import org.mule.runtime.module.service.api.manager.ServiceRegistry;
import org.mule.runtime.module.service.internal.discoverer.DefaultServiceDiscoverer;
import org.mule.runtime.module.service.internal.discoverer.FileSystemServiceProviderDiscoverer;
import org.mule.runtime.module.service.internal.discoverer.ReflectionServiceResolver;
import org.mule.runtime.module.service.internal.discoverer.ServiceResolver;
import org.mule.runtime.module.service.internal.manager.DefaultServiceRegistry;

public class MuleArtifactResourcesRegistry
extends SimpleRegistry {
    private static final String CONTAINER_FEATURE_CONTEXT_NAME = "Container";
    private final ArtifactPluginDescriptorLoader artifactPluginDescriptorLoader;
    private final DefaultDomainManager domainManager;
    private final DefaultDomainFactory domainFactory;
    private final DefaultApplicationFactory applicationFactory;
    private final DeployableArtifactClassLoaderFactory<DomainDescriptor> domainClassLoaderFactory;
    private final ArtifactClassLoader containerClassLoader;
    private final ServiceManager serviceManager;
    private final ExtensionModelLoaderRepository extensionModelLoaderRepository;
    private final DefaultClassLoaderManager artifactClassLoaderManager;
    private final ApplicationClassLoaderBuilderFactory applicationClassLoaderBuilderFactory;
    private final DomainClassLoaderBuilderFactory domainClassLoaderBuilderFactory;
    private final DomainDescriptorFactory domainDescriptorFactory;
    private final PluginDependenciesResolver pluginDependenciesResolver;
    private final ServiceRegistryDescriptorLoaderRepository descriptorLoaderRepository;
    private final RegionPluginClassLoadersFactory pluginClassLoadersFactory;
    private final ArtifactConfigurationProcessor artifactConfigurationProcessor;
    private final AbstractDeployableDescriptorFactory<MuleApplicationModel, ApplicationDescriptor> toolingApplicationDescriptorFactory;
    private final ServerLockFactory runtimeLockFactory;
    private ProfiledMemoryManagementService memoryManagementService = DefaultMemoryManagementService.getInstance();
    private final ProfilingService containerProfilingService;
    private final ServerNotificationManager serverNotificationManager = ServerNotificationManager.createDefaultNotificationManager((LazyValue)new LazyValue(this::getSchedulerService), (LazyValue)new LazyValue(() -> "containerServerNotificationManager"));

    private MuleArtifactResourcesRegistry(ArtifactClassLoader containerClassLoader, ModuleRepository moduleRepository, ArtifactConfigurationProcessor artifactConfigurationProcessor, ProfiledMemoryManagementService memoryManagementService) throws RegistrationException {
        super(null, null);
        this.registerObject("_serverNotificationManager", this.serverNotificationManager);
        if (memoryManagementService != null) {
            this.memoryManagementService = memoryManagementService;
        }
        this.containerProfilingService = new DefaultProfilingService();
        this.memoryManagementService.setProfilingService(this.containerProfilingService);
        ArtifactMemoryManagementService artifactMemoryManagementService = new ArtifactMemoryManagementService((MemoryManagementService)this.memoryManagementService);
        this.registerObject("_muleMemoryManagementService", artifactMemoryManagementService);
        this.registerObject("_muleContainerFeatureManagementService", this.getContainerFeatureFlaggingService());
        this.runtimeLockFactory = new ServerLockFactory();
        this.containerClassLoader = containerClassLoader;
        this.artifactClassLoaderManager = new DefaultClassLoaderManager();
        LicenseValidator licenseValidator = LicenseValidatorProvider.discoverLicenseValidator((ClassLoader)Thread.currentThread().getContextClassLoader());
        this.domainManager = new DefaultDomainManager();
        this.domainClassLoaderFactory = this.trackDeployableArtifactClassLoaderFactory(DeployableArtifactClassLoaderFactoryProvider.domainClassLoaderFactory(name -> MuleFoldersUtil.getAppDataFolder((String)name)));
        AbstractArtifactDescriptorFactory artifactPluginDescriptorFactory = ArtifactDescriptorFactoryProvider.artifactDescriptorFactoryProvider().createArtifactPluginDescriptorFactory(new DescriptorLoaderRepositoryFactory().createDescriptorLoaderRepository(), ArtifactDescriptorValidatorBuilder.builder());
        this.artifactPluginDescriptorLoader = new ArtifactPluginDescriptorLoader((ArtifactDescriptorFactory<ArtifactPluginDescriptor>)artifactPluginDescriptorFactory);
        this.descriptorLoaderRepository = new ServiceRegistryDescriptorLoaderRepository((org.mule.runtime.core.api.registry.ServiceRegistry)new SpiServiceRegistry());
        ArtifactDescriptorValidatorBuilder artifactDescriptorValidatorBuilder = ArtifactDescriptorValidatorBuilder.builder();
        this.domainDescriptorFactory = new DomainDescriptorFactory(this.artifactPluginDescriptorLoader, (DescriptorLoaderRepository)this.descriptorLoaderRepository, artifactDescriptorValidatorBuilder);
        ApplicationDescriptorFactory applicationDescriptorFactory = new ApplicationDescriptorFactory(this.artifactPluginDescriptorLoader, (DescriptorLoaderRepository)this.descriptorLoaderRepository, artifactDescriptorValidatorBuilder);
        DeployableArtifactDescriptorFactory deployableArtifactDescriptorFactory = DeployableArtifactDescriptorFactory.defaultArtifactDescriptorFactory();
        TrackingArtifactClassLoaderResolverDecorator artifactClassLoaderResolver = new TrackingArtifactClassLoaderResolverDecorator((ArtifactClassLoaderManager)this.artifactClassLoaderManager, (ArtifactClassLoaderResolver)new DefaultArtifactClassLoaderResolver(containerClassLoader, moduleRepository, (NativeLibraryFinderFactory)new DefaultNativeLibraryFinderFactory(name -> MuleFoldersUtil.getAppDataFolder((String)name))));
        this.pluginClassLoadersFactory = new DefaultRegionPluginClassLoadersFactory((ArtifactClassLoaderResolver)artifactClassLoaderResolver);
        this.applicationClassLoaderBuilderFactory = new ApplicationClassLoaderBuilderFactory((ArtifactClassLoaderResolver)artifactClassLoaderResolver);
        this.domainClassLoaderBuilderFactory = new DomainClassLoaderBuilderFactory((ArtifactClassLoaderResolver)artifactClassLoaderResolver);
        this.artifactConfigurationProcessor = artifactConfigurationProcessor;
        ServiceClassLoaderFactory serviceClassLoaderFactory = new ServiceClassLoaderFactory();
        this.serviceManager = ServiceManager.create((ServiceDiscoverer)new DefaultServiceDiscoverer((ServiceProviderDiscoverer)new FileSystemServiceProviderDiscoverer(containerClassLoader, this.trackArtifactClassLoaderFactory((ArtifactClassLoaderFactory)serviceClassLoaderFactory), (DescriptorLoaderRepository)this.descriptorLoaderRepository, artifactDescriptorValidatorBuilder), (ServiceResolver)new ReflectionServiceResolver((ServiceRegistry)new DefaultServiceRegistry(), (Injector)this)));
        this.extensionModelLoaderRepository = ExtensionModelLoaderRepository.getExtensionModelLoaderManager((ClassLoader)containerClassLoader.getClassLoader());
        this.pluginDependenciesResolver = new DefaultArtifactDescriptorFactoryProvider().createBundlePluginDependenciesResolver((ArtifactDescriptorFactory<ArtifactPluginDescriptor>)artifactPluginDescriptorFactory);
        this.domainFactory = new DefaultDomainFactory(this.domainDescriptorFactory, deployableArtifactDescriptorFactory, this.domainManager, this.artifactClassLoaderManager, (ServiceRepository)this.serviceManager, this.domainClassLoaderBuilderFactory, this.extensionModelLoaderRepository, licenseValidator, (LockFactory)this.runtimeLockFactory, (MemoryManagementService)this.memoryManagementService, artifactConfigurationProcessor);
        DeployableArtifactClassLoaderFactory policyClassLoaderFactory = this.trackDeployableArtifactClassLoaderFactory((DeployableArtifactClassLoaderFactory)new PolicyTemplateClassLoaderFactory());
        ApplicationPolicyTemplateClassLoaderBuilderFactory policyTemplateClassLoaderBuilderFactory = new ApplicationPolicyTemplateClassLoaderBuilderFactory(policyClassLoaderFactory, this.pluginClassLoadersFactory);
        this.applicationFactory = new DefaultApplicationFactory(this.applicationClassLoaderBuilderFactory, deployableArtifactDescriptorFactory, this.domainManager, (ServiceRepository)this.serviceManager, this.extensionModelLoaderRepository, this.artifactClassLoaderManager, policyTemplateClassLoaderBuilderFactory, this.pluginDependenciesResolver, licenseValidator, (LockFactory)this.runtimeLockFactory, (MemoryManagementService)this.memoryManagementService, artifactConfigurationProcessor);
        this.toolingApplicationDescriptorFactory = new ApplicationDescriptorFactory(this.artifactPluginDescriptorLoader, (DescriptorLoaderRepository)this.descriptorLoaderRepository, artifactDescriptorValidatorBuilder);
    }

    private FeatureFlaggingService getContainerFeatureFlaggingService() {
        FeatureFlaggingRegistry ffRegistry = FeatureFlaggingRegistry.getInstance();
        AbstractProfilingService.configureEnableProfilingService();
        return new FeatureFlaggingServiceBuilder().withContext(new FeatureContext(new MuleVersion("4.5.0-SNAPSHOT"), CONTAINER_FEATURE_CONTEXT_NAME)).withMuleContextFlags(ffRegistry.getFeatureConfigurations()).withFeatureContextFlags(ffRegistry.getFeatureFlagConfigurations()).build();
    }

    private <T extends ArtifactDescriptor> ArtifactClassLoaderFactory<T> trackArtifactClassLoaderFactory(ArtifactClassLoaderFactory<T> artifactClassLoaderFactory) {
        return new TrackingArtifactClassLoaderFactory((ArtifactClassLoaderManager)this.artifactClassLoaderManager, artifactClassLoaderFactory);
    }

    private <T extends ArtifactDescriptor> DeployableArtifactClassLoaderFactory<T> trackDeployableArtifactClassLoaderFactory(DeployableArtifactClassLoaderFactory<T> deployableArtifactClassLoaderFactory) {
        return new TrackingDeployableArtifactClassLoaderFactory((ArtifactClassLoaderManager)this.artifactClassLoaderManager, deployableArtifactClassLoaderFactory);
    }

    public ArtifactPluginDescriptorLoader getArtifactPluginDescriptorLoader() {
        return this.artifactPluginDescriptorLoader;
    }

    public DefaultDomainFactory getDomainFactory() {
        return this.domainFactory;
    }

    public DomainRepository getDomainRepository() {
        return this.domainManager;
    }

    public DomainDescriptorFactory getDomainDescriptorFactory() {
        return this.domainDescriptorFactory;
    }

    public DefaultApplicationFactory getApplicationFactory() {
        return this.applicationFactory;
    }

    public DeployableArtifactClassLoaderFactory<DomainDescriptor> getDomainClassLoaderFactory() {
        return this.domainClassLoaderFactory;
    }

    public ArtifactClassLoader getContainerClassLoader() {
        return this.containerClassLoader;
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public ExtensionModelLoaderRepository getExtensionModelLoaderRepository() {
        return this.extensionModelLoaderRepository;
    }

    public DefaultClassLoaderManager getArtifactClassLoaderManager() {
        return this.artifactClassLoaderManager;
    }

    public AbstractDeployableDescriptorFactory<MuleApplicationModel, ApplicationDescriptor> getToolingApplicationDescriptorFactory() {
        return this.toolingApplicationDescriptorFactory;
    }

    public PluginDependenciesResolver getPluginDependenciesResolver() {
        return this.pluginDependenciesResolver;
    }

    public ArtifactConfigurationProcessor getArtifactConfigurationProcessor() {
        return this.artifactConfigurationProcessor;
    }

    public ServerLockFactory getRuntimeLockFactory() {
        return this.runtimeLockFactory;
    }

    public MemoryManagementService getMemoryManagementService() {
        return this.memoryManagementService;
    }

    public ProfilingService getContainerProfilingService() {
        return this.containerProfilingService;
    }

    private SchedulerService getSchedulerService() {
        return (SchedulerService)this.serviceManager.getServices().stream().filter(s -> s instanceof SchedulerService).findFirst().get();
    }

    public static class Builder {
        private ModuleRepository moduleRepository;
        private ArtifactConfigurationProcessor artifactConfigurationProcessor;
        private ProfiledMemoryManagementService memoryManagementService;

        public Builder moduleRepository(ModuleRepository moduleRepository) {
            Preconditions.checkArgument((moduleRepository != null ? 1 : 0) != 0, (String)"moduleRepository cannot be null");
            this.moduleRepository = moduleRepository;
            return this;
        }

        public Builder artifactConfigurationProcessor(ArtifactConfigurationProcessor artifactConfigurationProcessor) {
            Preconditions.checkArgument((artifactConfigurationProcessor != null ? 1 : 0) != 0, (String)"artifactConfigurationProcessor cannot be null");
            this.artifactConfigurationProcessor = artifactConfigurationProcessor;
            return this;
        }

        public Builder withMemoryManagementService(ProfiledMemoryManagementService memoryManagementService) {
            this.memoryManagementService = memoryManagementService;
            return this;
        }

        public MuleArtifactResourcesRegistry build() {
            ArtifactClassLoader containerClassLoader;
            if (this.moduleRepository == null) {
                this.moduleRepository = ArtifactClassLoaderResolverConstants.MODULE_REPOSITORY;
                containerClassLoader = ArtifactClassLoaderResolverConstants.CONTAINER_CLASS_LOADER;
            } else {
                containerClassLoader = ContainerClassLoaderProvider.createContainerClassLoader((ModuleRepository)this.moduleRepository);
            }
            try {
                return new MuleArtifactResourcesRegistry(containerClassLoader, this.moduleRepository, this.artifactConfigurationProcessor, this.memoryManagementService);
            }
            catch (RegistrationException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
    }
}

