/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.base;

import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.internal.util.splash.SplashScreen;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemProperty;

public abstract class AbstractSplashScreenTestCase<S extends SplashScreen>
extends AbstractMuleTestCase {
    @ClassRule
    public static TemporaryFolder workingDirectory = new TemporaryFolder();
    @Rule
    public SystemProperty muleHome = new SystemProperty("mule.home", workingDirectory.getRoot().getAbsolutePath());
    protected S splashScreen;

    protected abstract void setUpSplashScreen();

    protected abstract Matcher<String> getSimpleLogMatcher();

    protected abstract Matcher<String> getComplexLogMatcher();

    @Test
    public void simpleLogWhenVerbosityOff() {
        try {
            System.setProperty("mule.runtime.verbose", "false");
            this.setUpSplashScreen();
            Assert.assertThat((Object)this.splashScreen.toString(), this.getSimpleLogMatcher());
        }
        finally {
            System.clearProperty("mule.runtime.verbose");
        }
    }

    @Test
    public void complexLogWhenVerbosityOn() {
        try {
            System.setProperty("mule.runtime.verbose", "true");
            this.setUpSplashScreen();
            Assert.assertThat((Object)this.splashScreen.toString(), this.getComplexLogMatcher());
        }
        finally {
            System.clearProperty("mule.runtime.verbose");
        }
    }

    @Test
    public void complexLogWhenNoVerbositySpecified() {
        Preconditions.checkArgument((System.getProperty("mule.runtime.verbose") == null ? 1 : 0) != 0, (String)"Runtime verbosity should not be specified.");
        this.setUpSplashScreen();
        Assert.assertThat((Object)this.splashScreen.toString(), this.getComplexLogMatcher());
    }
}

