/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.application;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.policy.Policy;
import org.mule.runtime.core.api.policy.PolicyParametrization;
import org.mule.runtime.core.api.policy.PolicyProvider;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.policy.PolicyRegistrationException;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplate;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplateDescriptor;
import org.mule.runtime.http.policy.api.SourcePolicyAwareAttributes;
import org.mule.runtime.module.deployment.impl.internal.application.ApplicationPolicyProvider;
import org.mule.runtime.module.deployment.impl.internal.policy.ApplicationPolicyInstance;
import org.mule.runtime.module.deployment.impl.internal.policy.PolicyInstanceProviderFactory;
import org.mule.runtime.module.deployment.impl.internal.policy.PolicyTemplateFactory;
import org.mule.runtime.policy.api.AttributeAwarePointcut;
import org.mule.runtime.policy.api.PolicyAwareAttributes;
import org.mule.runtime.policy.api.PolicyPointcutParameters;

public class MuleApplicationPolicyProvider
implements ApplicationPolicyProvider,
PolicyProvider,
Disposable {
    public static final String IS_POLICY_REORDER = "isPolicyReorder";
    private final PolicyTemplateFactory policyTemplateFactory;
    private final PolicyInstanceProviderFactory policyInstanceProviderFactory;
    private final List<RegisteredPolicyTemplate> registeredPolicyTemplates = new LinkedList<RegisteredPolicyTemplate>();
    private final List<RegisteredPolicyInstanceProvider> registeredPolicyInstanceProviders = new LinkedList<RegisteredPolicyInstanceProvider>();
    private PolicyAwareAttributes sourcePolicyAwareAttributes = SourcePolicyAwareAttributes.noAttributes();
    private Application application;
    private Runnable policiesChangedCallback = () -> {};

    public MuleApplicationPolicyProvider(PolicyTemplateFactory policyTemplateFactory, PolicyInstanceProviderFactory policyInstanceProviderFactory) {
        this.policyTemplateFactory = policyTemplateFactory;
        this.policyInstanceProviderFactory = policyInstanceProviderFactory;
    }

    public synchronized void addPolicy(PolicyTemplateDescriptor policyTemplateDescriptor, PolicyParametrization parametrization) throws PolicyRegistrationException {
        try {
            Preconditions.checkArgument((this.application != null ? 1 : 0) != 0, (String)"application was not configured on the policy provider");
            Optional<RegisteredPolicyInstanceProvider> registeredPolicyInstanceProvider = this.registeredPolicyInstanceProviders.stream().filter(p -> p.getPolicyId().equals(parametrization.getId())).findFirst();
            if (registeredPolicyInstanceProvider.isPresent()) {
                if (this.isPolicyReorder(parametrization)) {
                    this.reorderPolicy(registeredPolicyInstanceProvider.get(), parametrization);
                    return;
                }
                throw new IllegalArgumentException(MuleApplicationPolicyProvider.createPolicyAlreadyRegisteredError(parametrization.getId()));
            }
            Optional<RegisteredPolicyTemplate> registeredPolicyTemplate = this.registeredPolicyTemplates.stream().filter(p -> ((PolicyTemplateDescriptor)((RegisteredPolicyTemplate)p).policyTemplate.getDescriptor()).getBundleDescriptor().getGroupId().equals(policyTemplateDescriptor.getBundleDescriptor().getGroupId()) && ((PolicyTemplateDescriptor)((RegisteredPolicyTemplate)p).policyTemplate.getDescriptor()).getBundleDescriptor().getArtifactId().equals(policyTemplateDescriptor.getBundleDescriptor().getArtifactId()) && ((PolicyTemplateDescriptor)((RegisteredPolicyTemplate)p).policyTemplate.getDescriptor()).getBundleDescriptor().getVersion().equals(policyTemplateDescriptor.getBundleDescriptor().getVersion())).findAny();
            if (!registeredPolicyTemplate.isPresent()) {
                PolicyTemplate policyTemplate = this.policyTemplateFactory.createArtifact(this.application, policyTemplateDescriptor);
                registeredPolicyTemplate = Optional.of(new RegisteredPolicyTemplate(policyTemplate));
                this.registeredPolicyTemplates.add(registeredPolicyTemplate.get());
            }
            ApplicationPolicyInstance applicationPolicyInstance = this.policyInstanceProviderFactory.create(this.application, registeredPolicyTemplate.get().policyTemplate, parametrization);
            applicationPolicyInstance.initialise();
            this.registeredPolicyInstanceProviders.add(new RegisteredPolicyInstanceProvider(applicationPolicyInstance, parametrization.getId()));
            registeredPolicyTemplate.get().count++;
            this.sortPolicies();
        }
        catch (Exception e) {
            throw new PolicyRegistrationException(MuleApplicationPolicyProvider.createPolicyRegistrationError(parametrization.getId()), (Throwable)e);
        }
    }

    private boolean isPolicyReorder(PolicyParametrization parametrization) {
        return parametrization.getParameters().getOrDefault(IS_POLICY_REORDER, "false").equalsIgnoreCase("true");
    }

    private void reorderPolicy(RegisteredPolicyInstanceProvider provider, PolicyParametrization parametrization) {
        provider.updateOrder(parametrization.getOrder());
        this.sortPolicies();
    }

    private void sortPolicies() {
        this.registeredPolicyInstanceProviders.sort(null);
        this.policiesChangedCallback.run();
    }

    public synchronized boolean removePolicy(String parametrizedPolicyId) {
        Optional<RegisteredPolicyInstanceProvider> registeredPolicyInstanceProvider = this.registeredPolicyInstanceProviders.stream().filter(p -> p.getPolicyId().equals(parametrizedPolicyId)).findFirst();
        registeredPolicyInstanceProvider.ifPresent(provider -> {
            this.registeredPolicyInstanceProviders.remove(provider);
            this.policiesChangedCallback.run();
            provider.getApplicationPolicyInstance().dispose();
            Optional<RegisteredPolicyTemplate> registeredPolicyTemplate = this.registeredPolicyTemplates.stream().filter(p -> ((RegisteredPolicyTemplate)p).policyTemplate.equals(provider.getApplicationPolicyInstance().getPolicyTemplate())).findFirst();
            if (!registeredPolicyTemplate.isPresent()) {
                throw new IllegalStateException("Cannot find registered policy template");
            }
            registeredPolicyTemplate.get().count--;
            if (registeredPolicyTemplate.get().count == 0) {
                this.application.getRegionClassLoader().removeClassLoader(registeredPolicyTemplate.get().policyTemplate.getArtifactClassLoader());
                registeredPolicyTemplate.get().policyTemplate.dispose();
                this.registeredPolicyTemplates.remove(registeredPolicyTemplate.get());
            }
        });
        return registeredPolicyInstanceProvider.isPresent();
    }

    public synchronized boolean isPoliciesAvailable() {
        return !this.registeredPolicyInstanceProviders.isEmpty();
    }

    public boolean isSourcePoliciesAvailable() {
        return this.registeredPolicyInstanceProviders.stream().anyMatch(pip -> pip.getApplicationPolicyInstance().getSourcePolicy().isPresent());
    }

    public boolean isOperationPoliciesAvailable() {
        return this.registeredPolicyInstanceProviders.stream().anyMatch(pip -> pip.getApplicationPolicyInstance().getOperationPolicy().isPresent());
    }

    public void onPoliciesChanged(Runnable policiesChangedCallback) {
        this.policiesChangedCallback = () -> {
            policiesChangedCallback.run();
            this.updatePolicyAwareAttributes();
        };
    }

    private synchronized void updatePolicyAwareAttributes() {
        this.sourcePolicyAwareAttributes = this.registeredPolicyInstanceProviders.stream().filter(pip -> pip.getApplicationPolicyInstance().getPointcut() instanceof AttributeAwarePointcut).map(pip -> ((AttributeAwarePointcut)pip.getApplicationPolicyInstance().getPointcut()).sourcePolicyAwareAttributes()).reduce((PolicyAwareAttributes)SourcePolicyAwareAttributes.noAttributes(), PolicyAwareAttributes::merge);
    }

    public List<Policy> findSourceParameterizedPolicies(PolicyPointcutParameters policyPointcutParameters) {
        ArrayList<Policy> policies = new ArrayList<Policy>();
        if (!this.registeredPolicyInstanceProviders.isEmpty()) {
            for (RegisteredPolicyInstanceProvider registeredPolicyInstanceProvider : this.registeredPolicyInstanceProviders) {
                if (!registeredPolicyInstanceProvider.getApplicationPolicyInstance().getPointcut().matches(policyPointcutParameters) || !registeredPolicyInstanceProvider.getApplicationPolicyInstance().getSourcePolicy().isPresent()) continue;
                policies.add(registeredPolicyInstanceProvider.getApplicationPolicyInstance().getSourcePolicy().get());
            }
        }
        return policies;
    }

    public synchronized PolicyAwareAttributes sourcePolicyAwareAttributes() {
        return this.sourcePolicyAwareAttributes;
    }

    public List<Policy> findOperationParameterizedPolicies(PolicyPointcutParameters policyPointcutParameters) {
        ArrayList<Policy> policies = new ArrayList<Policy>();
        if (!this.registeredPolicyInstanceProviders.isEmpty()) {
            for (RegisteredPolicyInstanceProvider registeredPolicyInstanceProvider : this.registeredPolicyInstanceProviders) {
                if (!registeredPolicyInstanceProvider.getApplicationPolicyInstance().getPointcut().matches(policyPointcutParameters) || !registeredPolicyInstanceProvider.getApplicationPolicyInstance().getOperationPolicy().isPresent()) continue;
                policies.add(registeredPolicyInstanceProvider.getApplicationPolicyInstance().getOperationPolicy().get());
            }
        }
        return policies;
    }

    public void dispose() {
        for (RegisteredPolicyInstanceProvider registeredPolicyInstanceProvider : this.registeredPolicyInstanceProviders) {
            registeredPolicyInstanceProvider.getApplicationPolicyInstance().dispose();
        }
        this.registeredPolicyInstanceProviders.clear();
        for (RegisteredPolicyTemplate registeredPolicyTemplate : this.registeredPolicyTemplates) {
            try {
                registeredPolicyTemplate.policyTemplate.dispose();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            this.registeredPolicyTemplates.clear();
        }
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public List<RegisteredPolicyInstanceProvider> getRegisteredPolicyInstanceProviders() {
        return Collections.unmodifiableList(this.registeredPolicyInstanceProviders);
    }

    static String createPolicyAlreadyRegisteredError(String policyId) {
        return String.format("Policy already registered: '%s'", policyId);
    }

    static String createPolicyRegistrationError(String policyId) {
        return String.format("Error occured registering policy '%s'", policyId);
    }

    public static class RegisteredPolicyInstanceProvider
    implements Comparable<RegisteredPolicyInstanceProvider> {
        private final ApplicationPolicyInstance applicationPolicyInstance;
        private final String policyId;
        private int order;

        public RegisteredPolicyInstanceProvider(ApplicationPolicyInstance applicationPolicyInstance, String policyId) {
            this.applicationPolicyInstance = applicationPolicyInstance;
            this.policyId = policyId;
            this.order = applicationPolicyInstance.getOrder();
        }

        public void updateOrder(int newOrder) {
            this.order = newOrder;
        }

        @Override
        public int compareTo(RegisteredPolicyInstanceProvider registeredPolicyInstanceProvider) {
            return Integer.compare(this.order, registeredPolicyInstanceProvider.order);
        }

        public ApplicationPolicyInstance getApplicationPolicyInstance() {
            return this.applicationPolicyInstance;
        }

        public String getPolicyId() {
            return this.policyId;
        }
    }

    public static class RegisteredPolicyTemplate {
        private volatile int count;
        private final PolicyTemplate policyTemplate;

        RegisteredPolicyTemplate(PolicyTemplate policyTemplate) {
            this.policyTemplate = policyTemplate;
        }
    }
}

