/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.policy.loader;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.util.Map;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfiguration;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfigurationLoader;
import org.mule.runtime.module.artifact.api.descriptor.InvalidDescriptorLoaderException;

public class FileSystemPolicyClassLoaderConfigurationLoader
implements ClassLoaderConfigurationLoader {
    public static final String FILE_SYSTEM_POLICY_MODEL_LOADER_ID = "FILE_SYSTEM_POLICY_MODEL_LOADER";
    public static final String LIB_DIR = "lib";
    private static final String JAR_FILE = ".jar";

    public String getId() {
        return FILE_SYSTEM_POLICY_MODEL_LOADER_ID;
    }

    public ClassLoaderConfiguration load(File artifactFolder, Map<String, Object> attributes, ArtifactType artifactType) throws InvalidDescriptorLoaderException {
        ClassLoaderConfiguration.ClassLoaderConfigurationBuilder classLoaderConfigurationBuilder = new ClassLoaderConfiguration.ClassLoaderConfigurationBuilder();
        this.loadUrls(classLoaderConfigurationBuilder, artifactFolder);
        return classLoaderConfigurationBuilder.build();
    }

    public boolean supportsArtifactType(ArtifactType artifactType) {
        return true;
    }

    private void loadUrls(ClassLoaderConfiguration.ClassLoaderConfigurationBuilder classLoaderConfigurationBuilder, File artifactFolder) throws InvalidDescriptorLoaderException {
        try {
            classLoaderConfigurationBuilder.containing(artifactFolder.toURI().toURL());
            File libDir = new File(artifactFolder, LIB_DIR);
            if (libDir.exists()) {
                File[] jars;
                for (File jar : jars = libDir.listFiles((FilenameFilter)new SuffixFileFilter(JAR_FILE))) {
                    classLoaderConfigurationBuilder.containing(jar.toURI().toURL());
                }
            }
        }
        catch (MalformedURLException e) {
            throw new InvalidDescriptorLoaderException("Failed to create plugin descriptor " + artifactFolder);
        }
    }
}

