/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.policy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.internal.FilteringContainerClassLoader;
import org.mule.runtime.container.internal.IsolatedPolicyClassLoader;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPlugin;
import org.mule.runtime.deployment.model.api.plugin.resolver.PluginDependenciesResolver;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplate;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplateDescriptor;
import org.mule.runtime.deployment.model.internal.DefaultRegionPluginClassLoadersFactory;
import org.mule.runtime.deployment.model.internal.policy.PolicyTemplateClassLoaderBuilder;
import org.mule.runtime.module.artifact.api.Artifact;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.DefaultArtifactClassLoaderFilter;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.internal.util.FeatureFlaggingUtils;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactFactoryUtils;
import org.mule.runtime.module.deployment.impl.internal.plugin.DefaultArtifactPlugin;
import org.mule.runtime.module.deployment.impl.internal.policy.DefaultPolicyTemplate;
import org.mule.runtime.module.deployment.impl.internal.policy.PolicyTemplateClassLoaderBuilderFactory;
import org.mule.runtime.module.deployment.impl.internal.policy.PolicyTemplateCreationException;
import org.mule.runtime.module.deployment.impl.internal.policy.PolicyTemplateFactory;
import org.mule.runtime.module.license.api.LicenseValidator;

public class DefaultPolicyTemplateFactory
implements PolicyTemplateFactory {
    private final PolicyTemplateClassLoaderBuilderFactory policyTemplateClassLoaderBuilderFactory;
    private final PluginDependenciesResolver pluginDependenciesResolver;
    private final LicenseValidator licenseValidator;

    public DefaultPolicyTemplateFactory(PolicyTemplateClassLoaderBuilderFactory policyTemplateClassLoaderBuilderFactory, PluginDependenciesResolver pluginDependenciesResolver, LicenseValidator licenseValidator) {
        Preconditions.checkArgument((policyTemplateClassLoaderBuilderFactory != null ? 1 : 0) != 0, (String)"policyTemplateClassLoaderBuilderFactory cannot be null");
        this.policyTemplateClassLoaderBuilderFactory = policyTemplateClassLoaderBuilderFactory;
        this.pluginDependenciesResolver = pluginDependenciesResolver;
        this.licenseValidator = licenseValidator;
    }

    @Override
    public PolicyTemplate createArtifact(Application application, PolicyTemplateDescriptor descriptor) {
        MuleDeployableArtifactClassLoader policyClassLoader;
        MuleDeployableArtifactClassLoader ownPolicyClassLoader;
        FilteringContainerClassLoader containerClassLoader = this.policyTemplateClassLoaderBuilderFactory.getFilteringContainerClassLoader();
        List<ArtifactPluginDescriptor> resolvedPolicyPluginsDescriptors = this.resolvePolicyPluginDescriptors(application, descriptor);
        List ownResolvedPluginDescriptors = this.pluginDependenciesResolver.resolve(Collections.emptySet(), new ArrayList(descriptor.getPlugins()), false);
        try {
            Object parentClassLoader = containerClassLoader != null && this.isPolicyIsolationEnabled(descriptor) && this.hasRequiredPlugin(descriptor) ? IsolatedPolicyClassLoader.getInstance((FilteringContainerClassLoader)containerClassLoader) : application.getRegionClassLoader();
            ownPolicyClassLoader = ((PolicyTemplateClassLoaderBuilder)((PolicyTemplateClassLoaderBuilder)this.policyTemplateClassLoaderBuilderFactory.createArtifactClassLoaderBuilder().addArtifactPluginDescriptors(ownResolvedPluginDescriptors.toArray(new ArtifactPluginDescriptor[ownResolvedPluginDescriptors.size()]))).setParentClassLoader((ArtifactClassLoader)parentClassLoader).setArtifactDescriptor((ArtifactDescriptor)descriptor)).build();
            policyClassLoader = ((PolicyTemplateClassLoaderBuilder)((PolicyTemplateClassLoaderBuilder)this.policyTemplateClassLoaderBuilderFactory.createArtifactClassLoaderBuilder().addArtifactPluginDescriptors(resolvedPolicyPluginsDescriptors.toArray(new ArtifactPluginDescriptor[resolvedPolicyPluginsDescriptors.size()]))).setParentClassLoader((ArtifactClassLoader)parentClassLoader).setArtifactDescriptor((ArtifactDescriptor)descriptor)).build();
        }
        catch (Exception e) {
            throw new PolicyTemplateCreationException(DefaultPolicyTemplateFactory.createPolicyTemplateCreationErrorMessage(descriptor.getName()), e);
        }
        application.getRegionClassLoader().addClassLoader((ArtifactClassLoader)policyClassLoader, DefaultArtifactClassLoaderFilter.NULL_CLASSLOADER_FILTER);
        List<ArtifactPlugin> artifactPlugins = this.createArtifactPluginList(policyClassLoader, resolvedPolicyPluginsDescriptors);
        ArtifactFactoryUtils.validateArtifactLicense(policyClassLoader.getClassLoader(), artifactPlugins, this.licenseValidator);
        return new DefaultPolicyTemplate(policyClassLoader.getArtifactId(), descriptor, policyClassLoader, artifactPlugins, this.resolveOwnArtifactPlugins(artifactPlugins, ownResolvedPluginDescriptors, ownPolicyClassLoader));
    }

    private boolean isPolicyIsolationEnabled(PolicyTemplateDescriptor descriptor) {
        return FeatureFlaggingUtils.isFeatureEnabled((Feature)MuleRuntimeFeature.ENABLE_POLICY_ISOLATION, (ArtifactDescriptor)descriptor) && FeatureFlaggingUtils.isFeatureEnabled((Feature)MuleRuntimeFeature.SEPARATE_CLASSLOADER_FOR_POLICY_ISOLATION, (ArtifactDescriptor)descriptor);
    }

    private boolean hasRequiredPlugin(PolicyTemplateDescriptor descriptor) {
        if (descriptor == null || descriptor.getPlugins() == null) {
            return false;
        }
        Set plugins = descriptor.getPlugins();
        for (ArtifactPluginDescriptor plugin : plugins) {
            if (!this.isRequiredPlugin(plugin)) continue;
            return true;
        }
        return false;
    }

    private boolean isRequiredPlugin(ArtifactPluginDescriptor plugin) {
        return plugin.getName().equals("HTTP") || plugin.getName().equals("Sockets");
    }

    private List<ArtifactPlugin> resolveOwnArtifactPlugins(List<ArtifactPlugin> artifactPlugins, List<ArtifactPluginDescriptor> ownResolvedPluginDescriptors, MuleDeployableArtifactClassLoader ownPolicyClassLoader) {
        return ownResolvedPluginDescriptors.stream().map(pluginDescriptor -> artifactPlugins.stream().filter(artifactPlugin -> ((ArtifactPluginDescriptor)artifactPlugin.getDescriptor()).getName().equals(pluginDescriptor.getName())).findFirst().orElseGet(() -> new DefaultArtifactPlugin(DefaultRegionPluginClassLoadersFactory.getArtifactPluginId((String)ownPolicyClassLoader.getArtifactId(), (String)pluginDescriptor.getName()), (ArtifactPluginDescriptor)pluginDescriptor, ownPolicyClassLoader.getArtifactPluginClassLoaders().stream().filter(artifactClassLoader -> artifactClassLoader.getArtifactId().endsWith(pluginDescriptor.getName())).findFirst().get()))).collect(Collectors.toList());
    }

    private List<ArtifactPluginDescriptor> resolvePolicyPluginDescriptors(Application application, PolicyTemplateDescriptor descriptor) {
        LinkedList providedArtifactPlugins = new LinkedList();
        providedArtifactPlugins.addAll(application.getArtifactPlugins());
        providedArtifactPlugins.addAll(application.getDomain().getArtifactPlugins());
        Set providedArtifactPluginsDescriptors = providedArtifactPlugins.stream().map(Artifact::getDescriptor).collect(Collectors.toSet());
        List resolvedPlugins = this.pluginDependenciesResolver.resolve(providedArtifactPluginsDescriptors, new ArrayList(descriptor.getPlugins()), false);
        if (this.hasRequiredPlugin(descriptor)) {
            Set resolvedNames = resolvedPlugins.stream().map(ArtifactDescriptor::getName).collect(Collectors.toSet());
            descriptor.getPlugins().stream().filter(plugin -> this.isRequiredPlugin((ArtifactPluginDescriptor)plugin) && !resolvedNames.contains(plugin.getName())).forEach(resolvedPlugins::add);
        }
        return resolvedPlugins;
    }

    private List<ArtifactPlugin> createArtifactPluginList(MuleDeployableArtifactClassLoader policyClassLoader, List<ArtifactPluginDescriptor> plugins) {
        return plugins.stream().filter(artifactPluginDescriptor -> policyClassLoader.getArtifactPluginClassLoaders().stream().anyMatch(artifactClassLoader -> artifactClassLoader.getArtifactId().endsWith(artifactPluginDescriptor.getName()))).map(artifactPluginDescriptor -> new DefaultArtifactPlugin(DefaultRegionPluginClassLoadersFactory.getArtifactPluginId((String)policyClassLoader.getArtifactId(), (String)artifactPluginDescriptor.getName()), (ArtifactPluginDescriptor)artifactPluginDescriptor, policyClassLoader.getArtifactPluginClassLoaders().stream().filter(artifactClassLoader -> artifactClassLoader.getArtifactId().endsWith(artifactPluginDescriptor.getName())).findFirst().get())).collect(Collectors.toList());
    }

    static String createPolicyTemplateCreationErrorMessage(String policyName) {
        return String.format("Cannot create policy template '%s'", policyName);
    }
}

