/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.api.policy;

import java.util.Collections;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplateDescriptor;
import org.mule.runtime.module.artifact.descriptor.ClassLoaderModel;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class PolicyTemplateDescriptorTestCase
extends AbstractMuleTestCase {
    private static final String POLICY_NAME = "policyName";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void verifiesPolicyTemplateDoesNotExportPackages() throws Exception {
        PolicyTemplateDescriptor policyTemplateDescriptor = new PolicyTemplateDescriptor(POLICY_NAME);
        ClassLoaderModel classLoaderModel = (ClassLoaderModel)Mockito.mock(ClassLoaderModel.class);
        Mockito.when((Object)classLoaderModel.getExportedPackages()).thenReturn(Collections.singleton("org.foo"));
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("A policy template artifact cannot export packages");
        policyTemplateDescriptor.setClassLoaderModel(classLoaderModel);
    }

    @Test
    public void verifiesPolicyTemplateDoesNotExportResources() throws Exception {
        PolicyTemplateDescriptor policyTemplateDescriptor = new PolicyTemplateDescriptor(POLICY_NAME);
        ClassLoaderModel classLoaderModel = (ClassLoaderModel)Mockito.mock(ClassLoaderModel.class);
        Mockito.when((Object)classLoaderModel.getExportedResources()).thenReturn(Collections.singleton("META-INF/foo.xml"));
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("A policy template artifact cannot export resources");
        policyTemplateDescriptor.setClassLoaderModel(classLoaderModel);
    }
}

