/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.domain;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.deployment.model.internal.domain.MuleSharedDomainClassLoader;
import org.mule.runtime.module.artifact.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptor;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.size.SmallTest;

@SmallTest
public class MuleSharedDomainClassLoaderTestCase
extends AbstractMuleTestCase {
    public static final String RESOURCE_FILE_NAME = "file.properties";
    public static final String DEFAULT_DOMAIN_NAME = "default";
    @ClassRule
    public static TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public final SystemProperty muleHomeSystemProperty = new SystemProperty("mule.home", temporaryFolder.getRoot().getCanonicalPath());
    private final File muleHomeFolder;
    private final ClassLoaderLookupPolicy lookupPolicy = (ClassLoaderLookupPolicy)Mockito.mock(ClassLoaderLookupPolicy.class);

    public MuleSharedDomainClassLoaderTestCase() throws IOException {
        this.muleHomeFolder = temporaryFolder.getRoot();
    }

    @Before
    public void setUp() throws IOException {
        temporaryFolder.delete();
        temporaryFolder.create();
    }

    @Test
    public void findResourcesInProvidedUrls() throws Exception {
        this.createDomainFolder(DEFAULT_DOMAIN_NAME);
        File resourceFile = this.createDomainResource(DEFAULT_DOMAIN_NAME, RESOURCE_FILE_NAME);
        List<URL> urls = Collections.singletonList(resourceFile.toURI().toURL());
        MuleSharedDomainClassLoader classLoader = new MuleSharedDomainClassLoader(new ArtifactDescriptor(DEFAULT_DOMAIN_NAME), ((Object)((Object)this)).getClass().getClassLoader(), this.lookupPolicy, urls);
        Assert.assertThat((Object)classLoader.findResource(RESOURCE_FILE_NAME), (Matcher)IsNull.notNullValue());
    }

    private File createDomainResource(String domainName, String resourceFile) throws Exception {
        File file = new File(this.getDomainFolder(domainName), resourceFile);
        Assert.assertThat((Object)FileUtils.createFile((String)file.getAbsolutePath()).exists(), (Matcher)Is.is((Object)true));
        return file;
    }

    private void createDomainFolder(String domainName) {
        Assert.assertThat((Object)this.getDomainFolder(domainName).mkdirs(), (Matcher)Is.is((Object)true));
    }

    private File getDomainFolder(String domainName) {
        return new File(this.muleHomeFolder, "domains" + File.separator + domainName);
    }
}

