/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.plugin.BundlePluginDependenciesResolver;
import org.mule.runtime.deployment.model.internal.plugin.DuplicateExportedPackageException;
import org.mule.runtime.deployment.model.internal.plugin.PluginDependenciesResolver;
import org.mule.runtime.deployment.model.internal.plugin.PluginResolutionError;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.descriptor.ClassLoaderModel;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class BundlePluginDependenciesResolverTestCase
extends AbstractMuleTestCase {
    private static final String FOO_PLUGIN = "foo";
    private static final String BAZ_PLUGIN = "baz";
    private static final String BAR_PLUGIN = "bar";
    public static final String DEPENDENCY_PROVIDER_ERROR_MESSAGE = "Bundle URL should have been resolved for %s.";
    private static final BundleDescriptor FOO_BUNDLE_DESCRIPTOR = BundlePluginDependenciesResolverTestCase.createTestBundleDescriptor("foo", "1.0");
    private static final BundleDescriptor BAZ_BUNDLE_DESCRIPTOR = BundlePluginDependenciesResolverTestCase.createTestBundleDescriptor("baz", "1.0");
    private static final BundleDescriptor BAR_BUNDLE_DESCRIPTOR = BundlePluginDependenciesResolverTestCase.createTestBundleDescriptor("bar", "1.0");
    private static final BundleDependency FOO_PLUGIN_DESCRIPTOR = BundlePluginDependenciesResolverTestCase.createBundleDependency(FOO_BUNDLE_DESCRIPTOR);
    private static final BundleDependency BAZ_PLUGIN_DESCRIPTOR = BundlePluginDependenciesResolverTestCase.createBundleDependency(BAZ_BUNDLE_DESCRIPTOR);
    private static final BundleDependency BAR_PLUGIN_DESCRIPTOR = BundlePluginDependenciesResolverTestCase.createBundleDependency(BAR_BUNDLE_DESCRIPTOR);
    private final ArtifactPluginDescriptor fooPlugin = new ArtifactPluginDescriptor("foo");
    private final ArtifactPluginDescriptor barPlugin = new ArtifactPluginDescriptor("bar");
    private final ArtifactPluginDescriptor bazPlugin = new ArtifactPluginDescriptor("baz");
    private final PluginDependenciesResolver dependenciesResolver = new BundlePluginDependenciesResolver((ArtifactDescriptorFactory)Mockito.mock(ArtifactDescriptorFactory.class));
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    private static BundleDependency createBundleDependency(BundleDescriptor bundleDescriptor) {
        return new BundleDependency.Builder().setDescriptor(bundleDescriptor).build();
    }

    private static BundleDescriptor createTestBundleDescriptor(String artifactId, String version) {
        return new BundleDescriptor.Builder().setGroupId("test").setArtifactId(artifactId).setVersion(version).setType("jar").setClassifier("mule-plugin").build();
    }

    @Before
    public void setUp() throws Exception {
        this.fooPlugin.setBundleDescriptor(FOO_BUNDLE_DESCRIPTOR);
        this.bazPlugin.setBundleDescriptor(BAZ_BUNDLE_DESCRIPTOR);
        this.barPlugin.setBundleDescriptor(BAR_BUNDLE_DESCRIPTOR);
    }

    @Test
    public void resolvesIndependentPlugins() throws Exception {
        List<ArtifactPluginDescriptor> pluginDescriptors = this.createPluginDescriptors(this.fooPlugin, this.barPlugin);
        List resolvedPluginDescriptors = this.dependenciesResolver.resolve(pluginDescriptors);
        this.assertResolvedPlugins(resolvedPluginDescriptors, this.barPlugin, this.fooPlugin);
    }

    @Test
    public void resolvesPluginOrderedDependency() throws Exception {
        List<ArtifactPluginDescriptor> pluginDescriptors = this.createPluginDescriptors(this.fooPlugin, this.barPlugin);
        this.barPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(FOO_PLUGIN_DESCRIPTOR)).build());
        List resolvedPluginDescriptors = this.dependenciesResolver.resolve(pluginDescriptors);
        this.assertResolvedPlugins(resolvedPluginDescriptors, this.fooPlugin, this.barPlugin);
    }

    @Test
    public void resolvesPluginDisorderedDependency() throws Exception {
        List<ArtifactPluginDescriptor> pluginDescriptors = this.createPluginDescriptors(this.barPlugin, this.fooPlugin);
        this.barPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(FOO_PLUGIN_DESCRIPTOR)).build());
        List resolvedPluginDescriptors = this.dependenciesResolver.resolve(pluginDescriptors);
        this.assertResolvedPlugins(resolvedPluginDescriptors, this.fooPlugin, this.barPlugin);
    }

    @Test
    public void resolvesPluginDependencyWithCompatibleMinorVersion() throws Exception {
        ArtifactPluginDescriptor updatedFooPlugin = new ArtifactPluginDescriptor(FOO_PLUGIN);
        updatedFooPlugin.setBundleDescriptor(BundlePluginDependenciesResolverTestCase.createTestBundleDescriptor(FOO_PLUGIN, "1.1"));
        List<ArtifactPluginDescriptor> pluginDescriptors = this.createPluginDescriptors(updatedFooPlugin, this.barPlugin);
        this.barPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(BundlePluginDependenciesResolverTestCase.createBundleDependency(FOO_BUNDLE_DESCRIPTOR))).build());
        List resolvedPluginDescriptors = this.dependenciesResolver.resolve(pluginDescriptors);
        this.assertResolvedPlugins(resolvedPluginDescriptors, updatedFooPlugin, this.barPlugin);
    }

    @Test
    public void resolvesPluginDependencyWithSnapshotMinorVersion() throws Exception {
        ArtifactPluginDescriptor updatedFooPlugin = new ArtifactPluginDescriptor(FOO_PLUGIN);
        updatedFooPlugin.setBundleDescriptor(BundlePluginDependenciesResolverTestCase.createTestBundleDescriptor(FOO_PLUGIN, "1.1-SNAPSHOT"));
        List<ArtifactPluginDescriptor> pluginDescriptors = this.createPluginDescriptors(updatedFooPlugin, this.barPlugin);
        this.barPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(BundlePluginDependenciesResolverTestCase.createBundleDependency(FOO_BUNDLE_DESCRIPTOR))).build());
        List resolvedPluginDescriptors = this.dependenciesResolver.resolve(pluginDescriptors);
        this.assertResolvedPlugins(resolvedPluginDescriptors, updatedFooPlugin, this.barPlugin);
    }

    @Test
    public void resolvesSnapshotPluginDependencyWithCompatibleMinorVersion() throws Exception {
        ArtifactPluginDescriptor updatedFooPlugin = new ArtifactPluginDescriptor(FOO_PLUGIN);
        updatedFooPlugin.setBundleDescriptor(BundlePluginDependenciesResolverTestCase.createTestBundleDescriptor(FOO_PLUGIN, "1.1"));
        List<ArtifactPluginDescriptor> pluginDescriptors = this.createPluginDescriptors(updatedFooPlugin, this.barPlugin);
        BundleDescriptor fooBundleDescriptor = BundlePluginDependenciesResolverTestCase.createTestBundleDescriptor(FOO_PLUGIN, "1.0-SNAPSHOT");
        this.barPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(BundlePluginDependenciesResolverTestCase.createBundleDependency(fooBundleDescriptor))).build());
        List resolvedPluginDescriptors = this.dependenciesResolver.resolve(pluginDescriptors);
        this.assertResolvedPlugins(resolvedPluginDescriptors, updatedFooPlugin, this.barPlugin);
    }

    @Test(expected=PluginResolutionError.class)
    public void doesNotResolvesPluginDependencyWithIncompatibleMajorVersion() throws Exception {
        ArtifactPluginDescriptor majorUpdatedFooPlugin = new ArtifactPluginDescriptor(FOO_PLUGIN);
        majorUpdatedFooPlugin.setBundleDescriptor(BundlePluginDependenciesResolverTestCase.createTestBundleDescriptor(FOO_PLUGIN, "2.0"));
        List<ArtifactPluginDescriptor> pluginDescriptors = this.createPluginDescriptors(majorUpdatedFooPlugin, this.barPlugin);
        this.barPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(BundlePluginDependenciesResolverTestCase.createBundleDependency(FOO_BUNDLE_DESCRIPTOR))).build());
        this.dependenciesResolver.resolve(pluginDescriptors);
    }

    @Test(expected=PluginResolutionError.class)
    public void doesNotResolvesPluginDependencyWithIncompatibleMinorVersion() throws Exception {
        ArtifactPluginDescriptor majorUpdatedFooPlugin = new ArtifactPluginDescriptor(FOO_PLUGIN);
        majorUpdatedFooPlugin.setBundleDescriptor(BundlePluginDependenciesResolverTestCase.createTestBundleDescriptor(FOO_PLUGIN, "1.1"));
        List<ArtifactPluginDescriptor> pluginDescriptors = this.createPluginDescriptors(this.fooPlugin, this.barPlugin);
        this.barPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(BundlePluginDependenciesResolverTestCase.createBundleDependency(majorUpdatedFooPlugin.getBundleDescriptor()))).build());
        this.dependenciesResolver.resolve(pluginDescriptors);
    }

    @Test
    public void detectsUnresolvablePluginDependency() throws Exception {
        List<ArtifactPluginDescriptor> pluginDescriptors = this.createPluginDescriptors(this.fooPlugin);
        this.fooPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(BAR_PLUGIN_DESCRIPTOR)).build());
        this.expectedException.expect(PluginResolutionError.class);
        this.expectedException.expectMessage(String.format(DEPENDENCY_PROVIDER_ERROR_MESSAGE, BAR_BUNDLE_DESCRIPTOR));
        this.dependenciesResolver.resolve(pluginDescriptors);
    }

    @Test
    public void resolvesTransitiveDependencies() throws Exception {
        List<ArtifactPluginDescriptor> pluginDescriptors = this.createPluginDescriptors(this.fooPlugin, this.barPlugin, this.bazPlugin);
        this.barPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(BAZ_PLUGIN_DESCRIPTOR)).build());
        this.bazPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(FOO_PLUGIN_DESCRIPTOR)).build());
        List resolvedPluginDescriptors = this.dependenciesResolver.resolve(pluginDescriptors);
        this.assertResolvedPlugins(resolvedPluginDescriptors, this.fooPlugin, this.bazPlugin, this.barPlugin);
    }

    @Test
    public void resolvesMultipleDependencies() throws Exception {
        List<ArtifactPluginDescriptor> pluginDescriptors = this.createPluginDescriptors(this.fooPlugin, this.barPlugin, this.bazPlugin);
        this.barPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(BAZ_PLUGIN_DESCRIPTOR)).build());
        this.bazPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(FOO_PLUGIN_DESCRIPTOR)).build());
        List resolvedPluginDescriptors = this.dependenciesResolver.resolve(pluginDescriptors);
        this.assertResolvedPlugins(resolvedPluginDescriptors, this.fooPlugin, this.bazPlugin, this.barPlugin);
    }

    @Test
    public void sanitizesDependantPluginExportedPackages() throws Exception {
        this.fooPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().exportingPackages(this.getFooExportedPackages()).build());
        this.barPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(FOO_PLUGIN_DESCRIPTOR)).exportingPackages(this.getBarExportedPackages()).build());
        List<ArtifactPluginDescriptor> pluginDescriptors = this.createPluginDescriptors(this.fooPlugin, this.barPlugin);
        List resolvedPluginDescriptors = this.dependenciesResolver.resolve(pluginDescriptors);
        this.assertResolvedPlugins(resolvedPluginDescriptors, this.fooPlugin, this.barPlugin);
        this.assertPluginExportedPackages(this.fooPlugin, "org.foo", "org.foo.mule");
        this.assertPluginExportedPackages(this.barPlugin, "org.bar", "org.baz", "org.bar.mule");
    }

    @Test
    public void sanitizesTransitiveDependantPluginExportedPackages() throws Exception {
        this.fooPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().exportingPackages(this.getFooExportedPackages()).build());
        this.bazPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().exportingPackages(this.getBazExportedPackages()).dependingOn(Collections.singleton(FOO_PLUGIN_DESCRIPTOR)).build());
        this.barPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().exportingPackages(this.getBarExportedPackages()).dependingOn(Collections.singleton(BAZ_PLUGIN_DESCRIPTOR)).build());
        List<ArtifactPluginDescriptor> pluginDescriptors = this.createPluginDescriptors(this.fooPlugin, this.barPlugin, this.bazPlugin);
        List resolvedPluginDescriptors = this.dependenciesResolver.resolve(pluginDescriptors);
        this.assertResolvedPlugins(resolvedPluginDescriptors, this.fooPlugin, this.bazPlugin, this.barPlugin);
        this.assertPluginExportedPackages(this.fooPlugin, "org.foo", "org.foo.mule");
        this.assertPluginExportedPackages(this.bazPlugin, "org.baz");
        this.assertPluginExportedPackages(this.barPlugin, "org.bar", "org.bar.mule");
    }

    @Test
    public void detectsDuplicateExportedPackagesOnIndependentPlugins() throws Exception {
        this.fooPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().exportingPackages(this.getFooExportedPackages()).build());
        this.barPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().exportingPackages(this.getBarExportedPackages()).build());
        List<ArtifactPluginDescriptor> pluginDescriptors = this.createPluginDescriptors(this.fooPlugin, this.barPlugin);
        HashMap<String, List<String>> pluginsPerPackage = new HashMap<String, List<String>>();
        pluginsPerPackage.put("org.foo", Arrays.asList("bar, foo"));
        pluginsPerPackage.put("org.foo.mule", Arrays.asList("bar, foo"));
        String expectedErrorMessage = new DuplicateExportedPackageException(pluginsPerPackage).getMessage();
        this.expectedException.expect(DuplicateExportedPackageException.class);
        this.expectedException.expectMessage(expectedErrorMessage);
        this.dependenciesResolver.resolve(pluginDescriptors);
    }

    private Set<String> getBarExportedPackages() {
        HashSet<String> barExportedClassPackages = new HashSet<String>();
        barExportedClassPackages.add("org.bar");
        barExportedClassPackages.add("org.baz");
        barExportedClassPackages.add("org.foo");
        barExportedClassPackages.add("org.foo.mule");
        barExportedClassPackages.add("org.bar.mule");
        return barExportedClassPackages;
    }

    private Set<String> getFooExportedPackages() {
        HashSet<String> fooExportedClassPackages = new HashSet<String>();
        fooExportedClassPackages.add("org.foo");
        fooExportedClassPackages.add("org.foo.mule");
        return fooExportedClassPackages;
    }

    private Set<String> getBazExportedPackages() {
        HashSet<String> bazExportedClassPackages = new HashSet<String>();
        bazExportedClassPackages.add("org.baz");
        return bazExportedClassPackages;
    }

    private void assertResolvedPlugins(List<ArtifactPluginDescriptor> resolvedPluginDescriptors, ArtifactPluginDescriptor ... expectedPluginDescriptors) {
        MatcherAssert.assertThat((Object)resolvedPluginDescriptors.size(), (Matcher)Matchers.equalTo((Object)expectedPluginDescriptors.length));
        MatcherAssert.assertThat(resolvedPluginDescriptors, (Matcher)Matchers.hasItems((Object[])expectedPluginDescriptors));
    }

    private void assertPluginExportedPackages(ArtifactPluginDescriptor pluginDescriptor, String ... exportedPackages) {
        MatcherAssert.assertThat((Object)pluginDescriptor.getClassLoaderModel().getExportedPackages().size(), (Matcher)Matchers.equalTo((Object)exportedPackages.length));
        MatcherAssert.assertThat((Object)pluginDescriptor.getClassLoaderModel().getExportedPackages(), (Matcher)Matchers.containsInAnyOrder((Object[])exportedPackages));
    }

    private List<ArtifactPluginDescriptor> createPluginDescriptors(ArtifactPluginDescriptor ... descriptors) {
        ArrayList<ArtifactPluginDescriptor> result = new ArrayList<ArtifactPluginDescriptor>();
        for (ArtifactPluginDescriptor descriptor : descriptors) {
            result.add(descriptor);
        }
        return result;
    }
}

