/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.tooling;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.AbstractArtifactClassLoaderBuilder;
import org.mule.runtime.deployment.model.internal.plugin.PluginResolutionError;
import org.mule.runtime.deployment.model.internal.tooling.ToolingPluginArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoaderFilter;
import org.mule.runtime.module.artifact.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.classloader.DisposableClassLoader;
import org.mule.runtime.module.artifact.classloader.ParentFirstLookupStrategy;
import org.mule.runtime.module.artifact.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.classloader.TestArtifactClassLoader;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptor;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class ToolingPluginArtifactClassLoaderTestCase
extends AbstractMuleTestCase {
    private static final String PLUGIN_NAME = "test-plugin";
    private static final String TEST_REGION = "test-region";
    private static final String REGION_NAME = "test-region-descriptor";
    private RegionClassLoader regionClassLoader;
    private ArtifactPluginDescriptor artifactPluginDescriptor;
    private TestToolingPluginClassLoader pluginArtifactClassLoader;

    @Before
    public void createAppClassLoader() {
        ClassLoaderLookupPolicy classLoaderLookupPolicy = (ClassLoaderLookupPolicy)Mockito.mock(ClassLoaderLookupPolicy.class);
        Mockito.when((Object)classLoaderLookupPolicy.getClassLookupStrategy(org.mockito.Matchers.anyString())).thenReturn((Object)ParentFirstLookupStrategy.PARENT_FIRST);
        this.regionClassLoader = new RegionClassLoader(TEST_REGION, new ArtifactDescriptor(REGION_NAME), ((Object)((Object)this)).getClass().getClassLoader(), classLoaderLookupPolicy);
        this.regionClassLoader.addClassLoader((ArtifactClassLoader)Mockito.mock(ArtifactClassLoader.class), (ArtifactClassLoaderFilter)Mockito.mock(ArtifactClassLoaderFilter.class));
        this.artifactPluginDescriptor = new ArtifactPluginDescriptor(PLUGIN_NAME);
        this.pluginArtifactClassLoader = (TestToolingPluginClassLoader)((Object)Mockito.spy((Object)((Object)new TestToolingPluginClassLoader(this.artifactPluginDescriptor))));
    }

    @Test(expected=PluginResolutionError.class)
    public void createClassLoaderWithEmptyPluginList() {
        new ToolingPluginArtifactClassLoader(this.regionClassLoader, this.artifactPluginDescriptor);
    }

    @Test
    public void createsClassLoaderSinglePlugin() throws Exception {
        this.regionClassLoader.addClassLoader((ArtifactClassLoader)this.pluginArtifactClassLoader, (ArtifactClassLoaderFilter)Mockito.mock(ArtifactClassLoaderFilter.class));
        ToolingPluginArtifactClassLoader toolingPluginArtifactClassLoader = new ToolingPluginArtifactClassLoader(this.regionClassLoader, this.artifactPluginDescriptor);
        MatcherAssert.assertThat((Object)this.regionClassLoader.getArtifactPluginClassLoaders().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.pluginArtifactClassLoader.disposed, (Matcher)Matchers.is((Object)false));
        toolingPluginArtifactClassLoader.dispose();
        MatcherAssert.assertThat((Object)this.pluginArtifactClassLoader.disposed, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void createsClassLoaderMultiplePlugin() throws Exception {
        TestToolingPluginClassLoader anotherPluginClassLoader = new TestToolingPluginClassLoader(new ArtifactPluginDescriptor("test-another-plugin-descriptor"));
        this.regionClassLoader.addClassLoader((ArtifactClassLoader)anotherPluginClassLoader, (ArtifactClassLoaderFilter)Mockito.mock(ArtifactClassLoaderFilter.class));
        this.regionClassLoader.addClassLoader((ArtifactClassLoader)this.pluginArtifactClassLoader, (ArtifactClassLoaderFilter)Mockito.mock(ArtifactClassLoaderFilter.class));
        ToolingPluginArtifactClassLoader toolingPluginArtifactClassLoader = new ToolingPluginArtifactClassLoader(this.regionClassLoader, this.artifactPluginDescriptor);
        MatcherAssert.assertThat((Object)this.regionClassLoader.getArtifactPluginClassLoaders().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)this.pluginArtifactClassLoader.disposed, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)anotherPluginClassLoader.disposed, (Matcher)Matchers.is((Object)false));
        toolingPluginArtifactClassLoader.dispose();
        MatcherAssert.assertThat((Object)this.pluginArtifactClassLoader.disposed, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)anotherPluginClassLoader.disposed, (Matcher)Matchers.is((Object)true));
    }

    private static class TestToolingPluginClassLoader
    extends TestArtifactClassLoader
    implements DisposableClassLoader {
        private final ArtifactPluginDescriptor artifactPluginDescriptor;
        private boolean disposed = false;

        public TestToolingPluginClassLoader(ArtifactPluginDescriptor artifactPluginDescriptor) {
            this.artifactPluginDescriptor = artifactPluginDescriptor;
        }

        public String getArtifactId() {
            return AbstractArtifactClassLoaderBuilder.getArtifactPluginId((String)"parentId", (String)this.artifactPluginDescriptor.getName());
        }

        public void dispose() {
            this.disposed = true;
        }
    }
}

